/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.jms.JmsTracing;
import brave.jms.TracingExceptionListener;
import brave.jms.TracingJMSConsumer;
import brave.jms.TracingJMSProducer;
import brave.jms.TracingXAJMSContext;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.XAJMSContext;

class TracingJMSContext
implements JMSContext {
    final JMSContext delegate;
    final JmsTracing jmsTracing;

    static JMSContext create(JMSContext delegate, JmsTracing jmsTracing) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        if (jmsTracing == null) {
            throw new NullPointerException("jmsTracing == null");
        }
        if (delegate instanceof XAJMSContext) {
            return new TracingXAJMSContext((XAJMSContext)delegate, jmsTracing);
        }
        return new TracingJMSContext(delegate, jmsTracing);
    }

    TracingJMSContext(JMSContext delegate, JmsTracing jmsTracing) {
        this.delegate = delegate;
        this.jmsTracing = jmsTracing;
        ExceptionListener original = delegate.getExceptionListener();
        if (original != null) {
            delegate.setExceptionListener(TracingExceptionListener.create(original, jmsTracing));
        } else {
            delegate.setExceptionListener(TracingExceptionListener.create(jmsTracing));
        }
    }

    public JMSContext createContext(int sessionMode) {
        return new TracingJMSContext(this.delegate.createContext(sessionMode), this.jmsTracing);
    }

    public JMSProducer createProducer() {
        return new TracingJMSProducer(this.delegate.createProducer(), this.jmsTracing);
    }

    public String getClientID() {
        return this.delegate.getClientID();
    }

    public void setClientID(String clientID) {
        this.delegate.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public ExceptionListener getExceptionListener() {
        return this.delegate.getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.delegate.setExceptionListener(TracingExceptionListener.create(listener, this.jmsTracing));
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public void setAutoStart(boolean autoStart) {
        this.delegate.setAutoStart(autoStart);
    }

    public boolean getAutoStart() {
        return this.delegate.getAutoStart();
    }

    public void close() {
        this.delegate.close();
    }

    public BytesMessage createBytesMessage() {
        return this.delegate.createBytesMessage();
    }

    public MapMessage createMapMessage() {
        return this.delegate.createMapMessage();
    }

    public Message createMessage() {
        return this.delegate.createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.delegate.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.delegate.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() {
        return this.delegate.createStreamMessage();
    }

    public TextMessage createTextMessage() {
        return this.delegate.createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.delegate.createTextMessage(text);
    }

    public boolean getTransacted() {
        return this.delegate.getTransacted();
    }

    public int getSessionMode() {
        return this.delegate.getSessionMode();
    }

    public void commit() {
        this.delegate.commit();
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void recover() {
        this.delegate.recover();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return new TracingJMSConsumer(this.delegate.createConsumer(destination), destination, this.jmsTracing);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        JMSConsumer cDelegate = this.delegate.createConsumer(destination, messageSelector);
        return new TracingJMSConsumer(cDelegate, destination, this.jmsTracing);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        JMSConsumer cDelegate = this.delegate.createConsumer(destination, messageSelector, noLocal);
        return new TracingJMSConsumer(cDelegate, destination, this.jmsTracing);
    }

    public Queue createQueue(String queueName) {
        return this.delegate.createQueue(queueName);
    }

    public Topic createTopic(String topicName) {
        return this.delegate.createTopic(topicName);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return new TracingJMSConsumer(this.delegate.createDurableConsumer(topic, name), (Destination)topic, this.jmsTracing);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        JMSConsumer cDelegate = this.delegate.createDurableConsumer(topic, name, messageSelector, noLocal);
        return new TracingJMSConsumer(cDelegate, (Destination)topic, this.jmsTracing);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        JMSConsumer cDelegate = this.delegate.createSharedDurableConsumer(topic, name);
        return new TracingJMSConsumer(cDelegate, (Destination)topic, this.jmsTracing);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        JMSConsumer cDelegate = this.delegate.createSharedDurableConsumer(topic, name, messageSelector);
        return new TracingJMSConsumer(cDelegate, (Destination)topic, this.jmsTracing);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        JMSConsumer cDelegate = this.delegate.createSharedConsumer(topic, sharedSubscriptionName);
        return new TracingJMSConsumer(cDelegate, (Destination)topic, this.jmsTracing);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        JMSConsumer cDelegate = this.delegate.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        return new TracingJMSConsumer(cDelegate, (Destination)topic, this.jmsTracing);
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.delegate.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.delegate.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.delegate.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.delegate.createTemporaryTopic();
    }

    public void unsubscribe(String name) {
        this.delegate.unsubscribe(name);
    }

    public void acknowledge() {
        this.delegate.acknowledge();
    }
}

