/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc3986.fragments;

import java.util.NoSuchElementException;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;
import org.dmfs.rfc3986.Fragment;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.fragments.SimpleFragment;
import org.dmfs.rfc3986.validation.CharSets;

public final class OptionalLazyFragment
implements Optional<Fragment> {
    private final UriEncoded mUriEncoded;
    private Optional<Fragment> mDelegate;

    public OptionalLazyFragment(UriEncoded uriEncoded) {
        this.mUriEncoded = uriEncoded;
    }

    public boolean isPresent() {
        return this.fragment().isPresent();
    }

    public Fragment value(Fragment defaultValue) {
        return (Fragment)this.fragment().value((Object)defaultValue);
    }

    public Fragment value() throws NoSuchElementException {
        return (Fragment)this.fragment().value();
    }

    private Optional<Fragment> fragment() {
        if (this.mDelegate == null) {
            this.mDelegate = this.parsedFragment();
        }
        return this.mDelegate;
    }

    private Optional<Fragment> parsedFragment() {
        int i;
        UriEncoded uriEncoded = this.mUriEncoded;
        int count = uriEncoded.length();
        if (count == 0 || uriEncoded.charAt(0) != '#') {
            return Absent.absent();
        }
        for (i = 1; i < count && CharSets.FRAGMENT_CHAR.contains(uriEncoded.charAt(i)); ++i) {
        }
        if (i != count) {
            throw new IllegalArgumentException(String.format("Query %s contains illegal char %c at position %d", uriEncoded.toString(), Character.valueOf(uriEncoded.charAt(i)), i));
        }
        return new Present((Object)new SimpleFragment(uriEncoded.subSequence(1, count)));
    }
}

