/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.macros.core.repository;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.macros.core.client.MacrosFeignClient;
import org.qubership.atp.macros.core.converter.MacrosDtoConvertService;
import org.qubership.atp.macros.core.model.Macros;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class MacrosRepository {
    private static final Logger log = LoggerFactory.getLogger(MacrosRepository.class);
    private final MacrosFeignClient client;
    private final MacrosDtoConvertService macrosDtoConvertService;

    public List<Macros> findByProjectId(UUID projectId) {
        log.debug("findByProjectId {}", (Object)projectId);
        return this.macrosDtoConvertService.convertList((List)this.client.findAllByProject(projectId).getBody(), Macros.class);
    }

    public String evaluate(String content) {
        log.debug("evaluate {}", (Object)content);
        return (String)this.client.evaluate(content).getBody();
    }

    public MacrosRepository(MacrosFeignClient client, MacrosDtoConvertService macrosDtoConvertService) {
        this.client = client;
        this.macrosDtoConvertService = macrosDtoConvertService;
    }
}

