/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.ei.ntt.ExportConverterResult;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.Scope;
import org.qubership.atp.ei.ntt.settings.model.dal.SettingsResource;
import org.qubership.atp.ei.ntt.utils.NttModelLoader;
import org.springframework.util.FileSystemUtils;

public class NttExportConverterResult
implements ExportConverterResult {
    final List<Project> projects;
    final SettingsResource environments;
    final List<Scope> scopes;
    final boolean isExportCatalog;
    final Path workDir;

    public NttExportConverterResult(List<Project> projects, List<Scope> scopes, SettingsResource environments, boolean isExportCatalog, Path workDir) {
        this.projects = projects == null ? new ArrayList() : projects;
        this.environments = environments;
        this.scopes = scopes == null ? new ArrayList() : scopes;
        this.isExportCatalog = isExportCatalog;
        this.workDir = workDir;
    }

    @Override
    public void saveToFolder(Path saveToDir) throws IOException {
        boolean doPostDeleteSource = false;
        if (saveToDir.equals(this.workDir)) {
            doPostDeleteSource = true;
            saveToDir = Files.createDirectory(this.workDir.resolve("tmp"), new FileAttribute[0]);
        }
        NttModelLoader instance = NttModelLoader.getInstance();
        for (Project project : this.projects) {
            if (this.isExportCatalog) {
                instance.saveProject(project, saveToDir);
                continue;
            }
            instance.saveDataSet(project, saveToDir);
        }
        for (Scope scope : this.scopes) {
            instance.saveScope(scope, saveToDir);
        }
        if (this.environments != null) {
            instance.saveEnvironmentSettings(this.environments, saveToDir);
        }
        if (doPostDeleteSource) {
            List dirs = Files.list(this.workDir).collect(Collectors.toList());
            for (Path dir : dirs) {
                if (dir.equals(saveToDir)) continue;
                FileSystemUtils.deleteRecursively((Path)dir);
            }
            FileSystemUtils.copyRecursively((Path)saveToDir, (Path)this.workDir);
            FileSystemUtils.deleteRecursively((Path)saveToDir);
        }
    }
}

