/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.impl;

import java.util.Collections;
import java.util.List;
import org.qubership.atp.ei.ntt.model.Cloneable;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.NttTestCase;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.Template;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TestStep;
import org.qubership.atp.ei.ntt.model.TestSuite;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;
import org.qubership.atp.ei.ntt.model.impl.AbstractModelItem;
import org.qubership.atp.ei.ntt.utils.CommonUtils;
import org.qubership.atp.ei.ntt.utils.NttModelLoader;

public class ReferenceModelItem
extends AbstractModelItem
implements TestSuite,
NttTestCase,
TestStep,
Reference,
Cloneable<ReferenceModelItem> {
    private Template template;
    private String templProjName;
    private String templName;
    private String referenceId;
    private ModelItemType modelItemType;

    @Override
    public Template getTemplate() {
        this.updateTemplate();
        return this.template;
    }

    @Override
    public void setTemplate(Template localTemplate) {
        this.template = localTemplate;
        if (this.template != null) {
            this.modelItemType = this.template.getModelItemType();
            this.templName = this.template.getName();
            this.templProjName = this.template.getProject().getName();
        }
    }

    @Override
    public void setTemplate(ModelItemType miEnum, String templProjName, String templName) {
        this.modelItemType = miEnum;
        this.templProjName = templProjName;
        this.templName = templName;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String id) {
        this.referenceId = id;
    }

    @Override
    public String getRefName() {
        return super.getName();
    }

    @Override
    public String getName() {
        this.updateTemplate();
        if (this.template == null) {
            return "Illegal state: Lost reference";
        }
        if (!super.getName().equals("")) {
            return super.getName();
        }
        return String.format("Reference to [%s - %s]", this.templProjName, this.template.toString());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public ReferenceModelItem clone() {
        ReferenceModelItem referenceModelItem = new ReferenceModelItem();
        referenceModelItem.setTemplate(this.modelItemType, this.templProjName, this.templName);
        referenceModelItem.setName(super.getName());
        referenceModelItem.setReferenceId(CommonUtils.generateId());
        referenceModelItem.setParent(this.getParent());
        referenceModelItem.setDescription(this.getDescription());
        return referenceModelItem;
    }

    @Override
    public <T extends TreeNode> List<T> getChildren() {
        if (this.getTemplate() == null) {
            return Collections.emptyList();
        }
        return this.getTemplate().getChildren();
    }

    @Override
    public <T extends TreeNode> void setChildren(List<T> children) {
    }

    @Override
    public List<NttTestCase> getTestCases() {
        return ((TestSuite)this.getTemplate().getModelItem()).getTestCases();
    }

    @Override
    public void setTestCases(List<NttTestCase> cases) {
        ((TestSuite)this.getTemplate().getModelItem()).setTestCases(cases);
    }

    @Override
    public List<TestStep> getTestSteps() {
        return ((NttTestCase)this.getTemplate().getModelItem()).getTestSteps();
    }

    @Override
    public void setTestSteps(List<TestStep> steps) {
        ((NttTestCase)this.getTemplate().getModelItem()).setTestSteps(steps);
    }

    public List<TestAction> getActions() {
        return this.getTemplate().getModelItem().getActions();
    }

    @Override
    public void setActions(List<TestAction> actions) {
        ((TestStep)this.getTemplate().getModelItem()).setActions(actions);
    }

    @Override
    public ModelItemType getModelItemType() {
        if (this.modelItemType != null) {
            return this.modelItemType;
        }
        if (this.getParent() != null) {
            return ((ModelItem)this.getParent()).getModelItemType().next();
        }
        return null;
    }

    private void updateTemplate() {
        for (Project templProject : NttModelLoader.getInstance().getProjects(true)) {
            if (!templProject.getName().equals(this.templProjName)) continue;
            for (TreeNode template : templProject.getChildren()) {
                if (!template.getName().equals(this.templName) || ((Template)template).getModelItemType() != this.getModelItemType()) continue;
                this.template = (Template)template;
                return;
            }
        }
    }

    @Override
    public String getTemplProjName() {
        return this.templProjName;
    }

    @Override
    public String getTemplName() {
        if (this.template != null) {
            this.templName = this.template.getName();
        }
        return this.templName;
    }
}

