/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.controllers.api;

import org.qubership.atp.dataset.controllers.api.dto.datasetlists.lazy.DataSetListFlatDto;
import java.util.List;
import org.qubership.atp.dataset.controllers.api.dto.datasetlists.lazy.RefDataSetListFlatDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-01T11:12:13.228981569Z[Etc/UTC]")
@Validated
@Tag(name = "DataSetListLazyLoadingController", description = "Data Set List Lazy Loading Controller")
public interface DataSetListLazyLoadingControllerApi {

    /**
     * GET /dsl/lazy/{dataSetListId} : Returns information about the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListFlat",
        summary = "Returns information about the selected DSL.",
        tags = { "data-set-list-lazy-loading-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListFlatDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/lazy/{dataSetListId}",
        produces = { "application/json" }
    )
    ResponseEntity<DataSetListFlatDto> getDataSetListFlat(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId
    );


    /**
     * GET /dsl/lazy/{dataSetListId}/ReferenceByPath/{attributePath} : Returns information about the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param attributePath attributePath (required)
     * @param page  (optional)
     * @param size  (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getReferencedDataSetList",
        summary = "Returns information about the selected DSL.",
        tags = { "data-set-list-lazy-loading-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = RefDataSetListFlatDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/lazy/{dataSetListId}/ReferenceByPath/{attributePath}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<RefDataSetListFlatDto> getReferencedDataSetList(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "attributePath", description = "attributePath", required = true) @PathVariable("attributePath") String attributePath,
        @Parameter(name = "page", description = "") @Valid @RequestParam(value = "page", required = false) Integer page,
        @Parameter(name = "size", description = "") @Valid @RequestParam(value = "size", required = false) Integer size,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );


    /**
     * GET /dsl/lazy/{dataSetListId}/ReferenceByPath/rows/{attributePath} : Returns information about the selected DSL.
     *
     * @param dataSetListId dataSetListId (required)
     * @param attributePath attributePath (required)
     * @param page  (optional)
     * @param size  (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getReferencedDataSetListRows",
        summary = "Returns information about the selected DSL.",
        tags = { "data-set-list-lazy-loading-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = RefDataSetListFlatDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/dsl/lazy/{dataSetListId}/ReferenceByPath/rows/{attributePath}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<RefDataSetListFlatDto> getReferencedDataSetListRows(
        @Parameter(name = "dataSetListId", description = "dataSetListId", required = true) @PathVariable("dataSetListId") UUID dataSetListId,
        @Parameter(name = "attributePath", description = "attributePath", required = true) @PathVariable("attributePath") String attributePath,
        @Parameter(name = "page", description = "") @Valid @RequestParam(value = "page", required = false) Integer page,
        @Parameter(name = "size", description = "") @Valid @RequestParam(value = "size", required = false) Integer size,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) List<UUID> UUID
    );

}
