/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.dataset.controllers.api;

import org.qubership.atp.dataset.controllers.api.dto.testplans.DataSetListIdNameLabelsTestPlanViewDto;
import org.qubership.atp.dataset.controllers.api.dto.testplans.TestPlanDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-01T11:12:13.513245682Z[Etc/UTC]")
@Validated
@Tag(name = "TestPlanController", description = "Test Plan Controller")
public interface TestPlanControllerApi {

    /**
     * PUT /testplan/va/{vaId} : Creates new Test Plan with name provided.
     *
     * @param vaId vaId (required)
     * @param name name (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "Creates new Test Plan with name provided.",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/testplan/va/{vaId}",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> create(
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name
    );


    /**
     * DELETE /testplan/va/{vaId} : Deletes Test Plan with provided name.
     *
     * @param vaId vaId (required)
     * @param name name (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "Deletes Test Plan with provided name.",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/testplan/va/{vaId}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name
    );


    /**
     * GET /testplan/{testPlanId}/dsl : Returns dataSetLists with selected Test Plan
     *
     * @param testPlanId testPlanId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListsUnderTestPlan",
        summary = "Returns dataSetLists with selected Test Plan",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = DataSetListIdNameLabelsTestPlanViewDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/testplan/{testPlanId}/dsl",
        produces = { "application/json" }
    )
    ResponseEntity<List<DataSetListIdNameLabelsTestPlanViewDto>> getDataSetListsUnderTestPlan(
        @Parameter(name = "testPlanId", description = "testPlanId", required = true) @PathVariable("testPlanId") UUID testPlanId
    );


    /**
     * GET /testplan/va/{vaId} : Returns all test plans for selected visibility area.
     *
     * @param vaId vaId (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestPlans",
        summary = "Returns all test plans for selected visibility area.",
        tags = { "test-plan-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/testplan/va/{vaId}",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestPlanDto>> getTestPlans(
        @Parameter(name = "vaId", description = "vaId", required = true) @PathVariable("vaId") UUID vaId
    );

}
