package org.qubership.atp.dataset.controllers.api.dto.attributes;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.controllers.api.dto.attributes.AttributeTypeDto;
import org.qubership.atp.dataset.controllers.api.dto.attributes.ListValueResponseDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * AttributeCreateResponseDto
 */

@JsonTypeName("AttributeCreateResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-01T11:12:12.257885844Z[Etc/UTC]")
public class AttributeCreateResponseDto {

  @JsonProperty("dataSetListId")
  private UUID dataSetListId;

  @JsonProperty("dataSetListReference")
  private UUID dataSetListReference;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("listValues")
  @Valid
  private List<ListValueResponseDto> listValues = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("type")
  private AttributeTypeDto type;

  public AttributeCreateResponseDto dataSetListId(UUID dataSetListId) {
    this.dataSetListId = dataSetListId;
    return this;
  }

  /**
   * Get dataSetListId
   * @return dataSetListId
  */
  @Valid 
  @Schema(name = "dataSetListId", required = false)
  public UUID getDataSetListId() {
    return dataSetListId;
  }

  public void setDataSetListId(UUID dataSetListId) {
    this.dataSetListId = dataSetListId;
  }

  public AttributeCreateResponseDto dataSetListReference(UUID dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
    return this;
  }

  /**
   * Get dataSetListReference
   * @return dataSetListReference
  */
  @Valid 
  @Schema(name = "dataSetListReference", required = false)
  public UUID getDataSetListReference() {
    return dataSetListReference;
  }

  public void setDataSetListReference(UUID dataSetListReference) {
    this.dataSetListReference = dataSetListReference;
  }

  public AttributeCreateResponseDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public AttributeCreateResponseDto listValues(List<ListValueResponseDto> listValues) {
    this.listValues = listValues;
    return this;
  }

  public AttributeCreateResponseDto addListValuesItem(ListValueResponseDto listValuesItem) {
    if (this.listValues == null) {
      this.listValues = new ArrayList<>();
    }
    this.listValues.add(listValuesItem);
    return this;
  }

  /**
   * Get listValues
   * @return listValues
  */
  @Valid 
  @Schema(name = "listValues", required = false)
  public List<ListValueResponseDto> getListValues() {
    return listValues;
  }

  public void setListValues(List<ListValueResponseDto> listValues) {
    this.listValues = listValues;
  }

  public AttributeCreateResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AttributeCreateResponseDto type(AttributeTypeDto type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @Valid 
  @Schema(name = "type", required = false)
  public AttributeTypeDto getType() {
    return type;
  }

  public void setType(AttributeTypeDto type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeCreateResponseDto attributeCreateResponse = (AttributeCreateResponseDto) o;
    return Objects.equals(this.dataSetListId, attributeCreateResponse.dataSetListId) &&
        Objects.equals(this.dataSetListReference, attributeCreateResponse.dataSetListReference) &&
        Objects.equals(this.id, attributeCreateResponse.id) &&
        Objects.equals(this.listValues, attributeCreateResponse.listValues) &&
        Objects.equals(this.name, attributeCreateResponse.name) &&
        Objects.equals(this.type, attributeCreateResponse.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSetListId, dataSetListReference, id, listValues, name, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeCreateResponseDto {\n");
    sb.append("    dataSetListId: ").append(toIndentedString(dataSetListId)).append("\n");
    sb.append("    dataSetListReference: ").append(toIndentedString(dataSetListReference)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    listValues: ").append(toIndentedString(listValues)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

