package org.qubership.atp.dataset.controllers.api.dto.datasetlists;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CopyDataSetListsRequestDto
 */

@JsonTypeName("CopyDataSetListsRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-01T11:12:12.906932086Z[Etc/UTC]")
public class CopyDataSetListsRequestDto {

  @JsonProperty("dataSetListIds")
  @Valid
  private List<UUID> dataSetListIds = null;

  @JsonProperty("updateReferences")
  private Boolean updateReferences;

  @JsonProperty("postfix")
  private String postfix;

  @JsonProperty("prevNamePattern")
  private String prevNamePattern;

  public CopyDataSetListsRequestDto dataSetListIds(List<UUID> dataSetListIds) {
    this.dataSetListIds = dataSetListIds;
    return this;
  }

  public CopyDataSetListsRequestDto addDataSetListIdsItem(UUID dataSetListIdsItem) {
    if (this.dataSetListIds == null) {
      this.dataSetListIds = new ArrayList<>();
    }
    this.dataSetListIds.add(dataSetListIdsItem);
    return this;
  }

  /**
   * Get dataSetListIds
   * @return dataSetListIds
  */
  @Valid 
  @Schema(name = "dataSetListIds", required = false)
  public List<UUID> getDataSetListIds() {
    return dataSetListIds;
  }

  public void setDataSetListIds(List<UUID> dataSetListIds) {
    this.dataSetListIds = dataSetListIds;
  }

  public CopyDataSetListsRequestDto updateReferences(Boolean updateReferences) {
    this.updateReferences = updateReferences;
    return this;
  }

  /**
   * Get updateReferences
   * @return updateReferences
  */
  
  @Schema(name = "updateReferences", required = false)
  public Boolean getUpdateReferences() {
    return updateReferences;
  }

  public void setUpdateReferences(Boolean updateReferences) {
    this.updateReferences = updateReferences;
  }

  public CopyDataSetListsRequestDto postfix(String postfix) {
    this.postfix = postfix;
    return this;
  }

  /**
   * Get postfix
   * @return postfix
  */
  
  @Schema(name = "postfix", required = false)
  public String getPostfix() {
    return postfix;
  }

  public void setPostfix(String postfix) {
    this.postfix = postfix;
  }

  public CopyDataSetListsRequestDto prevNamePattern(String prevNamePattern) {
    this.prevNamePattern = prevNamePattern;
    return this;
  }

  /**
   * Get prevNamePattern
   * @return prevNamePattern
  */
  
  @Schema(name = "prevNamePattern", required = false)
  public String getPrevNamePattern() {
    return prevNamePattern;
  }

  public void setPrevNamePattern(String prevNamePattern) {
    this.prevNamePattern = prevNamePattern;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CopyDataSetListsRequestDto copyDataSetListsRequest = (CopyDataSetListsRequestDto) o;
    return Objects.equals(this.dataSetListIds, copyDataSetListsRequest.dataSetListIds) &&
        Objects.equals(this.updateReferences, copyDataSetListsRequest.updateReferences) &&
        Objects.equals(this.postfix, copyDataSetListsRequest.postfix) &&
        Objects.equals(this.prevNamePattern, copyDataSetListsRequest.prevNamePattern);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSetListIds, updateReferences, postfix, prevNamePattern);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CopyDataSetListsRequestDto {\n");
    sb.append("    dataSetListIds: ").append(toIndentedString(dataSetListIds)).append("\n");
    sb.append("    updateReferences: ").append(toIndentedString(updateReferences)).append("\n");
    sb.append("    postfix: ").append(toIndentedString(postfix)).append("\n");
    sb.append("    prevNamePattern: ").append(toIndentedString(prevNamePattern)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

