package org.qubership.atp.dataset.service.rest.dto.versioning;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.PageInfoDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * HistoryItemResponseDto
 */

@JsonTypeName("HistoryItemResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-08-01T11:12:11.770695474Z[Etc/UTC]")
public class HistoryItemResponseDto {

  @JsonProperty("pageInfo")
  private PageInfoDto pageInfo;

  @JsonProperty("historyItems")
  @Valid
  private List<HistoryItemDto> historyItems = null;

  public HistoryItemResponseDto pageInfo(PageInfoDto pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

  /**
   * Get pageInfo
   * @return pageInfo
  */
  @Valid 
  @Schema(name = "pageInfo", required = false)
  public PageInfoDto getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfoDto pageInfo) {
    this.pageInfo = pageInfo;
  }

  public HistoryItemResponseDto historyItems(List<HistoryItemDto> historyItems) {
    this.historyItems = historyItems;
    return this;
  }

  public HistoryItemResponseDto addHistoryItemsItem(HistoryItemDto historyItemsItem) {
    if (this.historyItems == null) {
      this.historyItems = new ArrayList<>();
    }
    this.historyItems.add(historyItemsItem);
    return this;
  }

  /**
   * Get historyItems
   * @return historyItems
  */
  @Valid 
  @Schema(name = "historyItems", required = false)
  public List<HistoryItemDto> getHistoryItems() {
    return historyItems;
  }

  public void setHistoryItems(List<HistoryItemDto> historyItems) {
    this.historyItems = historyItems;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoryItemResponseDto historyItemResponse = (HistoryItemResponseDto) o;
    return Objects.equals(this.pageInfo, historyItemResponse.pageInfo) &&
        Objects.equals(this.historyItems, historyItemResponse.historyItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageInfo, historyItems);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoryItemResponseDto {\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    historyItems: ").append(toIndentedString(historyItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

