/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.ei;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.ei.FileSystemCreator;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.ei.node.exceptions.ExportException;

@Isolated
public class FileSystemCreatorTest {
    FileSystemCreator fileSystemCreator = new FileSystemCreator();
    @TempDir
    private Path tempDir;

    @Test
    public void create_invokesWithException_exceptionInvoked() throws IOException, ExportException {
        Path temporaryPath = Files.createDirectories(this.tempDir.resolve("dsExport"), new FileAttribute[0]);
        Assertions.assertThrows(ExportException.class, () -> this.fileSystemCreator.create(temporaryPath, path -> Files.createFile(path, new FileAttribute[0])));
    }

    @Test
    public void create_createDirectory_directoryCreatesProperly() throws ExportException, IOException {
        Path temporaryPath = this.tempDir.resolve("test");
        DataSetImpl dataSet = new DataSetImpl();
        dataSet.setName("dataSet");
        this.fileSystemCreator.create(temporaryPath, path -> Files.createDirectory(path, new FileAttribute[0]));
        Assertions.assertTrue((boolean)Files.exists(temporaryPath, new LinkOption[0]));
    }
}

