/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.config.MockJaversCommitEntityServiceConfiguration;
import org.qubership.atp.dataset.config.TestMacrosConfiguration;
import org.qubership.atp.dataset.macros.impl.RefToRefTestData;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.model.utils.PhoneCallTestData;
import org.qubership.atp.dataset.service.AbstractTest;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@Isolated
@ContextConfiguration(classes={TestMacrosConfiguration.class, MockJaversCommitEntityServiceConfiguration.class})
public class LookupMacrosTest
extends AbstractTest {
    @Autowired
    private EvaluationService evaluationService;

    @Test
    public void refDslToRefThis_ChildRefPointsToUnreachableAttribute_FoundInParentRefContext() throws Exception {
        RefToRefTestData.RefDslChildRefTargetAttrIsUnreachable data = this.createTestDataInstance(RefToRefTestData.RefDslChildRefTargetAttrIsUnreachable::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
        evaluator = this.evaluationService.getEvaluator(true, false);
        try {
            Exception expected = null;
            try {
                evaluator.apply(data.childRef);
            }
            catch (Exception e) {
                expected = e;
            }
            Assertions.assertNotNull((Object)expected, (String)"Exception expected");
        }
        finally {
            if (evaluator != null) {
                evaluator.close();
            }
        }
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToUninitializedParameter_GotEmptyString() throws Exception {
        RefToRefTestData.RefDslChildRefTargetParamIsUninitialized data = this.createTestDataInstance(RefToRefTestData.RefDslChildRefTargetParamIsUninitialized::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)"", result.get());
            result = evaluator.apply(data.childRef);
            Assertions.assertEquals((Object)"", result.get());
        }
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToInitializedParameter_GotParameterText() throws Exception {
        RefToRefTestData.RefDslChildRefTargetParamIsInitialized data = this.createTestDataInstance(RefToRefTestData.RefDslChildRefTargetParamIsInitialized::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
            result = evaluator.apply(data.childRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refDslToRefThis_ChildRefPointsToParameterWithBrackets_GotParameterText() throws Exception {
        RefToRefTestData.RefDslChildRefTargetParamHasBrackets data = this.createTestDataInstance(RefToRefTestData.RefDslChildRefTargetParamHasBrackets::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
            result = evaluator.apply(data.childRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToUnreachableAttribute_FoundInParentRefContext() throws Exception {
        RefToRefTestData.RefThisChildRefTargetAttrIsUnreachable data = this.createTestDataInstance(RefToRefTestData.RefThisChildRefTargetAttrIsUnreachable::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            OverlapItem.Reachable parentRef = ((OverlapItem)OverlapIterator.create((DataSet)data.currentCase, (UUID)data.parentRef.getAttribute().getId(), null).next()).asReachable();
            Optional result = evaluator.apply(parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
            OverlapItem.Reachable childRef = ((OverlapItem)OverlapIterator.create((DataSet)data.currentCase, (UUID)data.childRef.getAttribute().getId(), Collections.singletonList(data.currentCaseIntoBelgium.getAttribute().getId())).next()).asReachable();
            result = evaluator.apply(childRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToUninitializedParameter_GotEmptyString() throws Exception {
        RefToRefTestData.RefThisChildRefTargetParamIsUninitialized data = this.createTestDataInstance(RefToRefTestData.RefThisChildRefTargetParamIsUninitialized::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            OverlapItem.Reachable parentRef = ((OverlapItem)OverlapIterator.create((DataSet)data.currentCase, (UUID)data.parentRef.getAttribute().getId(), null).next()).asReachable();
            Optional result = evaluator.apply(parentRef);
            Assertions.assertEquals((Object)"", result.get());
            OverlapItem.Reachable childRef = ((OverlapItem)OverlapIterator.create((DataSet)data.currentCase, (UUID)data.childRef.getAttribute().getId(), Collections.singletonList(data.currentCaseIntoBelgium.getAttribute().getId())).next()).asReachable();
            result = evaluator.apply(childRef);
            Assertions.assertEquals((Object)"", result.get());
        }
    }

    @Test
    public void refThisToRefThis_ChildRefPointsToInitializedParameter_GotParameterText() throws Exception {
        RefToRefTestData.RefThisChildRefTargetParamIsInitialized data = this.createTestDataInstance(RefToRefTestData.RefThisChildRefTargetParamIsInitialized::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refThis_RefTargetIsOverlapped_ContextOfOverlapIsUsed() throws Exception {
        RefToRefTestData.RefTargetParamIsOverlapped data = this.createTestDataInstance(RefToRefTestData.RefTargetParamIsOverlapped::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            OverlapItem.Reachable childRefInCurrentCaseCtx = ((OverlapItem)OverlapIterator.create((DataSet)data.currentCase, (UUID)data.childRef.getAttribute().getId(), Collections.singletonList(data.currentCaseIntoBelgium.getAttribute().getId())).next()).asReachable();
            Optional result = evaluator.apply(childRefInCurrentCaseCtx);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refThisToRefThis_RefTargetIsOverlapped_ContextOfOverlapIsUsed() throws Exception {
        RefToRefTestData.ChildRefTargetParamIsOverlapped data = this.createTestDataInstance(RefToRefTestData.ChildRefTargetParamIsOverlapped::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void refThisToRefThis_ChildRefIsOverlapped_ContextOfDefaultIsUsed() throws Exception {
        RefToRefTestData.ChildRefIsOverlapped data = this.createTestDataInstance(RefToRefTestData.ChildRefIsOverlapped::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.parentRef);
            Assertions.assertEquals((Object)data.brussels.getText(), result.get());
        }
    }

    @Test
    public void vLookup_RefDslUsingRefThis_ResolvedProperly() throws Exception {
        PhoneCallTestData data = this.createTestDataInstance(PhoneCallTestData::new);
        String vlookupMacro = String.format("#REF_DSL(%s.#REF_THIS(%s.%s).#REF_THIS(%s.%s))", data.internationalRateCost.getName(), data.voiceCallIntoOriginCountryRef.getAttribute().getName(), data.countryZone.getName(), data.voiceCallIntoDestinationCountryRef.getAttribute().getName(), data.countryZone.getName());
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias(vlookupMacro, data.va, data.voiceCall);
            String evaluate = evaluator.evaluateText(data.defaultVoiceCall, alias);
            Assertions.assertEquals((Object)data.rateCost.getText(), (Object)evaluate);
        }
    }

    @Test
    public void vLookup_RefToDslWithOverlap_ResolvedProperly() throws Exception {
        RefToRefTestData.VoiceCaseRefToDslWithOverlap data = this.createTestDataInstance(RefToRefTestData.VoiceCaseRefToDslWithOverlap::new);
        String vlookupMacro = String.format("#REF_DSL(%s.#REF_THIS(%s.%s).#REF_THIS(%s).#REF_THIS(%s.%s))", data.internationalVoiceRates.getName(), data.belToUsaIntoSubscriptionRef.getAttribute().getName(), data.tariffName.getAttribute().getName(), data.usageType.getAttribute().getName(), data.belToUsaIntoCountryRef.getAttribute().getName(), data.internationalZone.getAttribute().getName());
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            String alias = this.wrapperService.wrapToAlias(vlookupMacro, data.va, data.voiceCases);
            String evaluate = evaluator.evaluateText(data.belToUsa, alias);
            Assertions.assertEquals((Object)data.belgiumToUsaRatingOverlap.getText(), (Object)evaluate);
        }
    }

    @Test
    public void vLookup_RefToRefWithOverlap_ResolvedProperly() throws Exception {
        RefToRefTestData.VoiceCaseRefToRefWithOverlap data = this.createTestDataInstance(RefToRefTestData.VoiceCaseRefToRefWithOverlap::new);
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional result = evaluator.apply(data.targetParameter);
            Assertions.assertEquals((Object)data.belgiumToWorld2RatingOverlap.getText(), result.get());
        }
    }

    @Test
    public void TwoRefDsl_ToTheSameRandom_IsEqual() throws Exception {
        RefToRefTestData.TwoRefsToTheSameRandom d = this.createTestDataInstance(facade -> new RefToRefTestData.TwoRefsToTheSameRandom((CreationFacade)facade, this.wrapperService));
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            Optional keyA = evaluator.apply(d.keyA);
            Optional keyB = evaluator.apply(d.keyB);
            Assertions.assertEquals(keyA.get(), keyB.get());
        }
    }
}

