/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.utils.ExcelRowsReader;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeTypeConverterEnum;
import org.qubership.atp.dataset.service.direct.importexport.converters.DatasetLinkAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.TextAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class DatasetLinkAttributeExportConverterTest {
    private static final String RESOURCES_PATH = "src/test/resources/exportToFile/";
    private static final String EXCEL_FILE = "DSL_LINK_ATTR.xlsx";
    private static final AttributeType attrType = AttributeType.DSL;
    private UUID datasetListId;
    private static DatasetListExportService datasetListExportService;

    @BeforeEach
    public void setUp() {
        DataSetListService dslService = (DataSetListService)Mockito.mock(DataSetListService.class);
        DataSetListImportExportFactory factory = (DataSetListImportExportFactory)Mockito.mock(DataSetListImportExportFactory.class);
        datasetListExportService = new DatasetListExportService(dslService, factory);
        DataSetListImpl dataSetList2 = new DataSetListImpl();
        UUID datasetListId2 = UUID.randomUUID();
        dataSetList2.setId(datasetListId2);
        dataSetList2.setName("DSL2");
        UiManDataSetList uiManDataSetList2 = new UiManDataSetList();
        uiManDataSetList2.setSource((DataSetList)dataSetList2);
        ArrayList<DataSetImpl> dataSets2 = new ArrayList<DataSetImpl>();
        ArrayList<UiManDataSet> uiManDataSets2 = new ArrayList<UiManDataSet>();
        DataSetImpl ds3 = new DataSetImpl();
        UUID ds1Id = UUID.randomUUID();
        UUID dsId3 = UUID.randomUUID();
        MixInIdImpl mId3 = new MixInIdImpl(dsId3);
        ds3.setMixInId((MixInId)mId3);
        ds3.setId(dsId3);
        ds3.setName("DS3");
        UiManDataSet uds3 = new UiManDataSet();
        uds3.setSource((DataSet)ds3);
        DataSetImpl ds4 = new DataSetImpl();
        UUID ds2Id = UUID.randomUUID();
        UUID dsId4 = UUID.randomUUID();
        MixInIdImpl mId4 = new MixInIdImpl(dsId4);
        ds4.setMixInId((MixInId)mId4);
        ds4.setId(dsId4);
        ds4.setName("DS4");
        UiManDataSet uds4 = new UiManDataSet();
        uds4.setSource((DataSet)ds4);
        dataSets2.add(ds3);
        dataSets2.add(ds4);
        dataSetList2.setDataSets(dataSets2);
        uiManDataSets2.add(uds3);
        uiManDataSets2.add(uds4);
        uiManDataSetList2.setDataSets(uiManDataSets2);
        AttributeImpl attribute2 = new AttributeImpl();
        attribute2.setType(AttributeType.TEXT);
        attribute2.setName("attr");
        UiManAttribute uiManAttribute2 = new UiManAttribute();
        uiManAttribute2.setSource((Attribute)attribute2);
        ParameterImpl parameter3 = new ParameterImpl();
        parameter3.setDataSet((DataSet)ds3);
        parameter3.setText("value1");
        UiManParameter uiManParameter3 = new UiManParameter();
        uiManParameter3.setDataSet(ds1Id);
        uiManParameter3.setSource((Parameter)parameter3);
        uiManParameter3.setValue((Object)parameter3.getText());
        ParameterImpl parameter4 = new ParameterImpl();
        parameter4.setDataSet((DataSet)ds4);
        parameter4.setText("value2");
        UiManParameter uiManParameter4 = new UiManParameter();
        uiManParameter4.setDataSet(ds2Id);
        uiManParameter4.setSource((Parameter)parameter4);
        uiManParameter4.setValue((Object)parameter4.getText());
        attribute2.setParameters(Arrays.asList(parameter3, parameter4));
        dataSetList2.setAttributes(Collections.singletonList(attribute2));
        uiManAttribute2.setParameters(Arrays.asList(uiManParameter3, uiManParameter4));
        uiManDataSetList2.setAttributes(Collections.singletonList(uiManAttribute2));
        DataSetListImpl dataSetList1 = new DataSetListImpl();
        this.datasetListId = UUID.randomUUID();
        dataSetList1.setId(this.datasetListId);
        dataSetList1.setName("DSL_LINK_ATTR");
        UiManDataSetList uiManDataSetList1 = new UiManDataSetList();
        uiManDataSetList1.setSource((DataSetList)dataSetList1);
        ArrayList<DataSetImpl> dataSets1 = new ArrayList<DataSetImpl>();
        ArrayList<UiManDataSet> uiManDataSets1 = new ArrayList<UiManDataSet>();
        DataSetImpl ds1 = new DataSetImpl();
        MixInIdImpl mId1 = new MixInIdImpl(ds1Id);
        ds1.setMixInId((MixInId)mId1);
        ds1.setId(ds1Id);
        ds1.setName("DS1");
        UiManDataSet uds1 = new UiManDataSet();
        uds1.setSource((DataSet)ds1);
        DataSetImpl ds2 = new DataSetImpl();
        MixInIdImpl mId2 = new MixInIdImpl(ds2Id);
        ds2.setMixInId((MixInId)mId2);
        ds2.setId(ds2Id);
        ds2.setName("DS2");
        UiManDataSet uds2 = new UiManDataSet();
        uds2.setSource((DataSet)ds2);
        dataSets1.add(ds1);
        dataSets1.add(ds2);
        dataSetList1.setDataSets(dataSets1);
        uiManDataSets1.add(uds1);
        uiManDataSets1.add(uds2);
        uiManDataSetList1.setDataSets(uiManDataSets1);
        AttributeImpl attribute1 = new AttributeImpl();
        attribute1.setType(attrType);
        attribute1.setName("Link to DSL2");
        attribute1.setDataSetListReference((DataSetList)dataSetList2);
        UiManAttribute uiManAttribute1 = new UiManAttribute();
        uiManAttribute1.setSource((Attribute)attribute1);
        uiManAttribute1.setAttributes(Collections.singletonList(uiManAttribute2));
        ParameterImpl parameter1 = new ParameterImpl();
        parameter1.setDataSet((DataSet)ds1);
        parameter1.setDataSetReference((DataSet)ds3);
        UiManParameter uiManParameter1 = new UiManParameter();
        uiManParameter1.setDataSet(ds1Id);
        uiManParameter1.setSource((Parameter)parameter1);
        uiManParameter1.setValue((Object)ds3.getName());
        uiManParameter1.setValueRef((Object)ds3.getId());
        ParameterImpl parameter2 = new ParameterImpl();
        parameter2.setDataSet((DataSet)ds2);
        parameter2.setDataSetReference((DataSet)ds4);
        UiManParameter uiManParameter2 = new UiManParameter();
        uiManParameter2.setDataSet(ds2Id);
        uiManParameter2.setSource((Parameter)parameter2);
        uiManParameter2.setValue((Object)ds4.getName());
        uiManParameter1.setValueRef((Object)ds4.getId());
        attribute1.setParameters(Arrays.asList(parameter1, parameter2));
        dataSetList1.setAttributes(Collections.singletonList(attribute1));
        uiManAttribute1.setParameters(Arrays.asList(uiManParameter1, uiManParameter2));
        uiManDataSetList1.setAttributes(Collections.singletonList(uiManAttribute1));
        Mockito.when((Object)dslService.getAsTree(this.datasetListId, false)).thenReturn((Object)uiManDataSetList1);
        Mockito.when((Object)factory.getAttributeExportConverter((String)ArgumentMatchers.any())).thenReturn((Object)new DatasetLinkAttributeExportConverter());
        ((DataSetListImportExportFactory)Mockito.doReturn((Object)new TextAttributeExportConverter()).when((Object)factory)).getAttributeExportConverter(AttributeTypeConverterEnum.TEXT.getName());
    }

    @Test
    public void datasetListExportService_mapTextAttributeToRow_returnDocumentWithEqualStructure() {
        File erFile = new File("src/test/resources/exportToFile/DSL_LINK_ATTR.xlsx");
        File arFile = datasetListExportService.exportDataSetList(this.datasetListId);
        List erRows = ExcelRowsReader.read((File)erFile).collect(Collectors.toList());
        List arRows = ExcelRowsReader.read((File)arFile).collect(Collectors.toList());
        Assertions.assertEquals(erRows, arRows);
    }
}

