/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Isolated;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.utils.ExcelRowsReader;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.importexport.converters.TextAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSet;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManParameter;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Isolated
@ExtendWith(value={SpringExtension.class})
public class TextAttributeExportConverterTest {
    private static final String RESOURCES_PATH = "src/test/resources/exportToFile/";
    private static final String EXCEL_FILE = "DSL_TEXT_ATTR.xlsx";
    private static final AttributeType attrType = AttributeType.TEXT;
    private static final String uuidText = "#UUID()";
    private static final String refText = "#REF_THIS(Text Attribute)";
    private UUID datasetListId;
    private static DatasetListExportService datasetListExportService;

    @BeforeEach
    public void setUp() {
        DataSetListService dslService = (DataSetListService)Mockito.mock(DataSetListService.class);
        DataSetListImportExportFactory factory = (DataSetListImportExportFactory)Mockito.mock(DataSetListImportExportFactory.class);
        datasetListExportService = new DatasetListExportService(dslService, factory);
        DataSetListImpl dataSetList = new DataSetListImpl();
        this.datasetListId = UUID.randomUUID();
        dataSetList.setId(this.datasetListId);
        dataSetList.setName("DSL_TEXT_ATTR");
        UiManDataSetList uiManDataSetList = new UiManDataSetList();
        uiManDataSetList.setSource((DataSetList)dataSetList);
        ArrayList<DataSetImpl> dataSets = new ArrayList<DataSetImpl>();
        ArrayList<UiManDataSet> uiManDataSets = new ArrayList<UiManDataSet>();
        DataSetImpl ds1 = new DataSetImpl();
        UUID ds1Id = UUID.randomUUID();
        MixInIdImpl mId1 = new MixInIdImpl(ds1Id);
        ds1.setMixInId((MixInId)mId1);
        ds1.setId(ds1Id);
        ds1.setName("DS1");
        UiManDataSet uds1 = new UiManDataSet();
        uds1.setSource((DataSet)ds1);
        DataSetImpl ds2 = new DataSetImpl();
        UUID ds2Id = UUID.randomUUID();
        MixInIdImpl mId2 = new MixInIdImpl(ds2Id);
        ds2.setMixInId((MixInId)mId2);
        ds2.setId(ds2Id);
        ds2.setName("DS2");
        UiManDataSet uds2 = new UiManDataSet();
        uds2.setSource((DataSet)ds2);
        dataSets.add(ds1);
        dataSets.add(ds2);
        dataSetList.setDataSets(dataSets);
        uiManDataSets.add(uds1);
        uiManDataSets.add(uds2);
        uiManDataSetList.setDataSets(uiManDataSets);
        AttributeImpl attribute = new AttributeImpl();
        attribute.setType(attrType);
        attribute.setName("Text Attribute");
        UiManAttribute uiManAttribute = new UiManAttribute();
        uiManAttribute.setSource((Attribute)attribute);
        AttributeImpl macrosAttribute = new AttributeImpl();
        macrosAttribute.setType(attrType);
        macrosAttribute.setName("Macros Attribute");
        UiManAttribute uiManAttributeMacros = new UiManAttribute();
        uiManAttributeMacros.setSource((Attribute)macrosAttribute);
        ParameterImpl parameter = new ParameterImpl();
        parameter.setDataSet((DataSet)ds2);
        parameter.setText("some_text");
        UiManParameter uiManParameter = new UiManParameter();
        uiManParameter.setDataSet(ds2Id);
        uiManParameter.setSource((Parameter)parameter);
        uiManParameter.setValue((Object)parameter.getText());
        ParameterImpl macrosUuid = new ParameterImpl();
        macrosUuid.setDataSet((DataSet)ds1);
        macrosUuid.setText(uuidText);
        UiManParameter uiManParameterMacrosUuid = new UiManParameter();
        uiManParameterMacrosUuid.setDataSet(ds1Id);
        uiManParameterMacrosUuid.setSource((Parameter)macrosUuid);
        uiManParameterMacrosUuid.setValue((Object)macrosUuid.getText());
        ParameterImpl macrosRef = new ParameterImpl();
        macrosRef.setDataSet((DataSet)ds2);
        macrosRef.setText(refText);
        UiManParameter uiManParameterMacrosRef = new UiManParameter();
        uiManParameterMacrosRef.setDataSet(ds2Id);
        uiManParameterMacrosRef.setSource((Parameter)macrosRef);
        uiManParameterMacrosRef.setValue((Object)macrosRef.getText());
        attribute.setParameters(Collections.singletonList(parameter));
        macrosAttribute.setParameters(Arrays.asList(macrosUuid, macrosRef));
        dataSetList.setAttributes(Arrays.asList(attribute, macrosAttribute));
        uiManAttribute.setParameters(Collections.singletonList(uiManParameter));
        uiManAttributeMacros.setParameters(Arrays.asList(uiManParameterMacrosUuid, uiManParameterMacrosRef));
        uiManDataSetList.setAttributes(Arrays.asList(uiManAttribute, uiManAttributeMacros));
        Mockito.when((Object)dslService.getAsTree(this.datasetListId, false)).thenReturn((Object)uiManDataSetList);
        Mockito.when((Object)factory.getAttributeExportConverter((String)ArgumentMatchers.any())).thenReturn((Object)new TextAttributeExportConverter());
    }

    @Test
    public void datasetListExportService_mapTextAttributeToRow_returnDocumentWithEqualStructure() {
        File erFile = new File("src/test/resources/exportToFile/DSL_TEXT_ATTR.xlsx");
        File arFile = datasetListExportService.exportDataSetList(this.datasetListId);
        List erRows = ExcelRowsReader.read((File)erFile).collect(Collectors.toList());
        List arRows = ExcelRowsReader.read((File)arFile).collect(Collectors.toList());
        Assertions.assertEquals(erRows, arRows);
    }

    @Test
    public void exportDataSetList_exportMacros_macrosNotCalculated() {
        File erFile = new File("src/test/resources/exportToFile/DSL_TEXT_ATTR.xlsx");
        List<List> rows = ExcelRowsReader.read((File)erFile).collect(Collectors.toList());
        rows.forEach(row -> {
            if ("Macros Attribute".equalsIgnoreCase((String)row.get(0))) {
                Assertions.assertEquals((Object)uuidText, row.get(2));
                Assertions.assertEquals((Object)refText, row.get(3));
            }
        });
    }
}

