/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractMacroTest;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.matcher.MatcherFactory;

@Isolated
public class DateMacroTest
extends AbstractMacroTest {
    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_1() {
        String macro = "\"#DATE(-198d,yyyy-MM-dd\\'T\\'HH:mm:ss.sss)Z\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithTimezoneCharacterInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_1() {
        String macro = "\"#DATE(-198d,yyyy-MM-dd\\'T\\'HH:mm:ss.sss)Z\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_2() {
        String macro = "\"#DATE(-1d,yyyy-MM-dd\\'T\\'HH:mm:ss.sss\\'Z\\')\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithTimezoneCharacterInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_2() {
        String macro = "\"#DATE(-1d,yyyy-MM-dd\\'T\\'HH:mm:ss.sss\\'Z\\')\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_3() {
        String macro = "\"#DATE(-5h, yyyy-MM-dd\\'T\\')23:59:59\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithoutTimezoneInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_3() {
        String macro = "\"#DATE(-5h, yyyy-MM-dd\\'T\\')23:59:59\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_4() {
        String macro = "\"#DATE(+10d-5h, yyyy-MM-dd\\'T\\')\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutTimeInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_4() {
        String macro = "\"#DATE(+10d-5h, yyyy-MM-dd\\'T\\')\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_5() {
        String macro = "\"#DATE(+10m, yyyy-MM-dd\\'T\\'HH:mm:ss\\'Z\\')\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithTimezoneCharacterInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_5() {
        String macro = "\"#DATE(+10m, yyyy-MM-dd\\'T\\'HH:mm:ss\\'Z\\')\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_6() {
        String macro = "\"#DATE(+1d, yyyy-MM-dd\\'T\\'HH:mm:ss)\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithoutTimezoneInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_6() {
        String macro = "\"#DATE(+1d, yyyy-MM-dd\\'T\\'HH:mm:ss)\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_7() {
        String macro = "\"#DATE(+1d, yyyy-MM-dd\\'T\\'HH:mm:ss.123\\'Z\\')\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithTimezoneCharacterInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_7() {
        String macro = "\"#DATE(+1d, yyyy-MM-dd\\'T\\'HH:mm:ss.123\\'Z\\')\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_8() {
        String macro = "\"#DATE(+1d,yyyy-MM-28\\'T\\'HH:mm:ss)\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithoutTimezoneInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_8() {
        String macro = "\"#DATE(+1d,yyyy-MM-28\\'T\\'HH:mm:ss)\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_9() {
        String macro = "\"#DATE(+2d, yyyy-MM-dd\\'T\\'08:00:05+01:00)\"";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithTimezoneInQuotes());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_9() {
        String macro = "\"#DATE(+2d, yyyy-MM-dd\\'T\\'08:00:05+01:00)\"";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_10() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ss\\'Z\\')";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMsAndWithTimezoneCharacter());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_10() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ss\\'Z\\')";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_11() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ssZ)";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithoutMs());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_11() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ssZ)";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsTrue_12() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ss.sss)Z";
        String result = this.getResult(macro, true);
        MatcherAssert.assertThat((Object)result, MatcherFactory.isIsoDateWithTimezoneCharacter());
    }

    @Test
    public void testDateMacro_shouldReturnsEquals_whenEvaluateIsFalse_12() {
        String macro = "#DATE(yyyy-MM-dd\\'T\\'HH:mm:ss.sss)Z";
        String result = this.getResult(macro, false);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)macro));
    }

    private String getResult(String macro, boolean isCalculate) {
        List parseResult = this.parser.parse(macro, isCalculate);
        return parseResult.stream().map(AbstractParameter::getValue).collect(Collectors.joining());
    }
}

