/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.qubership.atp.dataset.config.TestConfiguration;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetTree;
import org.qubership.atp.dataset.service.jpa.service.AbstractJpaTest;
import org.qubership.atp.macros.core.clients.api.dto.macros.MacrosDto;
import org.qubership.atp.macros.core.model.Macros;
import org.qubership.atp.macros.core.processor.AbstractContext;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@Disabled
@SpringBootTest
@ContextConfiguration(classes={TestConfiguration.class})
@ExtendWith(value={SpringExtension.class})
@TestPropertySource(properties={"atp-dataset.javers.enabled=false"})
public class JpaIntegrationTest
extends AbstractJpaTest {
    @Mock
    MacrosDto macrosDto;
    private String EXPECTED_ATP_EVALUATED_CONTEXT = "{\"parameters\":{\"Attr 1\":{\"type\":\"TEXT\"},\"Attr 2\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Attr list 1\":{\"type\":\"LIST\",\"value\":\"Value 2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"value\":\"Test DataSet2  2\",\"dsl\":\"Test DataSetList 2\",\"parameters\":{\"Attr2  1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Attr2  2\":{\"type\":\"TEXT\",\"value\":\"Some overlap value\"},\"Attr2  list 1\":{\"type\":\"LIST\",\"value\":\"Value2 2\"}},\"groups\":{\"DSL reference 2\":{\"type\":\"DSL\",\"value\":\"Test DataSet3  3\",\"dsl\":\"Test DataSetList 3\",\"parameters\":{\"Attr3  1\":{\"type\":\"TEXT\"},\"Attr3  2\":{\"type\":\"TEXT\",\"value\":\"Some value3 4\"}},\"dataSetId\":\"b893b683-0b17-4f76-a96f-c997af88f7b2\"}},\"dataSetId\":\"96ba075a-1436-488a-90a0-30b3d58584f9\"}}}";
    private String EXPECTED_ATP_UNEVALUATED_CONTEXT = "{\"parameters\":{\"Attr 1\":{\"type\":\"TEXT\"},\"Attr 2\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Attr list 1\":{\"type\":\"LIST\",\"value\":\"Value 2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"value\":\"Test DataSet2  2\",\"dsl\":\"Test DataSetList 2\",\"parameters\":{\"Attr2  1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Attr2  2\":{\"type\":\"TEXT\",\"value\":\"Some overlap value\"},\"Attr2  list 1\":{\"type\":\"LIST\",\"value\":\"Value2 2\"}},\"groups\":{\"DSL reference 2\":{\"type\":\"DSL\",\"value\":\"Test DataSet3  3\",\"dsl\":\"Test DataSetList 3\",\"parameters\":{\"Attr3  1\":{\"type\":\"TEXT\"},\"Attr3  2\":{\"type\":\"TEXT\",\"value\":\"Some value3 4\"}},\"dataSetId\":\"b893b683-0b17-4f76-a96f-c997af88f7b2\"}},\"dataSetId\":\"96ba075a-1436-488a-90a0-30b3d58584f9\"}}}";
    private String EXPECTED_ITF_CONTEXT = "{\"Attr 1\":\"\",\"Attr 2\":\"32OK_MACRO_VALUE\",\"Attr list 1\":\"Value 2\",\"DSL reference\":{\"Attr2  1\":\"32OK_MACRO_VALUE\",\"Attr2  2\":\"Some overlap value\",\"Attr2  list 1\":\"Value2 2\",\"DSL reference 2\":{\"Attr3  1\":\"\",\"Attr3  2\":\"Some value3 4\"}}}";
    private String FULL_ATP_EXPECTED_RESULT = "{\"parameters\":{\"Some text 1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Some text 2\":{\"type\":\"TEXT\",\"value\":\"Val2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"dsl\":\"Child DSL\",\"parameters\":{\"Some var 1\":{\"type\":\"TEXT\"},\"Some var 2\":{\"type\":\"TEXT\",\"value\":\"Some overlap value\"}}}}}";
    private String OBJECT_ATP_EXPECTED_RESULT = "{\"parameters\":{\"Some text 1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Some text 2\":{\"type\":\"TEXT\",\"value\":\"Val2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"dsl\":\"Child DSL\"}}}";
    private String OPTIMIZED_ATP_EXPECTED_RESULT = "{\"parameters\":{\"Some text 1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Some text 2\":{\"type\":\"TEXT\",\"value\":\"Val2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"dsl\":\"Child DSL\",\"parameters\":{\"Some var 2\":{\"type\":\"TEXT\",\"value\":\"Some overlap value\"}}}}}";
    private String OBJECT_EXTENDED_ATP_EXPECTED_RESULT = "{\"parameters\":{\"Some text 1\":{\"type\":\"TEXT\",\"value\":\"32OK_MACRO_VALUE\"},\"Some text 2\":{\"type\":\"TEXT\",\"value\":\"Val2\"}},\"groups\":{\"DSL reference\":{\"type\":\"DSL\",\"dsl\":\"Child DSL\",\"parameters\":{\"Some var 2\":{\"type\":\"TEXT\",\"value\":\"Some overlap value\"}}}}}";
    private static UUID dataSetToCheck = UUID.fromString("f05b4368-a1ff-41f6-bf8f-9c7f0f139e1c");
    private static UUID sourceAttributeEncNoParameterId = UUID.fromString("89520827-8daf-4f3a-ba05-d1369b63e636");
    private UUID visibilityAreaId = UUID.fromString("f261ed65-a491-44b0-af38-f0d97a46008c");
    private UUID sourceDsId = UUID.fromString("336e0cc9-dee2-458c-887e-bcdc406ae4be");
    private UUID sourceAttributeTextId = UUID.fromString("2e70a5cf-815a-40ee-b258-90a1b05f709b");
    private UUID sourceAttributeListId = UUID.fromString("36f8ff3d-3291-4274-bbee-5a468db5f7d2");
    private UUID sourceAttributeDslId = UUID.fromString("9923d9ec-81b8-4dca-b762-f663ed24595b");
    private UUID sourceAttributeChangeId = UUID.fromString("4079aab2-3d5e-4d86-9217-f66524808ec3");
    private UUID sourceAttributeEncId = UUID.fromString("81a84637-62a4-4d8b-8159-a6aeb20e52f5");
    private UUID sourceAttributeTextNoParameterId = UUID.fromString("6871e447-2f61-4fd7-ae4c-dc26aebdc607");
    private UUID sourceAttributeListNoParameterId = UUID.fromString("575e88a0-f83d-48d6-bf3a-adfda05d00f4");
    private UUID sourceAttributeDslNoParameterId = UUID.fromString("132eadd7-4f7e-4fe3-91b8-e36a5e36b672");
    private UUID sourceAttributeChangeNoParameterId = UUID.fromString("062276b4-29a6-48a5-8348-af3a1165fcd8");
    private UUID dataSetToCheckContextTypes = UUID.fromString("fe703972-1b4b-41d5-837b-ab3824de5269");

    @BeforeEach
    public void generateData() throws Exception {
        Mockito.when((Object)this.scriptMacrosCalculator.calculate((Macros)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (AbstractContext)ArgumentMatchers.any())).thenReturn((Object)"OK_MACRO_VALUE");
        Mockito.when((Object)this.macrosFeignClient.findAllByProject((UUID)ArgumentMatchers.any(UUID.class))).thenReturn((Object)new ResponseEntity(Collections.singletonList(this.macrosDto), HttpStatus.OK));
        Mockito.when((Object)this.macrosDto.getName()).thenReturn((Object)"RANDOMBETWEEN");
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void checkAtpContextTypes_resultsMatches() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        DataSetTree fullTree = this.dataSetService.getDataSetTreeInAtpFormat(this.dataSetToCheckContextTypes, true, null, ContextType.FULL);
        String full = mapper.writeValueAsString((Object)fullTree);
        Assertions.assertEquals((Object)this.FULL_ATP_EXPECTED_RESULT, (Object)full);
        DataSetTree objectTree = this.dataSetService.getDataSetTreeInAtpFormat(this.dataSetToCheckContextTypes, true, null, ContextType.OBJECT);
        String object = mapper.writeValueAsString((Object)objectTree);
        Assertions.assertEquals((Object)this.OBJECT_ATP_EXPECTED_RESULT, (Object)object);
        DataSetTree objectExtendedTree = this.dataSetService.getDataSetTreeInAtpFormat(this.dataSetToCheckContextTypes, true, null, ContextType.OBJECT_EXTENDED);
        String objectExtended = mapper.writeValueAsString((Object)objectExtendedTree);
        Assertions.assertEquals((Object)this.OBJECT_EXTENDED_ATP_EXPECTED_RESULT, (Object)objectExtended);
        DataSetTree optimizedTree = this.dataSetService.getDataSetTreeInAtpFormat(this.dataSetToCheckContextTypes, true, null, ContextType.NO_NULL_VALUES);
        String optimized = mapper.writeValueAsString((Object)optimizedTree);
        Assertions.assertEquals((Object)this.OPTIMIZED_ATP_EXPECTED_RESULT, (Object)optimized);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void checkAtpContextEvaluated_resultMatches() throws Exception {
        DataSetTree dataSetTree = this.dataSetService.getDataSetTreeInAtpFormat(dataSetToCheck, true, null, ContextType.FULL);
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)dataSetTree);
        Assertions.assertEquals((Object)this.EXPECTED_ATP_EVALUATED_CONTEXT, (Object)jsonString);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void checkAtpContextUnevaluated_resultMatches() throws Exception {
        DataSetTree dataSetTree = this.dataSetService.getDataSetTreeInAtpFormat(dataSetToCheck, false, null, ContextType.FULL);
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)dataSetTree);
        Assertions.assertEquals((Object)this.EXPECTED_ATP_UNEVALUATED_CONTEXT, (Object)jsonString);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void checkItfContextEvaluated_resultMatches() throws Exception {
        String result = this.dataSetService.getDataSetTreeInItfFormat(dataSetToCheck);
        Assertions.assertEquals((Object)this.EXPECTED_ITF_CONTEXT, (Object)result);
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void copyDsAttributeValue_withAllValues() throws Exception {
        DataSetList targetDslAllParametersEqTypes = this.dataSetListService.create("TargetDsl1", this.visibilityAreaId);
        UUID targetDslId = targetDslAllParametersEqTypes.getId();
        DataSet targetDsAllParametersEqTypes = this.dataSetService.create("TargetDS1", targetDslId);
        UUID targetDsId = targetDsAllParametersEqTypes.getId();
        Attribute target1AttributeText = this.attributeService.create("text_attr", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList = this.attributeService.create("list_attr", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl = this.attributeService.create("dsl_attr", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange = this.attributeService.create("change_attr", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc = this.attributeService.create("enc_attr", AttributeTypeName.ENCRYPTED, targetDslId);
        Attribute target1AttributeText1 = this.attributeService.create("text_attr_without_parameter", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList1 = this.attributeService.create("list_attr_without_parameter", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl1 = this.attributeService.create("dsl_attr_without_parameter", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange1 = this.attributeService.create("change_attr_without_parameter", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc1 = this.attributeService.create("enc_attr_without_parameter", AttributeTypeName.ENCRYPTED, targetDslId);
        ListValue targetListValue = this.attributeService.createListValue("2", target1AttributeList.getId());
        DataSetList targetDslReference = this.dataSetListService.create("targetDslParameter", this.visibilityAreaId);
        ListValue targetListValue1 = this.attributeService.createListValue("2", target1AttributeList1.getId());
        DataSetList targetDslReference1 = this.dataSetListService.create("targetDslParameter1", this.visibilityAreaId);
        this.parameterService.createParameter(targetDsId, target1AttributeText.getId(), "text2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeList.getId(), null, null, ((ListValueEntity)targetListValue.getEntity()).getId());
        this.parameterService.createParameter(targetDsId, target1AttributeDsl.getId(), null, targetDslReference.getId(), null);
        this.parameterService.createParameter(targetDsId, target1AttributeChange.getId(), "changeType2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeEnc.getId(), "encType2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeText1.getId(), "text3", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeList1.getId(), null, null, ((ListValueEntity)targetListValue1.getEntity()).getId());
        this.parameterService.createParameter(targetDsId, target1AttributeDsl1.getId(), null, targetDslReference1.getId(), null);
        this.parameterService.createParameter(targetDsId, target1AttributeChange1.getId(), "changeType3", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeEnc1.getId(), "encType3", null, null);
        Mockito.when((Object)this.decryptor.decryptIfEncrypted((String)ArgumentMatchers.any(String.class))).thenAnswer(i -> i.getArguments()[0]);
        UUID newTargetTextId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextId, target1AttributeText.getId());
        UUID newTargetListId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListId, target1AttributeList.getId());
        UUID newTargetDslId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslId, target1AttributeDsl.getId());
        UUID newTargetChangeId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeId, target1AttributeChange.getId());
        UUID newTargetEncId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeEncId, target1AttributeEnc.getId());
        UUID newTargetText1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextNoParameterId, target1AttributeText1.getId());
        UUID newTargetList1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListNoParameterId, target1AttributeList1.getId());
        UUID newTargetDsl1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslNoParameterId, target1AttributeDsl1.getId());
        UUID newTargetChange1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeNoParameterId, target1AttributeChange1.getId());
        UUID newTargetEnc1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, sourceAttributeEncNoParameterId, target1AttributeEnc1.getId());
        Assertions.assertEquals((Object)target1AttributeText.getId(), (Object)newTargetTextId);
        Assertions.assertEquals((Object)target1AttributeList.getId(), (Object)newTargetListId);
        Assertions.assertEquals((Object)target1AttributeDsl.getId(), (Object)newTargetDslId);
        Assertions.assertEquals((Object)target1AttributeChange.getId(), (Object)newTargetChangeId);
        Assertions.assertEquals((Object)target1AttributeEnc.getId(), (Object)newTargetEncId);
        Assertions.assertEquals((Object)target1AttributeText1.getId(), (Object)newTargetText1Id);
        Assertions.assertEquals((Object)target1AttributeList1.getId(), (Object)newTargetList1Id);
        Assertions.assertEquals((Object)target1AttributeDsl1.getId(), (Object)newTargetDsl1Id);
        Assertions.assertEquals((Object)target1AttributeChange1.getId(), (Object)newTargetChange1Id);
        Assertions.assertEquals((Object)target1AttributeEnc1.getId(), (Object)newTargetEnc1Id);
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeTextId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetTextId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeListId, this.sourceDsId).getListValue().getText(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetListId, targetDsId).getListValue().getText());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeDslId, this.sourceDsId).getDataSetReferenceId(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDslId, targetDsId).getDataSetReferenceId());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeChangeId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChangeId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeEncId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEncId, targetDsId).getStringValue());
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetText1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetList1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDsl1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChange1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEnc1Id, targetDsId));
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void copyDsAttributeValue_withAllValuesDiffTypes() throws Exception {
        DataSetList targetDslAllParametersDiffTypes = this.dataSetListService.create("TargetDsl2", this.visibilityAreaId);
        UUID targetDslId = targetDslAllParametersDiffTypes.getId();
        DataSet targetDsAllParametersDiffTypes = this.dataSetService.create("TargetDS2", targetDslId);
        UUID targetDsId = targetDsAllParametersDiffTypes.getId();
        Attribute target1AttributeText = this.attributeService.create("text_attr", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeList = this.attributeService.create("list_attr", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeDsl = this.attributeService.create("dsl_attr", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeChange = this.attributeService.create("change_attr", AttributeTypeName.ENCRYPTED, targetDslId);
        Attribute target1AttributeEnc = this.attributeService.create("enc_attr", AttributeTypeName.TEXT, targetDslId);
        ListValue targerListValue = this.attributeService.createListValue("2", target1AttributeList.getId());
        DataSetList targetDslReference = this.dataSetListService.create("targetDslParameter", this.visibilityAreaId);
        Attribute target1AttributeText1 = this.attributeService.create("text_attr_without_parameter", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeList1 = this.attributeService.create("list_attr_without_parameter", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeDsl1 = this.attributeService.create("dsl_attr_without_parameter", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeChange1 = this.attributeService.create("change_attr_without_parameter", AttributeTypeName.ENCRYPTED, targetDslId);
        Attribute target1AttributeEnc1 = this.attributeService.create("enc_attr_without_parameter", AttributeTypeName.TEXT, targetDslId);
        ListValue targetListValue1 = this.attributeService.createListValue("2", target1AttributeList1.getId());
        DataSetList targetDslReference1 = this.dataSetListService.create("targetDslParameter1", this.visibilityAreaId);
        Parameter textParam = this.parameterService.createParameter(targetDsId, target1AttributeText.getId(), null, null, ((ListValueEntity)targerListValue.getEntity()).getId());
        Parameter listParam = this.parameterService.createParameter(targetDsId, target1AttributeList.getId(), null, targetDslReference.getId(), null);
        Parameter dslParam = this.parameterService.createParameter(targetDsId, target1AttributeDsl.getId(), "changeType2", null, null);
        Parameter changeParam = this.parameterService.createParameter(targetDsId, target1AttributeChange.getId(), "encType2", null, null);
        Parameter encParam = this.parameterService.createParameter(targetDsId, target1AttributeEnc.getId(), "textType2", null, null);
        Parameter p1 = this.parameterService.createParameter(targetDsId, target1AttributeText1.getId(), null, null, ((ListValueEntity)targetListValue1.getEntity()).getId());
        Parameter p2 = this.parameterService.createParameter(targetDsId, target1AttributeList1.getId(), null, targetDslReference1.getId(), null);
        Parameter p3 = this.parameterService.createParameter(targetDsId, target1AttributeDsl1.getId(), "changeType3", null, null);
        Parameter p4 = this.parameterService.createParameter(targetDsId, target1AttributeChange1.getId(), "encType3", null, null);
        Parameter p5 = this.parameterService.createParameter(targetDsId, target1AttributeEnc1.getId(), "textType3", null, null);
        UUID newTargetTextId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextId, target1AttributeText.getId());
        UUID newTargetListId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListId, target1AttributeList.getId());
        UUID newTargetDslId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslId, target1AttributeDsl.getId());
        UUID newTargetChangeId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeId, target1AttributeChange.getId());
        UUID newTargetEncId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeEncId, target1AttributeEnc.getId());
        UUID newTargetText1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextNoParameterId, target1AttributeText1.getId());
        UUID newTargetList1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListNoParameterId, target1AttributeList1.getId());
        UUID newTargetDsl1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslNoParameterId, target1AttributeDsl1.getId());
        UUID newTargetChange1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeNoParameterId, target1AttributeChange1.getId());
        UUID newTargetEnc1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, sourceAttributeEncNoParameterId, target1AttributeEnc1.getId());
        Assertions.assertNotEquals((Object)target1AttributeText.getId(), (Object)newTargetTextId);
        Assertions.assertNotEquals((Object)target1AttributeList.getId(), (Object)newTargetListId);
        Assertions.assertNotEquals((Object)target1AttributeDsl.getId(), (Object)newTargetDslId);
        Assertions.assertNotEquals((Object)target1AttributeChange.getId(), (Object)newTargetChangeId);
        Assertions.assertNotEquals((Object)target1AttributeEnc.getId(), (Object)newTargetEncId);
        Assertions.assertNotEquals((Object)target1AttributeText1.getId(), (Object)newTargetText1Id);
        Assertions.assertNotEquals((Object)target1AttributeList1.getId(), (Object)newTargetList1Id);
        Assertions.assertNotEquals((Object)target1AttributeDsl1.getId(), (Object)newTargetDsl1Id);
        Assertions.assertNotEquals((Object)target1AttributeChange1.getId(), (Object)newTargetChange1Id);
        Assertions.assertNotEquals((Object)target1AttributeEnc1.getId(), (Object)newTargetEnc1Id);
        Assertions.assertNull((Object)this.parameterService.getById(textParam.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(listParam.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(dslParam.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(changeParam.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(encParam.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(p1.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(p2.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(p3.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(p4.getId()));
        Assertions.assertNull((Object)this.parameterService.getById(p5.getId()));
        Assertions.assertNull((Object)this.attributeService.getListValueById(targerListValue.getId()));
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeTextId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetTextId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeListId, this.sourceDsId).getListValue().getText(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetListId, targetDsId).getListValue().getText());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeDslId, this.sourceDsId).getDataSetReferenceId(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDslId, targetDsId).getDataSetReferenceId());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeChangeId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChangeId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeEncId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEncId, targetDsId).getStringValue());
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetText1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetList1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDsl1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChange1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEnc1Id, targetDsId));
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void copyDsAttributeValue_noTargetParameters_parametersShouldBeCreated() throws Exception {
        DataSetList targetDslOnlyAttributes = this.dataSetListService.create("TargetDsl3", this.visibilityAreaId);
        UUID targetDslId = targetDslOnlyAttributes.getId();
        DataSet targetDsOnlyAttributes = this.dataSetService.create("TargetDS3", targetDslId);
        UUID targetDsId = targetDsOnlyAttributes.getId();
        Attribute target1AttributeText = this.attributeService.create("text_attr", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList = this.attributeService.create("list_attr", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl = this.attributeService.create("dsl_attr", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange = this.attributeService.create("change_attr", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc = this.attributeService.create("enc_attr", AttributeTypeName.ENCRYPTED, targetDslId);
        Attribute target1AttributeText1 = this.attributeService.create("text_attr_without_parameter", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList1 = this.attributeService.create("list_attr_without_parameter", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl1 = this.attributeService.create("dsl_attr_without_parameter", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange1 = this.attributeService.create("change_attr_without_parameter", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc1 = this.attributeService.create("enc_attr_without_parameter", AttributeTypeName.ENCRYPTED, targetDslId);
        UUID newTargetTextId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextId, target1AttributeText.getId());
        UUID newTargetListId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListId, target1AttributeList.getId());
        UUID newTargetDslId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslId, target1AttributeDsl.getId());
        UUID newTargetChangeId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeId, target1AttributeChange.getId());
        UUID newTargetEncId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeEncId, target1AttributeEnc.getId());
        UUID newTargetText1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextNoParameterId, target1AttributeText1.getId());
        UUID newTargetList1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListNoParameterId, target1AttributeList1.getId());
        UUID newTargetDsl1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslNoParameterId, target1AttributeDsl1.getId());
        UUID newTargetChange1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeNoParameterId, target1AttributeChange1.getId());
        UUID newTargetEnc1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, sourceAttributeEncNoParameterId, target1AttributeEnc1.getId());
        Assertions.assertEquals((Object)target1AttributeText.getId(), (Object)newTargetTextId);
        Assertions.assertEquals((Object)target1AttributeList.getId(), (Object)newTargetListId);
        Assertions.assertEquals((Object)target1AttributeDsl.getId(), (Object)newTargetDslId);
        Assertions.assertEquals((Object)target1AttributeChange.getId(), (Object)newTargetChangeId);
        Assertions.assertEquals((Object)target1AttributeEnc.getId(), (Object)newTargetEncId);
        Assertions.assertEquals((Object)target1AttributeText1.getId(), (Object)newTargetText1Id);
        Assertions.assertEquals((Object)target1AttributeList1.getId(), (Object)newTargetList1Id);
        Assertions.assertEquals((Object)target1AttributeDsl1.getId(), (Object)newTargetDsl1Id);
        Assertions.assertEquals((Object)target1AttributeChange1.getId(), (Object)newTargetChange1Id);
        Assertions.assertEquals((Object)target1AttributeEnc1.getId(), (Object)newTargetEnc1Id);
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeTextId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetTextId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeListId, this.sourceDsId).getListValue().getText(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetListId, targetDsId).getListValue().getText());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeDslId, this.sourceDsId).getDataSetReferenceId(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDslId, targetDsId).getDataSetReferenceId());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeChangeId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChangeId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeEncId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEncId, targetDsId).getStringValue());
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetText1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetList1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDsl1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChange1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEnc1Id, targetDsId));
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void copyDsAttributeValue_noTargetAttributes() throws Exception {
        DataSetList targetDslNoAttributes = this.dataSetListService.create("TargetDsl4", this.visibilityAreaId);
        UUID targetDslId = targetDslNoAttributes.getId();
        DataSet targetDsNoAttributes = this.dataSetService.create("TargetDS4", targetDslId);
        UUID targetDsId = targetDsNoAttributes.getId();
        UUID newTargetTextId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextId, null);
        UUID newTargetListId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListId, null);
        UUID newTargetDslId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslId, null);
        UUID newTargetChangeId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeId, null);
        UUID newTargetEncId = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeEncId, null);
        UUID newTargetText1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeTextNoParameterId, null);
        UUID newTargetList1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeListNoParameterId, null);
        UUID newTargetDsl1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeDslNoParameterId, null);
        UUID newTargetChange1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, this.sourceAttributeChangeNoParameterId, null);
        UUID newTargetEnc1Id = this.dataSetService.copyDsAttributeValue(this.sourceDsId, targetDsId, sourceAttributeEncNoParameterId, null);
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeTextId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetTextId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeListId, this.sourceDsId).getListValue().getText(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetListId, targetDsId).getListValue().getText());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeDslId, this.sourceDsId).getDataSetReferenceId(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDslId, targetDsId).getDataSetReferenceId());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeChangeId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChangeId, targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeEncId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEncId, targetDsId).getStringValue());
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetText1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetList1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetDsl1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetChange1Id, targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(newTargetEnc1Id, targetDsId));
    }

    @Test
    @Sql(scripts={"classpath:test_data/sql/jpa_integration_test/JpaIntegrationTest.sql"})
    public void copyDsAttributeValueBulk_withAllValues() throws Exception {
        DataSetList targetDslAllParametersEqTypes = this.dataSetListService.create("TargetDsl5", this.visibilityAreaId);
        UUID targetDslId = targetDslAllParametersEqTypes.getId();
        DataSet targetDsAllParametersEqTypes = this.dataSetService.create("TargetDS5", targetDslId);
        UUID targetDsId = targetDsAllParametersEqTypes.getId();
        Attribute target1AttributeText = this.attributeService.create("text_attr", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList = this.attributeService.create("list_attr", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl = this.attributeService.create("dsl_attr", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange = this.attributeService.create("change_attr", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc = this.attributeService.create("enc_attr", AttributeTypeName.ENCRYPTED, targetDslId);
        Attribute target1AttributeText1 = this.attributeService.create("text_attr_without_parameter", AttributeTypeName.TEXT, targetDslId);
        Attribute target1AttributeList1 = this.attributeService.create("list_attr_without_parameter", AttributeTypeName.LIST, targetDslId);
        Attribute target1AttributeDsl1 = this.attributeService.create("dsl_attr_without_parameter", AttributeTypeName.DSL, targetDslId);
        Attribute target1AttributeChange1 = this.attributeService.create("change_attr_without_parameter", AttributeTypeName.CHANGE, targetDslId);
        Attribute target1AttributeEnc1 = this.attributeService.create("enc_attr_without_parameter", AttributeTypeName.ENCRYPTED, targetDslId);
        ListValue targetListValue = this.attributeService.createListValue("2", target1AttributeList.getId());
        DataSetList targetDslReference = this.dataSetListService.create("targetDslParameter", this.visibilityAreaId);
        ListValue targetListValue1 = this.attributeService.createListValue("2", target1AttributeList1.getId());
        DataSetList targetDslReference1 = this.dataSetListService.create("targetDslParameter1", this.visibilityAreaId);
        this.parameterService.createParameter(targetDsId, target1AttributeText.getId(), "text2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeList.getId(), null, null, ((ListValueEntity)targetListValue.getEntity()).getId());
        this.parameterService.createParameter(targetDsId, target1AttributeDsl.getId(), null, targetDslReference.getId(), null);
        this.parameterService.createParameter(targetDsId, target1AttributeChange.getId(), "changeType2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeEnc.getId(), "encType2", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeText1.getId(), "text3", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeList1.getId(), null, null, ((ListValueEntity)targetListValue1.getEntity()).getId());
        this.parameterService.createParameter(targetDsId, target1AttributeDsl1.getId(), null, targetDslReference1.getId(), null);
        this.parameterService.createParameter(targetDsId, target1AttributeChange1.getId(), "changeType3", null, null);
        this.parameterService.createParameter(targetDsId, target1AttributeEnc1.getId(), "encType3", null, null);
        Mockito.when((Object)this.decryptor.decryptIfEncrypted((String)ArgumentMatchers.any(String.class))).thenAnswer(i -> i.getArguments()[0]);
        this.dataSetService.copyDsAttributeValueBulk(this.sourceDsId, targetDsId);
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeTextId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeText.getId(), targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeListId, this.sourceDsId).getListValue().getText(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeList.getId(), targetDsId).getListValue().getText());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeDslId, this.sourceDsId).getDataSetReferenceId(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeDsl.getId(), targetDsId).getDataSetReferenceId());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeChangeId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeChange.getId(), targetDsId).getStringValue());
        Assertions.assertEquals((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(this.sourceAttributeEncId, this.sourceDsId).getStringValue(), (Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeEnc.getId(), targetDsId).getStringValue());
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeText1.getId(), targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeList1.getId(), targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeDsl1.getId(), targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeChange1.getId(), targetDsId));
        Assertions.assertNull((Object)this.parameterService.getParameterByAttributeIdAndDataSetId(target1AttributeEnc1.getId(), targetDsId));
    }
}

