/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.antlr4;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang3.math.NumberUtils;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.TextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.qubership.atp.macros.core.parser.antlr4.MacrosBaseListener;
import org.qubership.atp.macros.core.parser.antlr4.MacrosParser;

public class MacroListener
extends MacrosBaseListener {
    private static final String ENDS_WITH_ESC_REGEX = ".*\\\\[&$\"'\\\\<>]";
    private MacroContext macroContext;
    private Stack<AbstractTextParameter> parametersStack = new Stack();
    private List<AbstractTextParameter> parsedParameters = new LinkedList<AbstractTextParameter>();
    private ParameterPositionContext parameterPositionContext;
    private boolean setEvaluate;
    private boolean isNewParam;

    public MacroListener(MacroContext macroContext, ParameterPositionContext parameterPositionContext, boolean setEvaluate) {
        this.macroContext = macroContext;
        this.parameterPositionContext = parameterPositionContext;
        this.setEvaluate = setEvaluate;
    }

    public void enterMacros(MacrosParser.MacrosContext ctx) {
        String macroName = ctx.getChild(0).getText();
        AbstractMacro macro = AbstractMacro.getMacroByName(macroName.substring(0, macroName.indexOf("(")), this.macroContext, this.setEvaluate, this.parameterPositionContext);
        this.parametersStack.push(macro);
    }

    public void exitMacros(MacrosParser.MacrosContext ctx) {
        AbstractTextParameter topTextParameter = this.parametersStack.pop();
        if (this.parametersStack.empty()) {
            this.parsedParameters.add(topTextParameter);
        } else {
            AbstractTextParameter parent = this.parametersStack.peek();
            this.addParameter(parent, topTextParameter, (ParserRuleContext)ctx);
        }
    }

    public void enterText(MacrosParser.TextContext ctx) {
        this.parametersStack.push(new TextParameter(ctx.getText(), this.parameterPositionContext));
    }

    public void exitText(MacrosParser.TextContext ctx) {
        AbstractTextParameter topTextParameter = this.parametersStack.pop();
        if (this.parametersStack.empty()) {
            this.parsedParameters.add(topTextParameter);
        } else {
            AbstractTextParameter parent = this.parametersStack.peek();
            if (this.isNewParam) {
                this.addParameter(parent, topTextParameter, (ParserRuleContext)ctx);
                this.isNewParam = false;
            } else {
                List<AbstractTextParameter> childTextParameters = parent.getChildTextParameters();
                int lastIndex = childTextParameters.size() - 1;
                String value = childTextParameters.get(lastIndex).getValue();
                String escaped = ctx.getText();
                if (ctx.ESC().size() != NumberUtils.INTEGER_ZERO.intValue() || value.matches(ENDS_WITH_ESC_REGEX)) {
                    escaped = ctx.getText().substring(1);
                }
                childTextParameters.set(lastIndex, new TextParameter(value + escaped, this.parameterPositionContext));
            }
        }
    }

    public void enterMacroParam(MacrosParser.MacroParamContext ctx) {
        this.isNewParam = true;
    }

    public void exitQuote(MacrosParser.QuoteContext ctx) {
        this.parsedParameters.add(new TextParameter(ctx.getText(), this.parameterPositionContext));
    }

    public void exitSlash(MacrosParser.SlashContext ctx) {
        this.parsedParameters.add(new TextParameter(ctx.getText(), this.parameterPositionContext));
    }

    private void addParameter(AbstractTextParameter parent, AbstractTextParameter parameter, ParserRuleContext ctx) {
        if (!parent.isSkipExternalChildrenParse()) {
            parent.addTextParameter(parameter);
        }
        parent.setParameters(ctx.getParent().getParent().getParent().getText());
    }

    public List<AbstractTextParameter> getParsedParameters() {
        return this.parsedParameters;
    }

    public void setSetEvaluate(boolean setEvaluate) {
        this.setEvaluate = setEvaluate;
    }
}

