/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.dto.AttributePathDto;
import org.qubership.atp.dataset.db.generated.QAttributeKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AttributePathRepository
extends AbstractRepository {
    private static final AttributePathProjection PROJECTION = new AttributePathProjection();
    private final Provider<ParameterRepository> paramRepo;
    private final SQLQueryFactory queryFactory;
    public static final Splitter SPLITTER = Splitter.on((String)"_");
    public static final Joiner JOINER = Joiner.on((String)"_");

    @Autowired
    public AttributePathRepository(@Nonnull Provider<ParameterRepository> paramRepo, @Nonnull SQLQueryFactory queryFactory) {
        this.paramRepo = paramRepo;
        this.queryFactory = queryFactory;
    }

    @Nonnull
    AttributePathDto create(UUID dataSetListId, UUID dataSetId, UUID targetAttributeId, List<UUID> attributePathIds) {
        String attrKey = JOINER.join(attributePathIds);
        UUID id = (UUID)Preconditions.checkNotNull((Object)((UUID)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)AK).set((Path)AttributePathRepository.AK.key, (Object)attrKey)).set(AttributePathRepository.AK.datasetlistId, (Object)dataSetListId)).set(AttributePathRepository.AK.datasetId, (Object)dataSetId)).set(AttributePathRepository.AK.attributeId, (Object)targetAttributeId)).executeWithKey(AttributePathRepository.AK.id)), (Object)"nothing created");
        return new AttributePathDto(id, dataSetListId, dataSetId, targetAttributeId, attributePathIds);
    }

    void delete(UUID dataSetListId, UUID dataSetId, UUID targetAttributeId, List<UUID> attributePathIds) {
        String attrKey = JOINER.join(attributePathIds);
        for (UUID akId : ((SQLQuery)((SQLQuery)this.queryFactory.select(AttributePathRepository.AK.id).from((Expression)AK)).where((Predicate)AttributePathRepository.AK.key.eq((Object)attrKey).and((Predicate)AttributePathRepository.AK.datasetId.eq((Object)dataSetId)).and((Predicate)AttributePathRepository.AK.attributeId.eq((Object)targetAttributeId)))).fetch()) {
            this.delete(akId);
        }
    }

    boolean delete(@Nonnull UUID id) {
        ((ParameterRepository)this.paramRepo.get()).onAttrPathDeleteCascade(id);
        return this.delete((Predicate)AttributePathRepository.AK.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)AK).where(predicate)).execute();
    }

    @Nullable
    AttributePathDto get(UUID dataSetListId, UUID dataSetId, UUID targetAttributeId, List<UUID> attributePathIds) {
        String attrKey = JOINER.join(attributePathIds);
        UUID id = (UUID)((SQLQuery)((SQLQuery)this.queryFactory.select(AttributePathRepository.AK.id).from((Expression)AK)).where((Predicate)AttributePathRepository.AK.key.eq((Object)attrKey).and((Predicate)AttributePathRepository.AK.datasetId.eq((Object)dataSetId)).and((Predicate)AttributePathRepository.AK.attributeId.eq((Object)targetAttributeId)))).fetchOne();
        if (id == null) {
            return null;
        }
        return new AttributePathDto(id, dataSetListId, dataSetId, targetAttributeId, attributePathIds);
    }

    @Nullable
    AttributePathDto getById(@Nonnull UUID id) {
        return (AttributePathDto)this.select((Predicate)AttributePathRepository.AK.id.eq((Object)id)).fetchOne();
    }

    @Nullable
    List<AttributePathDto> getByTargetAttrId(@Nonnull UUID targetAttrId) {
        return this.select((Predicate)AttributePathRepository.AK.attributeId.eq((Object)targetAttrId)).fetch();
    }

    void onAttrDeleteCascade(@Nonnull UUID attributeId) {
        this.getAllWithAttrId(attributeId).forEach(dto -> {
            UUID id = dto.getId();
            this.delete(id);
        });
    }

    private List<AttributePathDto> getAllWithAttrId(UUID id) {
        String pattern = "%" + id + "%";
        return this.select((Predicate)AttributePathRepository.AK.attributeId.eq((Object)id).or((Predicate)AttributePathRepository.AK.key.like(pattern))).fetch();
    }

    @Nonnull
    private SQLQuery<AttributePathDto> select(@Nonnull Predicate predicate) {
        return (SQLQuery)((SQLQuery)this.queryFactory.select((Expression)PROJECTION).from((Expression)AK)).where(predicate);
    }

    public void onDsDeleteCascade(UUID dataSetId) {
        for (UUID attributeKey : ((SQLQuery)((SQLQuery)this.queryFactory.select(AttributePathRepository.AK.id).from((Expression)AK)).where((Predicate)AttributePathRepository.AK.datasetId.eq((Object)dataSetId))).fetch()) {
            this.delete(attributeKey);
        }
    }

    protected static class AttributePathProjection
    extends MappingProjection<AttributePathDto> {
        AttributePathProjection() {
            super(AttributePathDto.class, (Expression[])AbstractRepository.AK.all());
        }

        @Nonnull
        protected static AttributePathDto createDto(@Nonnull QAttributeKey ak, @Nonnull Tuple row) {
            UUID id = (UUID)row.get(ak.id);
            assert (id != null);
            String key = (String)row.get((Expression)ak.key);
            assert (key != null);
            UUID dslId = (UUID)row.get(ak.datasetlistId);
            assert (dslId != null);
            UUID dsId = (UUID)row.get(ak.datasetId);
            assert (dsId != null);
            UUID targetAttrId = (UUID)row.get(ak.attributeId);
            assert (targetAttrId != null);
            return AttributePathProjection.createDto(id, dslId, dsId, targetAttrId, key);
        }

        protected static AttributePathDto createDto(@Nonnull UUID id, @Nonnull UUID dslId, @Nonnull UUID dsId, @Nonnull UUID targetAttrId, @Nonnull String attrKey) {
            List<UUID> parts = StreamSupport.stream(SPLITTER.split((CharSequence)attrKey).spliterator(), false).map(UUID::fromString).collect(Collectors.toList());
            return new AttributePathDto(id, dslId, dsId, targetAttrId, parts);
        }

        protected AttributePathDto map(Tuple row) {
            return AttributePathProjection.createDto(AbstractRepository.AK, row);
        }
    }
}

