/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.cache;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.model.Parameter;

public class CachedParameter {
    private Parameter parameter;
    private UUID topDataSetId;
    private List<UUID> parameterPath;

    public int hashCode() {
        if (this.parameterPath.isEmpty()) {
            return this.parameter.hashCode();
        }
        int hashCode = 1;
        for (UUID obj : this.parameterPath) {
            hashCode = 31 * hashCode + (obj == null ? 0 : ((Object)obj).hashCode());
        }
        hashCode = 31 * hashCode + this.parameter.hashCode();
        hashCode = 31 * hashCode + this.topDataSetId.hashCode();
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CachedParameter) {
            CachedParameter other = (CachedParameter)obj;
            boolean sameParameter = other.getParameter().equals(this.parameter);
            boolean samePath = other.getParameterPath().equals(this.parameterPath);
            boolean sameDataSet = other.getTopDataSetId().equals(this.topDataSetId);
            return sameParameter && samePath && sameDataSet;
        }
        if (obj instanceof Parameter) {
            return obj.equals(this.parameter);
        }
        return false;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public UUID getTopDataSetId() {
        return this.topDataSetId;
    }

    public List<UUID> getParameterPath() {
        return this.parameterPath;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public void setTopDataSetId(UUID topDataSetId) {
        this.topDataSetId = topDataSetId;
    }

    public void setParameterPath(List<UUID> parameterPath) {
        this.parameterPath = parameterPath;
    }

    public CachedParameter(Parameter parameter, UUID topDataSetId, List<UUID> parameterPath) {
        this.parameter = parameter;
        this.topDataSetId = topDataSetId;
        this.parameterPath = parameterPath;
    }
}

