/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.parser.TokenType;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;
import org.qubership.atp.dataset.macros.processor.RefAliasProcessor;

public final class RefAliasContext
extends MacroContextBase {
    protected final StringBuilder text = new StringBuilder();
    private final RefAliasProcessor processor;
    private final MacroRegistry registry;
    public int offset;
    public int replacementDiff;
    protected Macros macros;
    protected ArgsParser args;
    private boolean hasChildren;

    public RefAliasContext(@Nonnull RefAliasProcessor processor, @Nonnull MacroRegistry registry) {
        this.processor = processor;
        this.registry = registry;
        this.offset = 0;
        this.replacementDiff = 0;
    }

    public RefAliasContext(@Nonnull RefAliasContext parent, @Nonnull String macro) {
        super(parent, macro);
        this.processor = parent.processor;
        this.registry = parent.registry;
        this.offset = parent.offset;
        this.replacementDiff = parent.replacementDiff;
        this.initialize(macro);
        parent.hasChildren = true;
    }

    @Override
    public void initialize(@Nonnull String macro) {
        super.initialize(macro);
        this.macros = this.registry.getMacros(macro);
        this.args = this.macros.createArgsParser();
        this.hasChildren = false;
        this.offset += macro.length() + TokenType.FORMULA_START.extraSymbolsCount;
    }

    @Override
    public void uninitialize() {
        this.offset += TokenType.FORMULA_END.extraSymbolsCount;
        super.uninitialize();
    }

    @Override
    protected void pushArguments(@Nonnull String args) {
        this.args.append(args);
        this.offset += args.length();
    }

    @Override
    protected void evaluate() throws CtxEvalException {
        ArgsParser.Result parsedArgs = this.hasChildren ? this.args.tryParse() : this.args.parseToTheEnd();
        this.getProcessor().notifyRefsFound(this, parsedArgs);
    }

    @Override
    protected void pushText(@Nonnull String text) {
        this.text.append(text);
        this.offset += text.length();
    }

    @Override
    @Nonnull
    public RefAliasProcessor getProcessor() {
        return this.processor;
    }
}

