/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.impl.file;

import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.Nonnull;

public class FileData {
    private String fileName;
    private UUID parameterUuid;
    private String fileType;
    private String contentType;
    private String url;

    public FileData() {
    }

    public FileData(@Nonnull String fileName, @Nonnull UUID parameterUuid, @Nonnull String contentType) {
        this();
        this.fileName = fileName;
        this.parameterUuid = parameterUuid;
        this.fileType = this.getFileExtension(fileName);
        this.contentType = Strings.isNullOrEmpty((String)contentType) ? "plain/text" : contentType;
        this.url = "/attachment/" + parameterUuid;
    }

    private String getFileExtension(String fileName) {
        if (Strings.isNullOrEmpty((String)fileName)) {
            return null;
        }
        int lastIndex = fileName.lastIndexOf(46);
        String contentType = "unknown";
        if (lastIndex > -1) {
            contentType = fileName.substring(lastIndex + 1);
        }
        return contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public UUID getParameterUuid() {
        return this.parameterUuid;
    }

    public void setParameterUuid(UUID parameterUuid) {
        this.parameterUuid = parameterUuid;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

