/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.helper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.LabelProvider;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.AttributePathImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.DataSetListImpl;
import org.qubership.atp.dataset.model.impl.LabelImpl;
import org.qubership.atp.dataset.model.impl.ListValueImpl;
import org.qubership.atp.dataset.model.impl.ParameterBaseImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.impl.ParameterOverlapImpl;
import org.qubership.atp.dataset.model.impl.TestPlanImpl;
import org.qubership.atp.dataset.model.impl.VisibilityAreaImpl;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.FileDataDao;

public class SimpleCreationFacade
implements CreationFacade {
    public static final SimpleCreationFacade INSTANCE = new SimpleCreationFacade();
    private static final Supplier<UUID> UUIDS = UUID::randomUUID;
    private static final UUID CREATED_BY = UUID.fromString("1c0167c9-1bea-4587-8f32-d637ff341d31");

    private SimpleCreationFacade() {
    }

    @Nullable
    public static ListValue getListValueByName(@Nonnull Attribute source, @Nullable String listValueName) {
        if (listValueName == null) {
            return null;
        }
        Preconditions.checkNotNull(source.getListValues(), (String)"Can not find list value with name %s: source %s has no list values", (Object)listValueName, (Object)source);
        Optional<ListValue> lvOpt = source.getListValues().stream().filter(lv -> listValueName.equals(lv.getName())).findFirst();
        Preconditions.checkArgument((boolean)lvOpt.isPresent(), (String)"No list value with name %s found. Available list values: %s", (Object)listValueName, source.getListValues());
        return lvOpt.get();
    }

    @Nonnull
    private static List<ListValue> convertListValues(@Nonnull Attribute attr, @Nullable List<String> lvNames) {
        if (lvNames == null) {
            return Lists.newArrayList();
        }
        return lvNames.stream().map(lvName -> new ListValueImpl(UUIDS.get(), attr, (String)lvName)).collect(Collectors.toList());
    }

    @Override
    public DataSetList dsl(@Nonnull VisibilityArea va, @Nonnull String name, @Nullable TestPlan testPlan) {
        Timestamp createdWhen = Timestamp.from(Instant.now());
        DataSetListImpl dataSetList = new DataSetListImpl(UUIDS.get(), va, name, Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList(), testPlan, CREATED_BY, createdWhen, CREATED_BY, createdWhen);
        va.getDataSetLists().add(dataSetList);
        return dataSetList;
    }

    @Override
    public DataSetList dsl(@Nonnull VisibilityArea va, @Nonnull String name) {
        return this.dsl(va, name, null);
    }

    @Override
    public VisibilityArea va(@Nonnull String name) {
        return new VisibilityAreaImpl(UUIDS.get(), name, Lists.newArrayList());
    }

    @Override
    public TestPlan testPlan(@Nonnull VisibilityArea visibilityArea, @Nonnull String name) {
        return new TestPlanImpl(UUIDS.get(), name, visibilityArea);
    }

    @Override
    public DataSet ds(@Nonnull DataSetList dsl, @Nonnull String name) {
        return this.ds(dsl, name, null);
    }

    public DataSet ds(@Nonnull DataSetList dsl, @Nonnull String name, @Nullable TestPlan testPlan) {
        DataSetImpl ds = new DataSetImpl(UUIDS.get(), name, dsl, (List<Parameter>)Lists.newArrayList(), (List<Label>)Lists.newArrayList(), (Boolean)false);
        dsl.getDataSets().add(ds);
        return ds;
    }

    @Override
    public Parameter param(@Nonnull DataSet ds, @Nonnull Attribute attr, String text, String listValue, DataSet dsRef, FileDataDao fileDataDao, @Nullable List<Attribute> path) {
        ParameterBaseImpl result;
        ListValue lv = SimpleCreationFacade.getListValueByName(attr, listValue);
        if (path == null) {
            result = new ParameterImpl(UUIDS.get(), attr, ds, text, lv, dsRef);
            attr.getParameters().add(result);
        } else {
            AttributePathImpl attrPath = new AttributePathImpl(UUIDS.get(), ds, attr, path);
            result = new ParameterOverlapImpl(UUIDS.get(), attrPath, ds, text, lv, dsRef);
        }
        if (fileDataDao != null) {
            FileData fileData = new FileData(fileDataDao.fileName, result.getId(), fileDataDao.contentType);
            result.setFileData(fileData);
        }
        ds.getParameters().add(result);
        return result;
    }

    @Override
    public Label label(@Nonnull LabelProvider labelProvider, @Nonnull String name) {
        LabelImpl result = new LabelImpl(UUIDS.get(), name);
        labelProvider.getLabels().add(result);
        return result;
    }

    @Override
    public Attribute attr(@Nonnull DataSetList dsl, @Nonnull String name, @Nonnull AttributeType type, DataSetList dslRef, List<String> listValues) {
        AttributeImpl result = new AttributeImpl(UUIDS.get(), name, dsl, type, dslRef, null, Lists.newArrayList());
        List<ListValue> lvs = SimpleCreationFacade.convertListValues(result, listValues);
        result.setListValues(lvs);
        dsl.getAttributes().add(result);
        return result;
    }
}

