/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.db.ParameterRepository;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.dataset.DataSetExistsException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributePath;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.AtpDsSerializer;
import org.qubership.atp.dataset.model.utils.CheckedConsumer;
import org.qubership.atp.dataset.model.utils.ObjectShortResponse;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.AtpMacrosCacheService;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.rest.PaginationResponse;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataSetServiceImpl
implements DataSetService {
    private static final Logger log = LoggerFactory.getLogger(DataSetServiceImpl.class);
    private final ParameterService parameterService;
    private AttributeService attributeService;
    private final DataSetRepository repo;
    private final ParameterRepository paramRepo;
    private final DataSetListRepository dslRepo;
    private final ObjectMapper mapper;
    private final EvaluationService evaluationService;
    private final AtpMacrosCacheService cacheService;
    private final DateAuditorService dateAuditorService;
    private final DataSetListSnapshotService dataSetListSnapshotService;
    private final ModelsProvider modelsProvider;
    private final ClearCacheService clearCacheService;

    @Override
    @Nonnull
    @Transactional
    public DataSet create(@Nonnull UUID dslId, @Nonnull String name) {
        for (String dataSetName : this.repo.getOccupiedNamesByParentId(dslId)) {
            if (!dataSetName.equalsIgnoreCase(name)) continue;
            log.error("Dataset with name '" + name + "' already exists");
            throw new DataSetExistsException(name);
        }
        DataSet dataSet = this.repo.create(dslId, name);
        this.dateAuditorService.updateModifiedFields(dslId);
        this.dataSetListSnapshotService.commitEntity(dslId);
        return dataSet;
    }

    @Override
    @Nullable
    public ObjectNode getInItfFormat(@Nonnull MixInId id) {
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(true, false);){
            DataSet ds = evaluator.getDataSetById(id);
            if (ds == null) {
                ObjectNode objectNode = null;
                return objectNode;
            }
            ObjectNode objectNode = Utils.serializeInItfWay(ds, this.mapper, evaluator);
            return objectNode;
        }
    }

    @Override
    @Nullable
    public CheckedConsumer<OutputStream, IOException> writeInAtpFormat(@Nonnull MixInId id, @Nullable Map<String, String> context, boolean evaluate) {
        DataSet ds;
        DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, false);
        try {
            ds = evaluator.getDataSetById(id);
            if (ds == null) {
                evaluator.close();
                return null;
            }
        }
        catch (Exception e) {
            evaluator.close();
            throw e;
        }
        return outputStream -> {
            try {
                this.cacheService.setContext(context);
                AtpDsSerializer.writeValue(outputStream, ds, evaluator);
            }
            finally {
                evaluator.close();
                this.cacheService.destroy();
            }
        };
    }

    @Override
    @Nullable
    public DataSet get(@Nonnull UUID id) {
        return this.repo.getById(id);
    }

    @Override
    public boolean existsById(@NotNull UUID id) {
        return this.repo.existsById(id);
    }

    @Override
    @Nonnull
    public List<DataSet> getAll() {
        return this.repo.getAll();
    }

    @Override
    @Nonnull
    public List<DataSet> getAll(@Nonnull List<UUID> dataSetsIds) {
        return this.repo.getAll(dataSetsIds);
    }

    @Override
    @Nonnull
    public List<DataSet> getAllDslDsByAttribute(UUID targetAttrId, List<UUID> attrPathIds) {
        log.debug("get all related datasets by attribute {} and attrPathIds {}", (Object)targetAttrId, attrPathIds);
        UUID sourceAttributeId = !CollectionUtils.isEmpty(attrPathIds) ? attrPathIds.get(0) : targetAttrId;
        log.debug("get all related datasets for attribute {}, source attribute {}", (Object)targetAttrId, (Object)sourceAttributeId);
        Attribute attribute = (Attribute)this.attributeService.get(sourceAttributeId);
        Preconditions.checkNotNull((Object)attribute, (String)"Attribute with id {} not found", (Object)sourceAttributeId);
        DataSetList dsl = attribute.getDataSetList();
        return Objects.isNull(dsl.getDataSets()) ? Collections.emptyList() : dsl.getDataSets();
    }

    @Override
    @Transactional
    public void rename(@Nonnull UUID id, @Nonnull String name) {
        DataSet dataSet = this.repo.getById(id);
        if (dataSet != null) {
            Preconditions.checkArgument((dataSet.isLocked() == false ? 1 : 0) != 0, (String)"Can not rename dataSet with name '%s', id : %s because dataset locked", (Object)dataSet.getName(), (Object)dataSet.getId());
            for (String dataSetName : this.repo.getOccupiedNamesByParentId(dataSet.getDataSetList().getId())) {
                if (!dataSetName.equals(name)) continue;
                throw new DataSetExistsException(name);
            }
            Preconditions.checkArgument((boolean)this.repo.rename(id, name), (String)"Can not update name to [%s] of data set %s", (Object)name, (Object)id);
            DataSetList dataSetList = dataSet.getDataSetList();
            this.dateAuditorService.updateModifiedFields(dataSetList.getId());
            this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
            this.evictAllAffectedDatasetsFromContextCacheByDsId(id);
        }
    }

    @Override
    @Transactional
    public void lock(UUID dataSetListId, @Nonnull List<UUID> uuids, boolean isLock) {
        log.info("Lock or Unlock changes to Datasets by Uuids: {}, locked flag: {}", uuids, (Object)isLock);
        if (!uuids.isEmpty()) {
            Preconditions.checkArgument((boolean)this.repo.lock(uuids, isLock), (String)"Can not update lock ds ids to %s of lock flag %s, dataSetList id %s", uuids, (Object)isLock, (Object)dataSetListId);
            this.dateAuditorService.updateModifiedFields(dataSetListId);
            this.dataSetListSnapshotService.commitEntity(dataSetListId);
        }
    }

    @Override
    @Transactional
    public void delete(@Nonnull UUID dataSetId) {
        DataSet dataSet = this.repo.getById(dataSetId);
        UUID dataSetListId = null;
        if (dataSet != null) {
            dataSetListId = dataSet.getDataSetList().getId();
            Preconditions.checkArgument((dataSet.isLocked() == false ? 1 : 0) != 0, (String)"Can not delete dataSet with name '%s', id : %s because dataset locked", (Object)dataSet.getName(), (Object)dataSet.getId());
        }
        this.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        Preconditions.checkArgument((boolean)this.repo.delete(dataSetId), (String)"Can not delete data set %s", (Object)dataSetId);
        if (dataSetListId != null) {
            this.dateAuditorService.updateModifiedFields(dataSetListId);
            this.dataSetListSnapshotService.findAndCommitIfExists(dataSetListId);
        }
    }

    @Override
    @Transactional
    public DataSet copy(@Nonnull UUID dataSetId, @Nonnull String name) {
        DataSet dataSetToCopy = this.get(dataSetId);
        UUID dataSetListId = dataSetToCopy.getDataSetList().getId();
        DataSet newDataSet = this.createDsWithParamsAndLabels(dataSetToCopy, name, dataSetListId, null);
        newDataSet.setLocked(false);
        this.dataSetListSnapshotService.commitEntity(newDataSet.getDataSetList().getId());
        return newDataSet;
    }

    @Override
    public DataSet copy(@Nonnull UUID dataSetId, @Nonnull UUID dataSetListId, @Nonnull Map<UUID, UUID> attributes) {
        DataSet dataSetToCopy = this.get(dataSetId);
        String name = dataSetToCopy.getName();
        return this.createDsWithParamsAndLabels(dataSetToCopy, name, dataSetListId, attributes);
    }

    @Override
    public DataSet copy(@Nonnull DataSet dataSet, @Nonnull UUID dataSetListId, @Nonnull Map<UUID, UUID> attributes) {
        return this.createDsWithParamsAndLabels(dataSet, dataSet.getName(), dataSetListId, attributes);
    }

    private DataSet createDsWithParamsAndLabels(DataSet dataSetToCopy, String name, UUID dataSetListId, @Nullable Map<UUID, UUID> attributes) {
        Preconditions.checkNotNull((Object)dataSetToCopy, (String)"Can not find dataSet to copy", (Object)name);
        DataSet newDataSet = this.create(dataSetListId, name);
        for (Parameter param : dataSetToCopy.getParameters()) {
            if (attributes != null) {
                this.parameterService.copy(newDataSet, param, attributes);
                continue;
            }
            this.parameterService.copy(newDataSet, param, null);
        }
        for (Label label : dataSetToCopy.getLabels()) {
            this.repo.mark(newDataSet.getId(), label.getName());
        }
        return newDataSet;
    }

    @Override
    @Nullable
    public UiManAttribute getParametersOnAttributePath(@Nonnull UUID dsId, @Nonnull List<UUID> attrPath, boolean evaluate) {
        if (attrPath.isEmpty()) {
            return null;
        }
        DataSet ds = this.get(dsId);
        if (ds == null) {
            return null;
        }
        try (DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, true);){
            UiManAttribute uiManAttribute = Utils.doUiAttr(ds, evaluator, attrPath);
            return uiManAttribute;
        }
    }

    @Override
    public List<?> getOverlapContainers(@Nonnull UUID dataSetId, @Nonnull UUID attributeId, boolean withInfo) {
        DataSet currentDs = this.get(dataSetId);
        Preconditions.checkNotNull((Object)currentDs, (String)"No data set found by id: %s", (Object)dataSetId);
        List res = this.parameterService.getOverlaps(attributeId, new OverlapPredicate(currentDs)).collect(Collectors.toList());
        if (withInfo) {
            return res.stream().map(TableResponse::fromParameterOverlap).distinct().collect(Collectors.toList());
        }
        return res.stream().map(Parameter::getDataSet).distinct().collect(Collectors.toList());
    }

    @Override
    public List<?> getAffectedDataSetsByChangesDataSetReference(@Nonnull UUID dataSetId, boolean deleteDs) {
        if (deleteDs) {
            return this.repo.getAffectedInfoByChangesDataSetReference(dataSetId);
        }
        return this.repo.getAffectedDataSetsByChangesDataSetReference(dataSetId);
    }

    @Override
    @Transactional
    public void deleteAllParameterOverlaps(UUID attributeId, List<UUID> dataSetsIds) {
        this.removeFromListDsLocked(attributeId, dataSetsIds);
        this.paramRepo.deleteOverlaps(attributeId, path -> dataSetsIds.contains(path.getDataSet().getId()));
        dataSetsIds.stream().map(dataSetsId -> this.repo.getById((UUID)dataSetsId)).collect(Collectors.groupingBy(DataSet::getDataSetList)).keySet().forEach(dataSetList -> {
            this.dateAuditorService.updateModifiedFields(dataSetList.getId());
            this.dataSetListSnapshotService.commitEntity(dataSetList.getId());
        });
    }

    private void removeFromListDsLocked(UUID attributeId, List<UUID> dataSetsIds) {
        List filteredDsLocked = dataSetsIds.stream().filter(dsId -> {
            DataSet dataSet = this.repo.getById((UUID)dsId);
            return Objects.isNull(dataSet) || dataSet.isLocked() != false;
        }).collect(Collectors.toList());
        dataSetsIds.removeAll(filteredDsLocked);
        log.info("Remove for skip locked datasets id:{}, attribute id: {}", filteredDsLocked, (Object)attributeId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE_OS"}, key="#dsId")
    public Parameter deleteParameterOverlap(@Nonnull UUID dsId, @Nonnull UUID targetAttrId, @Nonnull List<UUID> attrPathIds) {
        DataSet ds = this.get(dsId);
        Preconditions.checkArgument((ds != null ? 1 : 0) != 0, (String)"No data set found by id: %s", (Object)dsId);
        Preconditions.checkArgument((ds.isLocked() == false ? 1 : 0) != 0, (String)"Can not delete ParameterOverlap for dataSet with name '%s', id: %s because dataset locked", (Object)ds.getName(), (Object)ds.getId());
        this.paramRepo.deleteOverlap(ds.getDataSetList().getId(), dsId, targetAttrId, attrPathIds);
        Parameter parameter = ((OverlapItem)OverlapIterator.create(ds, targetAttrId, attrPathIds).next()).getParameter().orElse(null);
        if (parameter != null) {
            this.dateAuditorService.updateModifiedFields(parameter.getDataSet().getDataSetList().getId());
        }
        this.dataSetListSnapshotService.findAndCommitIfExists(ds.getDataSetList().getId());
        return parameter;
    }

    @Override
    @Nonnull
    public Stream<DataSet> getByParentId(UUID dataSetListId, boolean evaluate, @Nullable String labelName) {
        DataSetList parent = this.dslRepo.getById(dataSetListId);
        if (parent == null) {
            log.warn("No dsl found by id: " + dataSetListId);
            return Stream.empty();
        }
        DsEvaluator evaluator = this.evaluationService.getEvaluator(evaluate, false);
        List<DataSet> children = labelName == null ? this.repo.getByParentId(dataSetListId) : this.repo.getByParentIdAndLabel(dataSetListId, labelName);
        return evaluator.getDataSets(parent, children.stream());
    }

    @Override
    public List<ObjectShortResponse> getByParentId(UUID dataSetListId) {
        return this.repo.getByParentId(dataSetListId).stream().map(dataSet -> new ObjectShortResponse(dataSet.getId(), dataSet.getName(), dataSet.isLocked())).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Label mark(@Nonnull UUID dataSetId, @Nonnull String name) {
        Label label = this.repo.mark(dataSetId, name);
        DataSet dataset = this.repo.getById(dataSetId);
        if (dataset != null) {
            this.dateAuditorService.updateModifiedFields(dataset.getDataSetList().getId());
        }
        this.dataSetListSnapshotService.commitEntity(dataset.getDataSetList().getId());
        return label;
    }

    @Override
    public List<Label> getLabels(@Nonnull UUID dataSetId) {
        return this.repo.getLabels(dataSetId);
    }

    @Override
    @Transactional
    public boolean unmark(@Nonnull UUID dataSetId, @Nonnull UUID labelId) {
        DataSet dataset;
        boolean isUnmarked = this.repo.unmark(dataSetId, labelId);
        if (isUnmarked && (dataset = this.repo.getById(dataSetId)) != null) {
            this.dateAuditorService.updateModifiedFields(dataset.getDataSetList().getId());
            this.dataSetListSnapshotService.commitEntity(dataset.getDataSetList().getId());
        }
        return isUnmarked;
    }

    @Override
    @Transactional
    public boolean restore(@Nonnull JsonNode dataSetJson) {
        boolean ds;
        UUID dataSetId = UUID.fromString(dataSetJson.get("id").asText());
        String dataSetName = dataSetJson.get("name").asText();
        UUID dataSetListId = UUID.fromString(dataSetJson.get("dataSetList").asText());
        UUID previousDataSetId = dataSetJson.get("previousDataSet") == null ? null : UUID.fromString(dataSetJson.get("previousDataSet").asText());
        DataSet dataSetDb = this.get(dataSetId);
        if (Objects.nonNull(dataSetDb)) {
            Preconditions.checkArgument((dataSetDb.isLocked() == false ? 1 : 0) != 0, (String)"Can not restore dataSet with name: '%s', id: %s because dataset locked", (Object)dataSetDb.getName(), (Object)dataSetDb.getId());
        }
        if (ds = this.repo.restore(dataSetListId, dataSetId, dataSetName, previousDataSetId)) {
            JsonNode labelsNode;
            JsonNode parametersNode = dataSetJson.get("parameters");
            if (parametersNode != null) {
                Iterator parametersIterator = parametersNode.elements();
                while (parametersIterator.hasNext()) {
                    JsonNode parameterNode = (JsonNode)parametersIterator.next();
                    UUID attribute = UUID.fromString(parameterNode.get("attribute").asText());
                    String text = parameterNode.get("text").asText();
                    UUID listValue = parameterNode.get("listValue") == null ? null : UUID.fromString(parameterNode.get("listValue").asText());
                    UUID dataSetReference = parameterNode.get("dataSetReference") == null ? null : UUID.fromString(parameterNode.get("dataSetReference").asText());
                    ArrayList<UUID> attrPathIds = null;
                    JsonNode attrKeyNode = parameterNode.get("attrKey");
                    if (attrKeyNode != null) {
                        Iterator attrKeyIterator = attrKeyNode.elements();
                        attrPathIds = new ArrayList<UUID>();
                        while (attrKeyIterator.hasNext()) {
                            attrPathIds.add(UUID.fromString(((JsonNode)attrKeyIterator.next()).asText()));
                        }
                    }
                    this.parameterService.set(dataSetId, attribute, attrPathIds, text, dataSetReference, listValue);
                }
            }
            if ((labelsNode = dataSetJson.get("labels")) != null) {
                Iterator labelsIterator = labelsNode.elements();
                while (labelsIterator.hasNext()) {
                    this.repo.mark(dataSetId, ((JsonNode)labelsIterator.next()).get("name").asText());
                }
            }
            this.dataSetListSnapshotService.findAndCommitIfExists(dataSetListId);
        }
        return true;
    }

    @Override
    public PaginationResponse<TableResponse> getAffectedDataSets(UUID dataSetId, Integer page, Integer size) {
        PageRequest pageRequest = Objects.nonNull(page) && Objects.nonNull(size) ? PageRequest.of((int)page, (int)size) : null;
        return this.modelsProvider.getParametersByDatasetId(dataSetId, (Pageable)pageRequest);
    }

    @Override
    public Long getAffectedDataSetsCount(UUID dataSetId) {
        return this.modelsProvider.getParametersByDatasetId(dataSetId, null).getTotalCount();
    }

    @Override
    public void evictAllAffectedDatasetsFromContextCacheByDslId(UUID updatedDataSetListId) {
        Set<UUID> affectedDataSetIds = this.collectAffectedDatasetsByDslId(updatedDataSetListId);
        this.clearCacheService.evictDatasetListContextCache(affectedDataSetIds);
    }

    @Override
    public void evictAllAffectedDatasetsFromContextCacheByDsId(UUID updatedDataSetId) {
        Set<UUID> affectedDataSetIds = this.collectAffectedDatasetsByDsId(updatedDataSetId);
        this.clearCacheService.evictDatasetListContextCache(affectedDataSetIds);
    }

    @Override
    @Nonnull
    public Set<UUID> collectAffectedDatasetsByDslId(UUID updatedDataSetListId) {
        boolean hasNext;
        HashSet<UUID> affectedDatasetListIds = new HashSet<UUID>();
        affectedDatasetListIds.add(updatedDataSetListId);
        LinkedList<UUID> datasetListIds = this.modelsProvider.getAffectedDataSetsListIdsByDataSetListId(Collections.singletonList(updatedDataSetListId));
        affectedDatasetListIds.addAll(datasetListIds);
        boolean bl = hasNext = !datasetListIds.isEmpty();
        while (hasNext) {
            datasetListIds = this.modelsProvider.getAffectedDataSetsListIdsByDataSetListId(datasetListIds);
            affectedDatasetListIds.addAll(datasetListIds);
            hasNext = !datasetListIds.isEmpty();
        }
        return this.modelsProvider.getAffectedDataSetsIdsByDataSetListId(affectedDatasetListIds);
    }

    @Override
    @Nonnull
    public Set<UUID> collectAffectedDatasetsByDsId(UUID updatedDataSetId) {
        HashSet<UUID> affectedDataSetIds = new HashSet<UUID>();
        affectedDataSetIds.add(updatedDataSetId);
        this.modelsProvider.getUniqueDataSetIdsByReferenceDataSetId(updatedDataSetId).stream().map(this::collectAffectedDatasetsByDsId).forEach(affectedDataSetIds::addAll);
        return affectedDataSetIds;
    }

    public DataSetServiceImpl(ParameterService parameterService, AttributeService attributeService, DataSetRepository repo, ParameterRepository paramRepo, DataSetListRepository dslRepo, ObjectMapper mapper, EvaluationService evaluationService, AtpMacrosCacheService cacheService, DateAuditorService dateAuditorService, DataSetListSnapshotService dataSetListSnapshotService, ModelsProvider modelsProvider, ClearCacheService clearCacheService) {
        this.parameterService = parameterService;
        this.attributeService = attributeService;
        this.repo = repo;
        this.paramRepo = paramRepo;
        this.dslRepo = dslRepo;
        this.mapper = mapper;
        this.evaluationService = evaluationService;
        this.cacheService = cacheService;
        this.dateAuditorService = dateAuditorService;
        this.dataSetListSnapshotService = dataSetListSnapshotService;
        this.modelsProvider = modelsProvider;
        this.clearCacheService = clearCacheService;
    }

    private class OverlapPredicate
    implements Predicate<AttributePath> {
        private final DataSet currentDs;

        public OverlapPredicate(DataSet currentDs) {
            this.currentDs = currentDs;
        }

        @Override
        public boolean test(AttributePath attributePath) {
            OverlapIterator iterator = OverlapIterator.from(attributePath);
            OverlapItem original = null;
            while (iterator.hasNext()) {
                original = (OverlapItem)iterator.next();
            }
            assert (original != null);
            return original.isReachable() && this.currentDs.equals(original.asReachable().getTargetDs());
        }
    }
}

