/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import com.google.common.base.Strings;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.dataset.db.FilterRepository;
import org.qubership.atp.dataset.model.Filter;
import org.qubership.atp.dataset.service.direct.FilterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FilterServiceImpl
implements FilterService {
    private FilterRepository filterRepository;

    @Autowired
    public void setFilterRepository(FilterRepository filterRepository) {
        this.filterRepository = filterRepository;
    }

    @Override
    @Transactional
    public Filter create(@Nonnull String name, @Nonnull UUID vaId, @Nonnull List<UUID> dsLabels, @Nonnull List<UUID> dslLabels) {
        if (dsLabels.isEmpty() && dslLabels.isEmpty()) {
            throw new IllegalArgumentException("Filter can't be created with empty references to ds/dsl labels");
        }
        return this.filterRepository.create(name, vaId, dsLabels, dslLabels);
    }

    @Override
    @Transactional
    public void delete(UUID filterId) {
        this.filterRepository.delete(filterId);
    }

    @Override
    public void update(UUID filterId, String name, List<UUID> dsLabels, List<UUID> dslLabels) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Filter name can't be null or empty!");
        }
        this.filterRepository.update(filterId, name, dsLabels, dslLabels);
    }

    @Override
    @Nullable
    public Filter get(@Nonnull UUID filterId) {
        return this.filterRepository.get(filterId);
    }

    @Override
    public boolean existsById(@NotNull UUID id) {
        return this.filterRepository.existsById(id);
    }

    @Override
    @Nonnull
    @Deprecated
    public List<Filter> getAll() {
        throw new UnsupportedOperationException("Use method getAll(DSL_ID)");
    }

    @Override
    public List<Filter> getAll(UUID vaId) {
        return this.filterRepository.getAll(vaId);
    }
}

