/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AbstractAttributeConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.models.ParameterImportResponse;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ListAttributeImportConverter
extends AbstractAttributeConverter
implements AttributeImportConverter {
    private static final Logger log = LoggerFactory.getLogger(ListAttributeImportConverter.class);
    private final ParameterService parameterService;
    private final JpaAttributeService attributeService;

    @Override
    public ParameterImportResponse importAttributeParameter(AttributeImportModel importModel, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext) throws Exception {
        log.debug("Import list attribute parameter, import model: '{}', dataset param value: '{}',  context: '{}'", new Object[]{importModel, datasetParameterValue, importContext});
        String attributeName = importModel.getName();
        UUID attributeId = importModel.getId();
        String datasetName = datasetParameterValue.getDatasetName();
        UUID datasetId = datasetParameterValue.getDatasetId();
        String parameterValue = datasetParameterValue.getTextValue();
        String keyAttributeValue = importModel.getKey();
        boolean isDataChanges = false;
        boolean hasNotParent = Objects.isNull(importModel.getParent());
        boolean isJavers = importContext.isJavers();
        boolean attributeShouldOverlap = this.isAttributeShouldOverlap(importModel, datasetParameterValue, importContext, parameter -> !parameterValue.equals(parameter.getListValue().getName()) && (Strings.isNotBlank((String)parameterValue) || hasNotParent));
        List<UUID> attributePath = !attributeShouldOverlap ? Collections.emptyList() : importModel.getPath();
        String paramValueTarget = this.getParamValueTarget(attributeShouldOverlap, datasetParameterValue, importContext, attributeId, datasetId, importModel, this.parameterService);
        if (StringUtils.isNotEmpty((String)parameterValue) && !Objects.equals(parameterValue, paramValueTarget)) {
            ListValue listValue = this.attributeService.getListValueByAttributeIdAndValue(attributeId, parameterValue);
            UUID listValueId = listValue.getId();
            log.info("Import parameter for list attribute Key '{}' Id '{}' in dataset name '{}' with value '{}', path '{}' and list value id '{}'", new Object[]{keyAttributeValue, attributeId, datasetName, parameterValue, attributePath, listValueId});
            Parameter parameter2 = this.parameterService.setParamSelectJavers(datasetId, attributeId, attributePath, null, null, listValueId, isJavers);
            isDataChanges = true;
            log.debug("Parameter with has been successfully imported: {}", (Object)parameter2);
        } else if (StringUtils.isNotEmpty((String)paramValueTarget) && StringUtils.isEmpty((String)parameterValue) && hasNotParent) {
            DataSet dataset = importContext.getDataset(datasetId);
            UUID datasetListId = dataset.getDataSetList().getId();
            log.info("Delete parameter for list attribute Key '{}' Attribute name '{}' Id '{}' with value '{}', path '{}'", new Object[]{keyAttributeValue, attributeName, attributeId, parameterValue, attributePath});
            this.parameterService.deleteParamSelectJavers(attributeId, datasetId, datasetListId, attributePath, isJavers);
            isDataChanges = true;
        }
        return new ParameterImportResponse(isDataChanges ? datasetId : null);
    }

    @Override
    public AttributeImportModel mapRowToImportModel(Map<Integer, String> row, AttributeImportContext importContext, ListIterator<Map<Integer, String>> rowsIterator) {
        log.debug("Map excel row to list attribute import model");
        return this.mapTextRowToImportModel(row, importContext);
    }

    @Override
    public List<ParameterImportResponse> validate(AttributeImportModel model, AttributeImportContext context) {
        log.debug("Validate list attribute import model. Import model: '{}', context: '{}'", (Object)model, (Object)context);
        UUID attributeId = model.getId();
        List<ListValue> existedListValues = this.attributeService.getListValuesByAttributeId(attributeId);
        log.debug("Existed list attribute values in schema: {}", existedListValues);
        AtomicReference listValueKeyTemp = new AtomicReference();
        Map existedListValuesMap = existedListValues.stream().collect(Collectors.toMap(listValueListValue -> {
            String keyValue = listValueListValue.getText();
            listValueKeyTemp.set(keyValue);
            return keyValue;
        }, Function.identity(), (firstListValueFound, anyNextListValue) -> {
            log.warn("List value validate is duplicate map key: '{}', keyPathAttribute '{}',  dslRef '{}'", new Object[]{listValueKeyTemp.get(), model.getKey(), model.getDatasetListReference()});
            return anyNextListValue;
        }));
        ArrayList<ParameterImportResponse> errors = new ArrayList<ParameterImportResponse>();
        List<DatasetParameterValue> datasetParameterValues = model.getDatasetParameterValues();
        Iterator<DatasetParameterValue> iterator = datasetParameterValues.iterator();
        while (iterator.hasNext()) {
            boolean notExistedListValue;
            DatasetParameterValue datasetParameterValue = iterator.next();
            String listAttributeTextValue = datasetParameterValue.getTextValue();
            log.debug("Validate dataset param with list value: {}", (Object)listAttributeTextValue);
            boolean bl = notExistedListValue = !existedListValuesMap.containsKey(listAttributeTextValue);
            if (listAttributeTextValue.isEmpty() || !notExistedListValue) continue;
            UUID datasetId = datasetParameterValue.getDatasetId();
            String errMsg = "Imported list value attribute parameter has invalid value: " + listAttributeTextValue;
            log.warn(errMsg);
            errors.add(new ParameterImportResponse(datasetId, errMsg));
            iterator.remove();
        }
        return errors;
    }

    public ListAttributeImportConverter(ParameterService parameterService, JpaAttributeService attributeService) {
        this.parameterService = parameterService;
        this.attributeService = attributeService;
    }
}

