/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.importexport.utils.ImportUtils;
import org.qubership.atp.dataset.service.direct.importexport.utils.StreamUtils;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AttributeImportContext {
    private static final Logger log = LoggerFactory.getLogger(AttributeImportContext.class);
    private boolean isJavers;
    private UUID targetDslId;
    private Map<UUID, DataSet> datasetsMap = new HashMap<UUID, DataSet>();
    private Map<String, UUID> datasetsNameIdMap = new HashMap<String, UUID>();
    private Map<String, DataSet> refDatasetsMap = new HashMap<String, DataSet>();
    private Map<String, UUID> refDatasetsNameIdMap = new HashMap<String, UUID>();
    private Map<String, Integer> datasetsCellIndexMap = new LinkedHashMap<String, Integer>();
    private Map<String, Set<UUID>> refDslDatasetIdsMap = new HashMap<String, Set<UUID>>();
    private Map<UUID, Attribute> attributesIdMap = new HashMap<UUID, Attribute>();
    private Map<String, Attribute> attributesNameMap = new HashMap<String, Attribute>();
    private Map<String, Parameter> attributeParametersMap = new HashMap<String, Parameter>();
    private Map<String, String> targetDslOverlaps = new HashMap<String, String>();

    public void setOverlaps(Collection<AttributeKey> overlaps) {
        if (!CollectionUtils.isEmpty(overlaps)) {
            try {
                AtomicReference attributeKeyTemp = new AtomicReference();
                this.targetDslOverlaps = overlaps.stream().collect(Collectors.toMap(attributeKey -> ImportUtils.getOverlapKey(attributeKey, this), attributeKey -> this.getValueOverlaps(attributeKeyTemp, (AttributeKey)attributeKey), (firstValueFound, anyNextValue) -> {
                    log.warn("Overlaps prepare is duplicate map key: '{}', for values in map '{}' and other '{}'", new Object[]{ImportUtils.getOverlapKey((AttributeKey)attributeKeyTemp.get(), this), firstValueFound, anyNextValue});
                    return firstValueFound;
                }));
            }
            catch (RuntimeException e) {
                log.warn("Error set Overlaps message: '{}', Cause: '{}'", (Object)e.getMessage(), (Object)e.getCause());
            }
        }
    }

    private String getValueOverlaps(AtomicReference<AttributeKey> attributeKeyTemp, AttributeKey attributeKey) {
        attributeKeyTemp.set(attributeKey);
        String valueTextParameter = "";
        org.qubership.atp.dataset.service.jpa.delegates.Parameter parameter = attributeKey.getParameter();
        if (Objects.nonNull(parameter)) {
            String textValue = parameter.getStringValue();
            if (Strings.isNotBlank((String)textValue)) {
                return textValue;
            }
            DataSet dataset = parameter.getDataSetReferenceValue();
            if (Objects.nonNull(dataset) && Strings.isNotBlank((String)dataset.getName())) {
                return dataset.getName();
            }
            ListValueEntity listValueEnt = parameter.getListValue();
            if (Objects.nonNull(listValueEnt) && Strings.isNotBlank((String)listValueEnt.getText())) {
                return listValueEnt.getText();
            }
        }
        return valueTextParameter;
    }

    public void setDatasets(Collection<DataSet> datasets) {
        if (!CollectionUtils.isEmpty(datasets)) {
            this.datasetsNameIdMap = StreamUtils.toNameIdEntityMap(datasets, DataSet::getName, DataSet::getId);
            this.datasetsMap = StreamUtils.toEntityMap(datasets, DataSet::getId);
        }
    }

    public void setDataset(DataSet dataset) {
        this.datasetsNameIdMap.put(dataset.getName(), dataset.getId());
        this.datasetsMap.put(dataset.getId(), dataset);
    }

    public void setRefDatasets(Collection<DataSet> refDatasets) {
        if (!CollectionUtils.isEmpty(refDatasets)) {
            this.refDatasetsNameIdMap = StreamUtils.toNameIdEntityMap(refDatasets, ImportUtils::getDatasetKey, DataSet::getId);
            this.refDatasetsMap = StreamUtils.toEntityMap(refDatasets, ImportUtils::getDatasetKeyPathName);
        }
    }

    public void setAttributes(String prefix, Collection<Attribute> attributes) {
        if (!CollectionUtils.isEmpty(attributes)) {
            this.attributesNameMap.putAll(StreamUtils.toNameEntityMap(attributes, attribute -> prefix + " -> " + attribute.getName()));
            this.attributesIdMap.putAll(StreamUtils.toEntityMap(attributes, Attribute::getId));
        }
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (!CollectionUtils.isEmpty(attributes)) {
            this.attributesNameMap.putAll(StreamUtils.toNameEntityMap(attributes, Attribute::getName));
            this.attributesIdMap.putAll(StreamUtils.toEntityMap(attributes, Attribute::getId));
        }
    }

    public void setAttributeParameters(Collection<Parameter> parameters) {
        if (!CollectionUtils.isEmpty(parameters)) {
            this.attributeParametersMap = StreamUtils.toEntityMap(parameters, ImportUtils::getDsParameterKey);
        }
    }

    public Parameter getRefParameter(String datasetParameterKey) {
        return this.attributeParametersMap.get(datasetParameterKey);
    }

    public void clearParametersContext() {
        this.attributeParametersMap.clear();
    }

    public DataSet getDataset(UUID datasetId) {
        return this.datasetsMap.get(datasetId);
    }

    public UUID getDatasetId(String datasetName) {
        return this.datasetsNameIdMap.get(datasetName);
    }

    public boolean containsRefDataset(String datasetName) {
        return this.refDatasetsMap.containsKey(datasetName);
    }

    public UUID getRefDatasetId(String datasetKey) {
        return this.refDatasetsNameIdMap.get(datasetKey);
    }

    public UUID getAttributeId(String attributeKey) {
        return this.attributesNameMap.get(attributeKey).getId();
    }

    public Attribute getAttribute(String attributeKey) {
        return this.attributesNameMap.get(attributeKey);
    }

    public Attribute getAttribute(UUID id) {
        return this.attributesIdMap.get(id);
    }

    public String getAttributeDslRef(String attributeKey) {
        Attribute parentAttribute = this.getAttribute(attributeKey);
        DataSetList parentDatasetListRef = parentAttribute.getTypeDataSetList();
        return parentDatasetListRef.getName();
    }

    public boolean isOverlapExist(String overlapKey) {
        return this.targetDslOverlaps.containsKey(overlapKey);
    }

    public boolean isJavers() {
        return this.isJavers;
    }

    public UUID getTargetDslId() {
        return this.targetDslId;
    }

    public Map<UUID, DataSet> getDatasetsMap() {
        return this.datasetsMap;
    }

    public Map<String, UUID> getDatasetsNameIdMap() {
        return this.datasetsNameIdMap;
    }

    public Map<String, DataSet> getRefDatasetsMap() {
        return this.refDatasetsMap;
    }

    public Map<String, UUID> getRefDatasetsNameIdMap() {
        return this.refDatasetsNameIdMap;
    }

    public Map<String, Integer> getDatasetsCellIndexMap() {
        return this.datasetsCellIndexMap;
    }

    public Map<String, Set<UUID>> getRefDslDatasetIdsMap() {
        return this.refDslDatasetIdsMap;
    }

    public Map<UUID, Attribute> getAttributesIdMap() {
        return this.attributesIdMap;
    }

    public Map<String, Attribute> getAttributesNameMap() {
        return this.attributesNameMap;
    }

    public Map<String, Parameter> getAttributeParametersMap() {
        return this.attributeParametersMap;
    }

    public Map<String, String> getTargetDslOverlaps() {
        return this.targetDslOverlaps;
    }

    public void setJavers(boolean isJavers) {
        this.isJavers = isJavers;
    }

    public void setTargetDslId(UUID targetDslId) {
        this.targetDslId = targetDslId;
    }

    public void setDatasetsMap(Map<UUID, DataSet> datasetsMap) {
        this.datasetsMap = datasetsMap;
    }

    public void setDatasetsNameIdMap(Map<String, UUID> datasetsNameIdMap) {
        this.datasetsNameIdMap = datasetsNameIdMap;
    }

    public void setRefDatasetsMap(Map<String, DataSet> refDatasetsMap) {
        this.refDatasetsMap = refDatasetsMap;
    }

    public void setRefDatasetsNameIdMap(Map<String, UUID> refDatasetsNameIdMap) {
        this.refDatasetsNameIdMap = refDatasetsNameIdMap;
    }

    public void setDatasetsCellIndexMap(Map<String, Integer> datasetsCellIndexMap) {
        this.datasetsCellIndexMap = datasetsCellIndexMap;
    }

    public void setRefDslDatasetIdsMap(Map<String, Set<UUID>> refDslDatasetIdsMap) {
        this.refDslDatasetIdsMap = refDslDatasetIdsMap;
    }

    public void setAttributesIdMap(Map<UUID, Attribute> attributesIdMap) {
        this.attributesIdMap = attributesIdMap;
    }

    public void setAttributesNameMap(Map<String, Attribute> attributesNameMap) {
        this.attributesNameMap = attributesNameMap;
    }

    public void setAttributeParametersMap(Map<String, Parameter> attributeParametersMap) {
        this.attributeParametersMap = attributeParametersMap;
    }

    public void setTargetDslOverlaps(Map<String, String> targetDslOverlaps) {
        this.targetDslOverlaps = targetDslOverlaps;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeImportContext)) {
            return false;
        }
        AttributeImportContext other = (AttributeImportContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isJavers() != other.isJavers()) {
            return false;
        }
        UUID this$targetDslId = this.getTargetDslId();
        UUID other$targetDslId = other.getTargetDslId();
        if (this$targetDslId == null ? other$targetDslId != null : !((Object)this$targetDslId).equals(other$targetDslId)) {
            return false;
        }
        Map<UUID, DataSet> this$datasetsMap = this.getDatasetsMap();
        Map<UUID, DataSet> other$datasetsMap = other.getDatasetsMap();
        if (this$datasetsMap == null ? other$datasetsMap != null : !((Object)this$datasetsMap).equals(other$datasetsMap)) {
            return false;
        }
        Map<String, UUID> this$datasetsNameIdMap = this.getDatasetsNameIdMap();
        Map<String, UUID> other$datasetsNameIdMap = other.getDatasetsNameIdMap();
        if (this$datasetsNameIdMap == null ? other$datasetsNameIdMap != null : !((Object)this$datasetsNameIdMap).equals(other$datasetsNameIdMap)) {
            return false;
        }
        Map<String, DataSet> this$refDatasetsMap = this.getRefDatasetsMap();
        Map<String, DataSet> other$refDatasetsMap = other.getRefDatasetsMap();
        if (this$refDatasetsMap == null ? other$refDatasetsMap != null : !((Object)this$refDatasetsMap).equals(other$refDatasetsMap)) {
            return false;
        }
        Map<String, UUID> this$refDatasetsNameIdMap = this.getRefDatasetsNameIdMap();
        Map<String, UUID> other$refDatasetsNameIdMap = other.getRefDatasetsNameIdMap();
        if (this$refDatasetsNameIdMap == null ? other$refDatasetsNameIdMap != null : !((Object)this$refDatasetsNameIdMap).equals(other$refDatasetsNameIdMap)) {
            return false;
        }
        Map<String, Integer> this$datasetsCellIndexMap = this.getDatasetsCellIndexMap();
        Map<String, Integer> other$datasetsCellIndexMap = other.getDatasetsCellIndexMap();
        if (this$datasetsCellIndexMap == null ? other$datasetsCellIndexMap != null : !((Object)this$datasetsCellIndexMap).equals(other$datasetsCellIndexMap)) {
            return false;
        }
        Map<String, Set<UUID>> this$refDslDatasetIdsMap = this.getRefDslDatasetIdsMap();
        Map<String, Set<UUID>> other$refDslDatasetIdsMap = other.getRefDslDatasetIdsMap();
        if (this$refDslDatasetIdsMap == null ? other$refDslDatasetIdsMap != null : !((Object)this$refDslDatasetIdsMap).equals(other$refDslDatasetIdsMap)) {
            return false;
        }
        Map<UUID, Attribute> this$attributesIdMap = this.getAttributesIdMap();
        Map<UUID, Attribute> other$attributesIdMap = other.getAttributesIdMap();
        if (this$attributesIdMap == null ? other$attributesIdMap != null : !((Object)this$attributesIdMap).equals(other$attributesIdMap)) {
            return false;
        }
        Map<String, Attribute> this$attributesNameMap = this.getAttributesNameMap();
        Map<String, Attribute> other$attributesNameMap = other.getAttributesNameMap();
        if (this$attributesNameMap == null ? other$attributesNameMap != null : !((Object)this$attributesNameMap).equals(other$attributesNameMap)) {
            return false;
        }
        Map<String, Parameter> this$attributeParametersMap = this.getAttributeParametersMap();
        Map<String, Parameter> other$attributeParametersMap = other.getAttributeParametersMap();
        if (this$attributeParametersMap == null ? other$attributeParametersMap != null : !((Object)this$attributeParametersMap).equals(other$attributeParametersMap)) {
            return false;
        }
        Map<String, String> this$targetDslOverlaps = this.getTargetDslOverlaps();
        Map<String, String> other$targetDslOverlaps = other.getTargetDslOverlaps();
        return !(this$targetDslOverlaps == null ? other$targetDslOverlaps != null : !((Object)this$targetDslOverlaps).equals(other$targetDslOverlaps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeImportContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isJavers() ? 79 : 97);
        UUID $targetDslId = this.getTargetDslId();
        result = result * 59 + ($targetDslId == null ? 43 : ((Object)$targetDslId).hashCode());
        Map<UUID, DataSet> $datasetsMap = this.getDatasetsMap();
        result = result * 59 + ($datasetsMap == null ? 43 : ((Object)$datasetsMap).hashCode());
        Map<String, UUID> $datasetsNameIdMap = this.getDatasetsNameIdMap();
        result = result * 59 + ($datasetsNameIdMap == null ? 43 : ((Object)$datasetsNameIdMap).hashCode());
        Map<String, DataSet> $refDatasetsMap = this.getRefDatasetsMap();
        result = result * 59 + ($refDatasetsMap == null ? 43 : ((Object)$refDatasetsMap).hashCode());
        Map<String, UUID> $refDatasetsNameIdMap = this.getRefDatasetsNameIdMap();
        result = result * 59 + ($refDatasetsNameIdMap == null ? 43 : ((Object)$refDatasetsNameIdMap).hashCode());
        Map<String, Integer> $datasetsCellIndexMap = this.getDatasetsCellIndexMap();
        result = result * 59 + ($datasetsCellIndexMap == null ? 43 : ((Object)$datasetsCellIndexMap).hashCode());
        Map<String, Set<UUID>> $refDslDatasetIdsMap = this.getRefDslDatasetIdsMap();
        result = result * 59 + ($refDslDatasetIdsMap == null ? 43 : ((Object)$refDslDatasetIdsMap).hashCode());
        Map<UUID, Attribute> $attributesIdMap = this.getAttributesIdMap();
        result = result * 59 + ($attributesIdMap == null ? 43 : ((Object)$attributesIdMap).hashCode());
        Map<String, Attribute> $attributesNameMap = this.getAttributesNameMap();
        result = result * 59 + ($attributesNameMap == null ? 43 : ((Object)$attributesNameMap).hashCode());
        Map<String, Parameter> $attributeParametersMap = this.getAttributeParametersMap();
        result = result * 59 + ($attributeParametersMap == null ? 43 : ((Object)$attributeParametersMap).hashCode());
        Map<String, String> $targetDslOverlaps = this.getTargetDslOverlaps();
        result = result * 59 + ($targetDslOverlaps == null ? 43 : ((Object)$targetDslOverlaps).hashCode());
        return result;
    }

    public String toString() {
        return "AttributeImportContext(isJavers=" + this.isJavers() + ", targetDslId=" + this.getTargetDslId() + ", datasetsMap=" + this.getDatasetsMap() + ", datasetsNameIdMap=" + this.getDatasetsNameIdMap() + ", refDatasetsMap=" + this.getRefDatasetsMap() + ", refDatasetsNameIdMap=" + this.getRefDatasetsNameIdMap() + ", datasetsCellIndexMap=" + this.getDatasetsCellIndexMap() + ", refDslDatasetIdsMap=" + this.getRefDslDatasetIdsMap() + ", attributesIdMap=" + this.getAttributesIdMap() + ", attributesNameMap=" + this.getAttributesNameMap() + ", attributeParametersMap=" + this.getAttributeParametersMap() + ", targetDslOverlaps=" + this.getTargetDslOverlaps() + ")";
    }
}

