/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attribute
extends AbstractObjectWrapper<AttributeEntity> {
    private static final long serialVersionUID = -55774378413986230L;
    private static final Logger LOG = LoggerFactory.getLogger(Attribute.class);

    public Attribute(AttributeEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((AttributeEntity)this.entity).getId();
    }

    public DataSetList getDataSetList() {
        return modelsProvider.getDataSetList(((AttributeEntity)this.entity).getDataSetList());
    }

    public String getName() {
        return ((AttributeEntity)this.entity).getName();
    }

    public Integer getOrdering() {
        return ((AttributeEntity)this.entity).getOrdering();
    }

    public AttributeTypeName getAttributeType() {
        return AttributeTypeName.getTypeById(((AttributeEntity)this.entity).getAttributeTypeId());
    }

    public DataSetList getTypeDataSetList() {
        DataSetListEntity dataSetListEntity = (DataSetListEntity)entityManager.find(DataSetListEntity.class, (Object)((AttributeEntity)this.entity).getTypeDataSetListId());
        return modelsProvider.getDataSetList(dataSetListEntity);
    }

    public UUID getTypeDataSetListId() {
        return ((AttributeEntity)this.entity).getTypeDataSetListId();
    }

    public void setTypeDataSetListId(UUID dataSetListId) {
        ((AttributeEntity)this.entity).setTypeDataSetListId(dataSetListId);
        this.save(this.entity);
    }

    public List<ListValue> getListValues() {
        LinkedList<ListValue> result = new LinkedList<ListValue>();
        ((AttributeEntity)this.entity).getListValues().forEach(listValue -> result.add(modelsProvider.getListValue((AbstractUuidBasedEntity)listValue)));
        return result;
    }

    public List<Parameter> getParameters() {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        ((AttributeEntity)this.entity).getParameters().forEach(parameterEntity -> parameters.add(modelsProvider.getParameter((AbstractUuidBasedEntity)parameterEntity)));
        return parameters;
    }

    @Override
    public void beforeRemove() {
        List<ListValue> listValues = this.getListValues();
        for (ListValue listValue : listValues) {
            listValue.remove();
        }
        List<Parameter> parameters = this.getParameters();
        for (Parameter parameter : parameters) {
            parameter.remove();
        }
        List<AttributeKey> list = this.getOverlaps();
        for (AttributeKey overlap : list) {
            overlap.remove();
        }
    }

    public List<AttributeKey> getOverlaps() {
        LinkedList<AttributeKey> result = new LinkedList<AttributeKey>();
        String nativeQuery = "select * from attribute_key where attribute_id = :attr_id";
        List keys = entityManager.createNativeQuery(nativeQuery, AttributeKeyEntity.class).setParameter("attr_id", (Object)this.getId()).getResultList();
        for (AttributeKeyEntity key : keys) {
            result.add(new AttributeKey(key));
        }
        return result;
    }

    public ListValue createListValue(String text) {
        ListValueEntity listValueEntity = new ListValueEntity();
        listValueEntity.setAttribute((AttributeEntity)this.entity);
        listValueEntity.setText(text);
        this.save(listValueEntity);
        ((AttributeEntity)this.entity).getListValues().add(listValueEntity);
        return modelsProvider.getListValue(listValueEntity);
    }

    public ListValue insertListValue(UUID id, String text) {
        ListValueEntity listValueEntity = new ListValueEntity();
        listValueEntity.setAttribute((AttributeEntity)this.entity);
        listValueEntity.setText(text);
        this.insert(listValueEntity, id);
        ((AttributeEntity)this.entity).getListValues().add(listValueEntity);
        return modelsProvider.getListValue(listValueEntity);
    }

    public void setName(String name) {
        ((AttributeEntity)this.entity).setName(name);
    }

    public void setAttributeType(AttributeTypeName type) {
        ((AttributeEntity)this.entity).setAttributeTypeId(type.getId());
    }

    public void setDataSetList(UUID dataSetListId) {
        DataSetList dataSetList = modelsProvider.getDataSetListById(dataSetListId);
        ((AttributeEntity)this.entity).setDataSetList((DataSetListEntity)dataSetList.getEntity());
    }

    public Map<UUID, UUID> copyListValuesTo(Attribute attributeCopy) {
        LinkedHashMap<UUID, UUID> result = new LinkedHashMap<UUID, UUID>();
        List<ListValue> listValues = this.getListValues();
        for (ListValue listValue : listValues) {
            ListValueEntity copiedListValue = new ListValueEntity();
            copiedListValue.setText(listValue.getText());
            copiedListValue.setAttribute((AttributeEntity)attributeCopy.getEntity());
            ((AttributeEntity)attributeCopy.getEntity()).getListValues().add(copiedListValue);
            this.save(copiedListValue);
            result.put(listValue.getId(), copiedListValue.getId());
        }
        return result;
    }

    public void setOrdering(Integer ordering) {
        ((AttributeEntity)this.entity).setOrdering(ordering);
    }
}

