/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.ws.event;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.service.ws.entities.Pair;
import org.qubership.atp.dataset.service.ws.event.Event;
import org.qubership.atp.dataset.service.ws.event.EventExecutor;
import org.qubership.atp.dataset.service.ws.event.EventHandler;
import org.qubership.atp.dataset.service.ws.event.EventType;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class EventExecutorImpl
implements EventExecutor {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final EventHandler handler = new EventHandler();
    private static final EventExecutor instance = new EventExecutorImpl();

    public static EventExecutor getInstance() {
        return instance;
    }

    @Override
    public void execute(@Nullable WebSocketSession socket, @Nonnull Event event) {
        EventType eventType = event.getEventType();
        if (EventType.UNSELECT == eventType || EventType.CLOSE == eventType) {
            Pair<String, String> dsPath = handler.getDsPath(socket);
            event.setSessionId(dsPath.getSecond());
            event.setDataSetListId(dsPath.getFirst());
            handler.remove(event);
        }
        if (EventType.SELECT == eventType || EventType.GET_ALL == eventType) {
            handler.remove(event);
            handler.add(event, socket);
        }
        if (EventType.GET_USERS == eventType) {
            String hostsList = this.serialize(handler.getHosts(event.getSessionId(), event.getDataSetListId()));
            if (socket != null) {
                event.setValue(hostsList);
                this.sendEvent(event, socket);
            }
            return;
        }
        if (EventType.CONNECT == eventType && socket != null) {
            event.setValue(socket.getLocalAddress().getHostName());
        }
        this.broadCastEvent(socket, event);
    }

    private void broadCastEvent(WebSocketSession sourceSocket, @Nonnull Event event) {
        Collection<WebSocketSession> sockets = handler.getWebSockets(event);
        Stream<WebSocketSession> webSocketStream = sockets.stream().filter(webSocket -> webSocket != sourceSocket && webSocket.isOpen());
        List<WebSocketSession> collect = webSocketStream.collect(Collectors.toList());
        collect.forEach(socket -> this.sendEvent(event, (WebSocketSession)socket));
    }

    private void sendEvent(@Nonnull Event event, WebSocketSession socket) {
        if (socket.isOpen()) {
            try {
                socket.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.serialize(event)));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(EventExecutorImpl.class).error("Failed to send event", (Throwable)e);
            }
        }
    }

    private String serialize(@Nonnull Object event) {
        try {
            return OBJECT_MAPPER.writeValueAsString(event);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(EventExecutorImpl.class).error("Failed serialization object", (Throwable)e);
            return "";
        }
    }
}

