/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.qubership.atp.dataset.constants.CacheEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
public class CacheConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CacheConfiguration.class);
    public static final String CACHE_CLIENT_NAME = "ATP_DATASETS_";
    public static final String CACHE_SERVER_NAME = "ATP-DATASETS-SERVER";
    public static final UUID CACHE_ID = UUID.randomUUID();
    @Value(value="${spring.cache.hazelcast.cluster-name}")
    private String cacheClusterName;
    @Value(value="${spring.cache.hazelcast.server.address}")
    private String hazelcastServerAddress;
    @Value(value="${spring.cache.hazelcast.server.enable}")
    private boolean hazelcastServerEnable;
    @Value(value="${spring.cache.hazelcast.server.port:5701}")
    private int hazelcastServerPort;
    @Value(value="${server.port}")
    private String serverPort;

    @Bean
    @ConditionalOnProperty(name={"spring.cache.hazelcast.client.enable"}, havingValue="true")
    public CacheManager hazelcastCacheManager() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setInstanceName("ATP_DATASETS_on_port_" + this.serverPort + "_with_id_" + CACHE_ID);
        clientConfig.setClusterName(this.cacheClusterName);
        clientConfig.getNetworkConfig().addAddress(new String[]{this.hazelcastServerAddress + ":" + this.hazelcastServerPort});
        clientConfig.getConnectionStrategyConfig().setReconnectMode(ClientConnectionStrategyConfig.ReconnectMode.ASYNC);
        if (this.hazelcastServerEnable) {
            this.startCacheServer();
        }
        log.debug("Connect to HAZELCAST as client");
        HazelcastInstance hzInstanceClient = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        for (CacheEnum key : CacheEnum.values()) {
            String name = key.getKey();
            try {
                log.debug("Try to create config for map {}", (Object)name);
                hzInstanceClient.getConfig().addMapConfig(new MapConfig(name).setTimeToLiveSeconds(key.getTimeToLiveSec()));
            }
            catch (Exception failedCreate) {
                log.warn("Adding of Map {} or changing its config is failed (may be, it already exists): ", (Object)name, (Object)failedCreate);
            }
        }
        return new HazelcastCacheManager(hzInstanceClient);
    }

    private void startCacheServer() {
        log.info("Get or start cache config on address {}:{}", (Object)this.hazelcastServerAddress, (Object)this.hazelcastServerPort);
        Config config = new Config(CACHE_SERVER_NAME);
        NetworkConfig network = config.getNetworkConfig().setPort(this.hazelcastServerPort).setPortCount(1).setPortAutoIncrement(false).setReuseAddress(true);
        network.getJoin().getMulticastConfig().setEnabled(true);
        for (CacheEnum key : CacheEnum.values()) {
            config.addMapConfig(new MapConfig(key.getKey()).setTimeToLiveSeconds(key.getTimeToLiveSec()));
        }
        config.setClusterName(this.cacheClusterName);
        try {
            Hazelcast.getOrCreateHazelcastInstance((Config)config);
        }
        catch (Exception e) {
            log.warn("HazelCast server already started: {}", (Object)e.getMessage());
        }
    }

    @Bean
    @ConditionalOnProperty(name={"spring.cache.hazelcast.client.enable"}, havingValue="false")
    public CacheManager caffeineCacheManager() {
        log.info("Create CAFFEINE cache manager");
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        ArrayList<CaffeineCache> caches = new ArrayList<CaffeineCache>();
        for (CacheEnum key : CacheEnum.values()) {
            caches.add(new CaffeineCache(key.getKey(), Caffeine.newBuilder().expireAfterWrite((long)key.getTimeToLiveSec(), TimeUnit.SECONDS).recordStats().maximumSize(100L).build(), true));
        }
        cacheManager.setCaches(caches);
        return cacheManager;
    }
}

