/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GridFsRepositoryImpl
implements GridFsRepository {
    private static final Logger log = LoggerFactory.getLogger(GridFsRepositoryImpl.class);
    private final GridFSBucket gridFsBucket;
    private ThreadLocal<Map<UUID, Optional<FileData>>> cachedFileInfo = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

    @Autowired
    public GridFsRepositoryImpl(GridFSBucket gridFsBucket) {
        this.gridFsBucket = gridFsBucket;
    }

    @Override
    public void remove(UUID attachmentUuid) {
        Optional<GridFSFile> res = this.getGridFsFile(attachmentUuid);
        if (res.isPresent()) {
            this.gridFsBucket.delete(res.get().getObjectId());
            this.cachedFileInfo.get().remove(attachmentUuid);
        } else {
            log.error("Can not found gridFs file with id: {}", (Object)attachmentUuid);
        }
    }

    @Override
    public Optional<GridFSFile> getGridFsFile(UUID attachmentUuid) {
        Document filter = new Document().append("metadata.attachmentUuid", (Object)attachmentUuid);
        GridFSFile file = (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
        if (file != null) {
            return Optional.of(file);
        }
        return Optional.empty();
    }

    @Override
    public void save(FileData fileData, InputStream fileInputStream) {
        this.remove(fileData.getParameterUuid());
        GridFSUploadOptions uploadOptions = this.buildOptions(fileData);
        this.gridFsBucket.uploadFromStream(fileData.getParameterUuid().toString(), fileInputStream, uploadOptions);
        this.cachedFileInfo.get().put(fileData.getParameterUuid(), Optional.of(fileData));
    }

    private GridFSUploadOptions buildOptions(FileData fileData) {
        return new GridFSUploadOptions().chunkSizeBytes(Integer.valueOf(1024)).metadata(new Document("type", (Object)fileData.getFileType()).append("uploadDate", (Object)LocalDateTime.now().toString()).append("attachmentUuid", (Object)fileData.getParameterUuid()).append("contentType", (Object)fileData.getContentType()).append("fileName", (Object)fileData.getFileName()).append("url", (Object)fileData.getUrl()));
    }

    @Override
    public Optional<InputStream> get(UUID parameterUuid) {
        GridFSFile attachment = (GridFSFile)this.gridFsBucket.find((Bson)this.filter(parameterUuid)).first();
        if (attachment == null) {
            return Optional.empty();
        }
        return Optional.of(this.gridFsBucket.openDownloadStream(attachment.getId()));
    }

    @Override
    public Map<UUID, Optional<InputStream>> getAll(List<UUID> parametersUuids) {
        ArrayList files = new ArrayList();
        this.gridFsBucket.find(Filters.in((String)"metadata.attachmentUuid", parametersUuids)).into(files);
        HashMap<UUID, Optional<InputStream>> fileToUuid = new HashMap<UUID, Optional<InputStream>>();
        files.forEach(file -> {
            UUID id = (UUID)Objects.requireNonNull(file.getMetadata()).get((Object)"attachmentUuid");
            fileToUuid.put(id, Optional.of(this.gridFsBucket.openDownloadStream(file.getId())));
        });
        return fileToUuid;
    }

    @Override
    public Optional<FileData> getFileInfo(UUID parameterUuid) {
        Optional fileInfo = this.cachedFileInfo.get().computeIfAbsent(parameterUuid, id -> this.findFileInfoInStore((UUID)id));
        return fileInfo;
    }

    private Optional<FileData> findFileInfoInStore(UUID parameterUuid) {
        GridFSFile attachment = (GridFSFile)this.gridFsBucket.find((Bson)this.filter(parameterUuid)).first();
        if (attachment == null) {
            return Optional.empty();
        }
        Document metadata = attachment.getMetadata();
        if (Objects.isNull(metadata)) {
            return Optional.empty();
        }
        return Optional.of(this.getMetaDataInfo(metadata));
    }

    private FileData getMetaDataInfo(Document metadata) {
        String contentType = metadata.getString((Object)"contentType");
        String fileName = metadata.getString((Object)"fileName");
        UUID parameterUuid = (UUID)metadata.get((Object)"attachmentUuid", UUID.class);
        return new FileData(fileName, parameterUuid, contentType);
    }

    private Document filter(UUID attachmentUuid) {
        return new Document().append("metadata.attachmentUuid", (Object)attachmentUuid);
    }

    @Override
    public void onDeleteCascade(List<UUID> parameters) {
        parameters.forEach(this::remove);
    }

    @Override
    public void dropLocalThreadCache() {
        this.cachedFileInfo.remove();
    }
}

