/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.db.AttributePathRepository;
import org.qubership.atp.dataset.db.AttributeRepository;
import org.qubership.atp.dataset.db.CacheRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.db.GridFsRepository;
import org.qubership.atp.dataset.db.ListValueRepository;
import org.qubership.atp.dataset.db.dto.AttributePathDto;
import org.qubership.atp.dataset.db.dto.ParameterDataDto;
import org.qubership.atp.dataset.db.dto.ParameterDto;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributePath;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.ParameterOverlap;
import org.qubership.atp.dataset.model.impl.AttributePathImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.model.impl.ParameterOverlapImpl;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Repository;

@Repository
public class ParameterRepository
extends AbstractRepository {
    private final SQLQueryFactory queryFactory;
    private final ParameterDtoProjection projection;
    private final DataSetRepository dsRepo;
    private final ListValueRepository lvRepo;
    private final AttributeRepository attrRepo;
    private final AttributePathRepository attrPathRepo;
    private final GridFsRepository gridFsRepoProvider;
    private final CacheRepository cacheRepo;
    private final ClearCacheService clearCacheService;

    @Autowired
    protected ParameterRepository(SQLQueryFactory queryFactory, DataSetRepository dsRepo, ListValueRepository lvRepo, AttributeRepository attrRepo, AttributePathRepository attrPathRepo, GridFsRepository gridFsRepoProvider, CacheRepository cacheRepo, ClearCacheService clearCacheService) {
        this.queryFactory = queryFactory;
        this.dsRepo = dsRepo;
        this.lvRepo = lvRepo;
        this.attrRepo = attrRepo;
        this.attrPathRepo = attrPathRepo;
        this.cacheRepo = cacheRepo;
        this.clearCacheService = clearCacheService;
        this.projection = new ParameterDtoProjection(this);
        this.gridFsRepoProvider = gridFsRepoProvider;
    }

    @Nonnull
    public Parameter create(@Nonnull UUID dsId, @Nonnull UUID attributeId, @Nonnull ParameterDataDto data) {
        return this.projection.convert(this.createParameter(dsId, attributeId, data), null);
    }

    @Nonnull
    public ParameterOverlap overlap(@Nonnull UUID dslId, @Nonnull UUID dsId, @Nonnull UUID attributeId, @Nonnull ParameterDataDto data, @Nonnull List<UUID> attributePathIds) {
        AttributePathDto attrPathDto = this.attrPathRepo.create(dslId, dsId, attributeId, attributePathIds);
        ParameterDto dto = this.createParameter(dsId, attrPathDto.getId(), data);
        return this.projection.convertOverlap(dto, attrPathDto);
    }

    private ParameterDto createParameter(@Nonnull UUID dsId, @Nonnull UUID attributeId, @Nonnull ParameterDataDto data) {
        UUID id = (UUID)((SQLInsertClause)((SQLInsertClause)this.insertWithData(data).set(ParameterRepository.PARAM.attributeId, (Object)attributeId)).set(ParameterRepository.PARAM.datasetId, (Object)dsId)).executeWithKey(ParameterRepository.PARAM.id);
        return new ParameterDto(id, dsId, attributeId, data);
    }

    @Nonnull
    @CacheEvict(value={"ATP_DATASETS_PARAMETER_CACHE_OS"}, key="#parameter.getId()")
    public Parameter update(@Nonnull Parameter parameter, @Nonnull ParameterDataDto data) {
        Preconditions.checkArgument((boolean)this.update(parameter.getId(), data), (String)"Can not update parameter: %s with data: %s", (Object)parameter, (Object)data);
        ParameterDto dto = new ParameterDto(parameter.getId(), parameter.getDataSet().getId(), parameter.getAttribute().getId(), data);
        AttributePathDto attrPathDto = ParameterDtoProjection.extractAttrPathDto(parameter);
        return this.projection.convert(dto, attrPathDto);
    }

    @Nonnull
    public boolean update(@Nonnull List<UUID> parameterIds, @Nonnull ParameterDataDto data) {
        return ((SQLUpdateClause)this.updateWithData(data).where((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.in(parameterIds))).execute() > 0L;
    }

    public boolean update(@Nonnull UUID paramId, @Nonnull ParameterDataDto data) {
        return ((SQLUpdateClause)this.updateWithData(data).where((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.eq((Object)paramId))).execute() > 0L;
    }

    @Nullable
    public Parameter getById(UUID id) {
        return this.cacheRepo.tryComputeIfAbsent(Parameter.class, id, uuid -> (Parameter)this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.eq(uuid)).fetchOne());
    }

    public boolean existsById(UUID id) {
        return this.cacheRepo.getIfPresent(Parameter.class, id) != null || this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.eq((Object)id)).fetchCount() > 0L;
    }

    @Nonnull
    List<Parameter> getByDataSetId(UUID dsId) {
        return this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.datasetId.eq((Object)dsId)).fetch();
    }

    @Nonnull
    public List<Parameter> getByAttributeId(UUID attributeId) {
        return this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq((Object)attributeId)).fetch();
    }

    @Nullable
    public Parameter getByDataSetIdAttributeId(@Nonnull UUID dataSetId, @Nonnull UUID attributeId) {
        return (Parameter)this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.datasetId.eq((Object)dataSetId).and((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq((Object)attributeId))).fetchOne();
    }

    @Nullable
    public List<Parameter> getByAttributeIdAndDatasetIds(@Nonnull UUID attributeId, @Nonnull Set<UUID> datasetIds) {
        return this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq((Object)attributeId).and((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.datasetId.in(datasetIds))).fetch();
    }

    @Nullable
    public ParameterOverlap getOverlap(@Nonnull UUID dslId, @Nonnull UUID dsId, @Nonnull UUID attributeId, @Nonnull List<UUID> attributePathIds) {
        AttributePathDto attrPathDto = this.attrPathRepo.get(dslId, dsId, attributeId, attributePathIds);
        if (attrPathDto == null) {
            return null;
        }
        Parameter param = this.getByDataSetIdAttributeId(dsId, attrPathDto.getId());
        if (param == null) {
            return null;
        }
        return param.asOverlap();
    }

    @Nonnull
    public List<Parameter> getAll() {
        return ((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)PARAM)).fetch();
    }

    @Nonnull
    public Stream<ParameterOverlap> getOverlaps(@Nonnull UUID targetAttributeId, Predicate<AttributePath> filter) {
        List<AttributePathDto> pathes = this.attrPathRepo.getByTargetAttrId(targetAttributeId);
        if (pathes == null) {
            return Stream.empty();
        }
        return pathes.stream().map(x$0 -> this.projection.convertAttrPath(x$0)).filter(filter).flatMap(path -> this.getByAttributeId(path.getId()).stream()).map(Parameter::asOverlap);
    }

    public void deleteOverlaps(UUID targetAttributeId, Predicate<AttributePath> filter) {
        List toDelete = this.getOverlaps(targetAttributeId, filter).collect(Collectors.toList());
        for (ParameterOverlap overlap : toDelete) {
            this.delete(overlap);
        }
    }

    public void deleteOverlap(@Nonnull UUID dataSetListId, @Nonnull UUID dataSetId, @Nonnull UUID targetAttributeId, @Nonnull List<UUID> attributePathIds) {
        AttributePathRepository attrPathRepo = this.attrPathRepo;
        attrPathRepo.delete(dataSetListId, dataSetId, targetAttributeId, attributePathIds);
    }

    public boolean delete(Parameter parameter) {
        if (parameter.isOverlap()) {
            AttributePath path = parameter.asOverlap().getAttributePath();
            return this.attrPathRepo.delete(path.getId());
        }
        this.clearCacheService.evictParameterCache(parameter.getId());
        this.clearCacheService.evictDatasetListContextCache(parameter.getDataSet().getId());
        return this.delete(parameter.getId());
    }

    private boolean delete(UUID id) {
        this.gridFsRepoProvider.onDeleteCascade(Collections.singletonList(id));
        return this.delete((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.eq((Object)id)) > 0L;
    }

    private long delete(@Nonnull com.querydsl.core.types.Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)PARAM).where(predicate)).execute();
    }

    private void setData(@Nonnull StoreClause clause, @Nonnull ParameterDataDto data) {
        if (data.getStringValue() != null) {
            clause.set((Path)ParameterRepository.PARAM.string, (Object)data.getStringValue());
        } else if (data.getListValueId() != null) {
            clause.set(ParameterRepository.PARAM.list, (Object)data.getListValueId());
        } else if (data.getDataSetReferenceId() != null) {
            clause.set(ParameterRepository.PARAM.ds, (Object)data.getDataSetReferenceId());
        } else {
            clause.set((Path)ParameterRepository.PARAM.string, (Object)data.getStringValue());
        }
    }

    private void setUpdateData(@Nonnull StoreClause clause, @Nonnull ParameterDataDto data) {
        if (data.getListValueId() != null) {
            clause.set((Path)ParameterRepository.PARAM.string, null);
            clause.set(ParameterRepository.PARAM.ds, null);
        } else if (data.getDataSetReferenceId() != null) {
            clause.set(ParameterRepository.PARAM.list, null);
            clause.set((Path)ParameterRepository.PARAM.string, null);
        } else {
            clause.set(ParameterRepository.PARAM.list, null);
            clause.set(ParameterRepository.PARAM.ds, null);
        }
    }

    private SQLInsertClause insertWithData(@Nonnull ParameterDataDto data) {
        SQLInsertClause result = this.queryFactory.insert((RelationalPath)PARAM);
        this.setData((StoreClause)result, data);
        return result;
    }

    private SQLUpdateClause updateWithData(@Nonnull ParameterDataDto data) {
        SQLUpdateClause result = this.queryFactory.update((RelationalPath)PARAM);
        this.setData((StoreClause)result, data);
        this.setUpdateData((StoreClause)result, data);
        return result;
    }

    void onDsDeleteCascade(@Nonnull UUID dsId) {
        this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.datasetId.eq((Object)dsId)).fetch().forEach(this::delete);
        this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.ds.eq((Object)dsId)).fetch().forEach(this::delete);
    }

    void onAttrDeleteCascade(@Nonnull UUID attrId) {
        List params = ((SQLQuery)((SQLQuery)this.queryFactory.select(ParameterRepository.PARAM.id).from((Expression)PARAM)).where((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq((Object)attrId))).fetch();
        this.gridFsRepoProvider.onDeleteCascade(params);
        this.attrPathRepo.onAttrDeleteCascade(attrId);
        this.delete((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.in((Collection)params));
    }

    void onAttrPathDeleteCascade(@Nonnull UUID attrPathId) {
        List params = ((SQLQuery)((SQLQuery)this.queryFactory.select(ParameterRepository.PARAM.id).from((Expression)PARAM)).where((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq((Object)attrPathId))).fetch();
        this.gridFsRepoProvider.onDeleteCascade(params);
        this.delete((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.id.in((Collection)params));
    }

    @Nonnull
    private SQLQuery<Parameter> select(@Nonnull com.querydsl.core.types.Predicate predicate) {
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)PARAM)).leftJoin((EntityPath)AK)).on((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.attributeId.eq(ParameterRepository.AK.id))).where(predicate);
    }

    void onListValueDeleteCascade(UUID id) {
        this.delete((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.list.eq((Object)id));
    }

    void onListValuesDeleteCascade(List<UUID> ids) {
        ((SQLUpdateClause)((SQLUpdateClause)this.queryFactory.update((RelationalPath)PARAM).setNull(ParameterRepository.PARAM.list)).where((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.list.in(ids))).execute();
    }

    public List<Parameter> findAllByListValueId(UUID listValueId) {
        return this.select((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.list.eq((Object)listValueId)).fetch();
    }

    public List<?> findAllByListValueIdWithDataSetList(UUID listValueId) {
        BooleanExpression eq = ParameterRepository.PARAM.list.eq((Object)listValueId);
        List<Tuple> result = this.getTableResponseListByPredicate(eq);
        return result.stream().map(TableResponse::fromParameterTuple).collect(Collectors.toList());
    }

    public List<TableResponse> findAllByListValueIdsWithDataSetList(List<UUID> listValueIds) {
        BooleanExpression in = ParameterRepository.PARAM.list.in(listValueIds);
        List<Tuple> result = this.getTableResponseListByPredicate(in);
        return result.stream().map(TableResponse::fromParameterTuple).collect(Collectors.toList());
    }

    private List<Tuple> getTableResponseListByPredicate(BooleanExpression predicate) {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.queryFactory.select(new Expression[]{ParameterRepository.DSL.id, ParameterRepository.DSL.name, ParameterRepository.DS.id, ParameterRepository.DS.name, ParameterRepository.PARAM.id, ParameterRepository.PARAM.list, ParameterRepository.ATTR.id, ParameterRepository.ATTR.name}).from((Expression)PARAM)).where((com.querydsl.core.types.Predicate)predicate)).leftJoin((EntityPath)DS)).on((com.querydsl.core.types.Predicate)ParameterRepository.PARAM.datasetId.eq(ParameterRepository.DS.id))).leftJoin((EntityPath)DSL)).on((com.querydsl.core.types.Predicate)ParameterRepository.DS.datasetlistId.eq(ParameterRepository.DSL.id))).leftJoin((EntityPath)ATTR)).on((com.querydsl.core.types.Predicate)ParameterRepository.ATTR.id.eq(ParameterRepository.PARAM.attributeId))).fetch();
    }

    private static class ParameterDtoProjection
    extends MappingProjection<Parameter> {
        private final ParameterRepository parameterRepository;

        ParameterDtoProjection(ParameterRepository parameterRepository) {
            super(Parameter.class, (Expression[][])new Expression[][]{AbstractRepository.PARAM.all(), AbstractRepository.AK.all()});
            this.parameterRepository = parameterRepository;
        }

        @Nullable
        private static AttributePathDto extractAttrPathDto(@Nonnull Parameter parameter) {
            if (!parameter.isOverlap()) {
                return null;
            }
            AttributePath attrPath = parameter.asOverlap().getAttributePath();
            return new AttributePathDto(attrPath.getId(), attrPath.getDataSet().getDataSetList().getId(), attrPath.getDataSet().getId(), attrPath.getTargetAttribute().getId(), attrPath.getPath().stream().map(Identified::getId).collect(Collectors.toList()));
        }

        protected Parameter map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.PARAM.id);
            UUID attrId = (UUID)row.get(AbstractRepository.PARAM.attributeId);
            assert (attrId != null);
            AttributePathDto attrPath = null;
            UUID attrKeyId = (UUID)row.get(AbstractRepository.AK.id);
            if (attrKeyId != null) {
                attrPath = AttributePathRepository.AttributePathProjection.createDto(AbstractRepository.AK, row);
            }
            UUID dsId = (UUID)row.get(AbstractRepository.PARAM.datasetId);
            assert (dsId != null);
            ParameterDto dto = new ParameterDto(id, dsId, attrId, new ParameterDataDto((String)row.get((Expression)AbstractRepository.PARAM.string), (UUID)row.get(AbstractRepository.PARAM.ds), (UUID)row.get(AbstractRepository.PARAM.list)));
            return this.convert(dto, attrPath);
        }

        @Nonnull
        private ParameterOverlap convertOverlap(@Nonnull ParameterDto dto, @Nonnull AttributePathDto attrPath) {
            ParameterOverlapImpl result = new ParameterOverlapImpl();
            AttributePathImpl path = this.convertAttrPath(attrPath);
            this.fillValues(result, dto, path.getTargetAttribute().getType());
            result.setAttributePath(path);
            return result;
        }

        @Nonnull
        private Parameter convert(@Nonnull ParameterDto dto, @Nullable AttributePathDto attrPath) {
            if (attrPath != null) {
                return this.convertOverlap(dto, attrPath);
            }
            ParameterImpl result = new ParameterImpl();
            Attribute attribute = this.parameterRepository.attrRepo.getById(dto.getAttributeId());
            result.setAttribute(attribute);
            this.fillValues(result, dto, attribute.getType());
            return result;
        }

        @Nonnull
        private AttributePathImpl convertAttrPath(@Nonnull AttributePathDto attrPathDto) {
            DataSet ds = Proxies.withId(DataSet.class, attrPathDto.getDataSetId(), this.parameterRepository.dsRepo::getById);
            Attribute targetAttr = Proxies.withId(Attribute.class, attrPathDto.getTargetAttributeId(), this.parameterRepository.attrRepo::getById);
            List<Attribute> attrList = attrPathDto.getAttributePathIds().stream().map((? super T uuid) -> Proxies.withId(Attribute.class, uuid, this.parameterRepository.attrRepo::getById)).collect(Collectors.toList());
            return new AttributePathImpl(attrPathDto.getId(), ds, targetAttr, attrList);
        }

        private void fillValues(Parameter model, ParameterDto parameterDto, AttributeType attributeType) {
            model.setId(parameterDto.getId());
            model.setDataSet(Proxies.withId(DataSet.class, parameterDto.getDataSetId(), this.parameterRepository.dsRepo::getById));
            ParameterDataDto parameterValue = parameterDto.getParameterData();
            switch (attributeType) {
                case CHANGE: 
                case ENCRYPTED: 
                case TEXT: {
                    model.setText(parameterValue.getStringValue());
                    break;
                }
                case LIST: {
                    UUID listValueId = parameterValue.getListValueId();
                    if (listValueId == null) break;
                    ListValue listValue = Proxies.withId(ListValue.class, listValueId, this.parameterRepository.lvRepo::getById);
                    model.setListValue(listValue);
                    break;
                }
                case DSL: {
                    UUID dataSetReferenceId = parameterValue.getDataSetReferenceId();
                    if (dataSetReferenceId == null) break;
                    DataSet referencedDataSet = Proxies.withId(DataSet.class, dataSetReferenceId, this.parameterRepository.dsRepo::getById);
                    model.setDataSetReference(referencedDataSet);
                    break;
                }
                case FILE: {
                    Optional<FileData> fileInfo = this.parameterRepository.gridFsRepoProvider.getFileInfo(parameterDto.getId());
                    fileInfo.ifPresent(model::setFileData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown attribute type");
                }
            }
        }
    }
}

