/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db.utils;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.IdentifiedCache;
import org.qubership.atp.dataset.model.Identified;

public class WeakIdentifiedCache
implements IdentifiedCache {
    private static CacheBuilder CACHE_BUILDER = CacheBuilder.from((String)"weakValues");
    private Map<Class<? extends Identified>, Cache<UUID, Identified>> caches = null;

    @Override
    @Nonnull
    public <T extends Identified> T computeIfAbsent(@Nonnull Class<T> type, @Nonnull UUID id, @Nonnull Function<UUID, ? extends T> sourceFunc) {
        try {
            return (T)((Identified)this.getCache(type).get((Object)id, () -> (Identified)Preconditions.checkNotNull((Object)((Identified)sourceFunc.apply(id)), (String)"[%s] with id [%s] is not provided by [%s]", (Object)type, (Object)id, (Object)sourceFunc)));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    @Override
    @Nullable
    public <T extends Identified> T getIfPresent(@Nonnull Class<T> type, @Nonnull UUID id) {
        if (this.caches == null) {
            return null;
        }
        Cache<UUID, Identified> cache = this.caches.get(type);
        if (cache == null) {
            return null;
        }
        return (T)((Identified)cache.getIfPresent((Object)id));
    }

    @Override
    public <T extends Identified> void put(@Nonnull Class<T> type, @Nonnull T identified) {
        this.getCache(type).put((Object)identified.getId(), identified);
    }

    @Override
    public void clear() {
        if (this.caches == null) {
            return;
        }
        for (Cache<UUID, Identified> cache : this.caches.values()) {
            cache.invalidateAll();
        }
    }

    @Nonnull
    private <T extends Identified> Cache<UUID, T> getCache(@Nonnull Class<T> type) {
        Object cache;
        if (this.caches == null) {
            this.caches = new HashMap<Class<? extends Identified>, Cache<UUID, Identified>>();
        }
        if ((cache = this.caches.get(type)) == null) {
            cache = this.createCache();
            this.caches.put((Class<? extends Identified>)type, (Cache<UUID, Identified>)cache);
        }
        return cache;
    }

    private <T extends Identified> Cache<UUID, T> createCache() {
        return CACHE_BUILDER.build();
    }
}

