/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.kafka.handlers.project;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.qubership.atp.dataset.kafka.entities.project.EventType;
import org.qubership.atp.dataset.kafka.entities.project.ProjectEvent;
import org.qubership.atp.dataset.kafka.handlers.KafkaEventHandler;
import org.qubership.atp.dataset.kafka.handlers.project.ProcessingStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"kafka.enable"}, matchIfMissing=false)
public class ProjectEventHandler
implements KafkaEventHandler<ProjectEvent> {
    private Map<EventType, ProcessingStrategy> processingStrategyMap = new HashMap<EventType, ProcessingStrategy>();

    @Autowired
    public ProjectEventHandler(Set<ProcessingStrategy<ProjectEvent, EventType>> handleStrategySet) {
        handleStrategySet.forEach(x -> this.processingStrategyMap.put((EventType)((Object)((Object)x.getIdentifier())), (ProcessingStrategy)x));
    }

    @Override
    public void handle(ProjectEvent projectEvent) {
        this.processingStrategyMap.get((Object)projectEvent.getType()).process(projectEvent);
    }
}

