/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.impl;

import java.util.stream.Stream;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.Macros;
import org.qubership.atp.dataset.macros.args.ArgsParser;
import org.qubership.atp.dataset.macros.args.DumbArgsParser;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.springframework.stereotype.Component;

@Component
public class InnMacros
extends Macros<String> {
    public static final int[] FACTORS = new int[]{2, 4, 10, 3, 5, 9, 4, 6, 8};

    public InnMacros() {
        super("INN");
    }

    @Override
    public String evaluate(Stream<? extends MacroArg> input, EvaluationContext context) throws Exception {
        StringBuilder result = new StringBuilder();
        int last = 0;
        for (int i = 0; i < 9; ++i) {
            int floor = (int)Math.floor(Math.random() * 9.0 + 1.0);
            result.append(floor);
            last += FACTORS[i] * floor;
        }
        last = last % 11 % 10;
        result.append(last);
        return result.toString();
    }

    @Override
    public ArgsParser createArgsParser() {
        return new DumbArgsParser();
    }

    @Override
    public boolean doCache() {
        return true;
    }
}

