/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.parser.Token;
import org.qubership.atp.dataset.macros.parser.TokenType;
import org.qubership.atp.dataset.macros.parser.TokensIterator;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;
import org.qubership.atp.dataset.macros.processor.MacroProcessorBase;

public abstract class AbstractMacroProcessor<T extends MacroContextBase>
extends MacroProcessorBase<T> {
    protected final StringBuilder tail;
    protected final MacroRegistry registry;
    protected final TokensIterator tokens;
    protected String lastEvaluationResult;

    protected AbstractMacroProcessor(StringBuilder tail, MacroRegistry registry) {
        this.tail = tail;
        this.registry = registry;
        this.tokens = new TokensIterator(registry, tail);
    }

    public String getValue() throws CtxEvalException {
        this.assertEvaluationEnded();
        return this.getText(this.state);
    }

    public boolean evaluateNext() throws CtxEvalException {
        if (!this.tokens.hasNext()) {
            return this.reduceTreeLevel() && this.evaluateNext();
        }
        Token next = this.tokens.next();
        this.read(next);
        return true;
    }

    @Override
    protected boolean reevaluateRootLevel(@Nonnull T root) throws CtxEvalException {
        String evaluatedRoot = this.getText(root);
        if (evaluatedRoot.isEmpty() || evaluatedRoot.equals(this.lastEvaluationResult)) {
            return false;
        }
        this.tokens.reset();
        this.tail.append(evaluatedRoot);
        ((MacroContextBase)root).uninitialize();
        this.dropText(root);
        this.lastEvaluationResult = evaluatedRoot;
        return true;
    }

    @Nonnull
    protected abstract String getArguments(@Nonnull T var1);

    @Nonnull
    protected abstract String getText(@Nonnull T var1);

    protected abstract void dropArguments(@Nonnull T var1);

    protected abstract void dropText(@Nonnull T var1);

    @Override
    protected void reduce(@Nonnull T parent, @Nonnull T child) throws CtxEvalException {
        this.tail.append(this.getArguments(parent)).append(TokenType.FORMULA_END.fromValue.apply(this.getText(child)));
        this.tokens.notifyReduce();
        this.dropArguments(parent);
    }

    public String evaluateAll() throws CtxEvalException {
        try {
            boolean hasNext;
            while (hasNext = this.evaluateNext()) {
            }
            return this.getValue();
        }
        catch (RuntimeException e) {
            throw new CtxEvalException(this.state.toString() + "<error here>" + this.tail, this.state, (Throwable)e);
        }
    }
}

