/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.parser.Token;
import org.qubership.atp.dataset.macros.parser.TokenType;
import org.qubership.atp.dataset.macros.processor.MacroContextBase;

public abstract class MacroProcessorBase<T extends MacroContextBase> {
    protected static final Start START = new Start();
    protected static final End END = new End();
    protected T state;

    protected abstract boolean reevaluateRootLevel(@Nonnull T var1) throws CtxEvalException;

    protected abstract void reduce(@Nonnull T var1, @Nonnull T var2) throws CtxEvalException;

    protected void read(Token token) throws CtxEvalException {
        this.state = ((MacroContextBase)this.state).strategy.read(token, (MacroContextBase)this.state);
    }

    public boolean reduceTreeLevel() throws CtxEvalException {
        MacroContextBase state = ((MacroContextBase)this.state).strategy.reduceTreeLevel((MacroContextBase)this.state);
        if (state == null) {
            return false;
        }
        this.state = state;
        return true;
    }

    public void assertEvaluationEnded() throws CtxEvalException {
        ((MacroContextBase)this.state).strategy.assertEvaluationEnded((MacroContextBase)this.state);
    }

    protected abstract T createChildContext(@Nonnull T var1, @Nonnull String var2);

    public String toString() {
        return this.state.toString();
    }

    protected static interface Strategy {
        @Nonnull
        public MacroContextBase read(Token var1, MacroContextBase var2) throws CtxEvalException;

        public void assertEvaluationEnded(MacroContextBase var1) throws CtxEvalException;

        @Nullable
        public MacroContextBase reduceTreeLevel(MacroContextBase var1) throws CtxEvalException;
    }

    private static class Start
    implements Strategy {
        private Start() {
        }

        @Override
        @Nonnull
        public MacroContextBase read(Token token, MacroContextBase state) throws CtxEvalException {
            switch ((TokenType)((Object)token.getKey())) {
                case FORMULA_START: {
                    return state.getProcessor().createChildContext(state, (String)token.getValue());
                }
                case FORMULA_END: {
                    state.pushArguments((String)token.getValue());
                    state.evaluate();
                    state.uninitialize();
                    return state;
                }
            }
            state.pushArguments((String)token.getValue());
            return state;
        }

        @Override
        public void assertEvaluationEnded(MacroContextBase state) throws CtxEvalException {
            throw new CtxEvalException("Macro is not closed properly", state);
        }

        @Override
        @Nullable
        public MacroContextBase reduceTreeLevel(MacroContextBase state) throws CtxEvalException {
            throw new CtxEvalException("Macro is not ended properly", state);
        }
    }

    private static class End
    implements Strategy {
        private End() {
        }

        @Override
        @Nonnull
        public MacroContextBase read(Token token, MacroContextBase state) throws CtxEvalException {
            switch ((TokenType)((Object)token.getKey())) {
                case FORMULA_START: {
                    state.initialize((String)token.getValue());
                    return state;
                }
                case FORMULA_END: {
                    if (state.parent == null) {
                        throw new CtxEvalException("Unexpected macro ending: " + token, state);
                    }
                    state.pushText((String)token.getValue());
                    MacroContextBase result = this.reduceTreeLevel(state);
                    if (result == null) {
                        throw new CtxEvalException("Unexpected macro ending: " + token, state);
                    }
                    return result;
                }
            }
            state.pushText((String)token.getValue());
            return state;
        }

        @Override
        public void assertEvaluationEnded(MacroContextBase state) throws CtxEvalException {
            if (state.parent != null) {
                throw new CtxEvalException("Macro is not closed properly", state);
            }
        }

        @Override
        @Nullable
        public MacroContextBase reduceTreeLevel(MacroContextBase state) throws CtxEvalException {
            if (state.parent == null) {
                if (state.getProcessor().reevaluateRootLevel(state)) {
                    return state;
                }
                return null;
            }
            state.getProcessor().reduce(state.parent, state);
            return state.parent;
        }
    }
}

