/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.utils.tree.TraverseAndLeafsHandler;

public class DslAttrHandler
implements TraverseAndLeafsHandler<DataSetList, Attribute, List<String>> {
    private final AttrDslHandler attrDsl = new AttrDslHandler();

    @Override
    @Nonnull
    public TraverseAndLeafsHandler<?, DataSetList, List<String>> backToPreviousParent() {
        this.attrDsl.attrPath.removeLast();
        return this.attrDsl;
    }

    @Override
    @Nonnull
    public TraverseAndLeafsHandler<Attribute, ?, List<String>> forwardToNewParent(@Nonnull DataSetList parent) {
        return this.attrDsl;
    }

    @Override
    public Iterator<? extends Attribute> getChildren(@Nonnull DataSetList item) {
        return item.getAttributes().iterator();
    }

    @Override
    @Nullable
    public List<String> constructLeaf(@Nonnull DataSetList leaf) {
        return null;
    }

    private class AttrDslHandler
    implements TraverseAndLeafsHandler<Attribute, DataSetList, List<String>> {
        final LinkedList<Attribute> attrPath = new LinkedList();

        private AttrDslHandler() {
        }

        @Override
        @Nonnull
        public TraverseAndLeafsHandler<?, Attribute, List<String>> backToPreviousParent() {
            return DslAttrHandler.this;
        }

        @Override
        @Nonnull
        public TraverseAndLeafsHandler<DataSetList, ?, List<String>> forwardToNewParent(@Nonnull Attribute parent) {
            this.attrPath.add(parent);
            return DslAttrHandler.this;
        }

        @Override
        public Iterator<? extends DataSetList> getChildren(@Nonnull Attribute item) {
            DataSetList ref = item.getDataSetListReference();
            return ref == null ? null : Iterators.singletonIterator((Object)ref);
        }

        @Override
        @Nullable
        public List<String> constructLeaf(@Nonnull Attribute leaf) {
            ArrayList path = Lists.newArrayListWithExpectedSize((int)(this.attrPath.size() + 1));
            this.attrPath.stream().map(Named::getName).forEach(path::add);
            path.add(leaf.getName());
            return path;
        }
    }
}

