/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.FlatDataImpl;
import org.qubership.atp.dataset.model.utils.DsAttrPathUiHandler;
import org.qubership.atp.dataset.model.utils.DsParamHandler;
import org.qubership.atp.dataset.model.utils.DslAttrHandler;
import org.qubership.atp.dataset.model.utils.DslUiHandler;
import org.qubership.atp.dataset.model.utils.MemoizingSupplier;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.Prefix;
import org.qubership.atp.dataset.model.utils.tree.AllRefsIterator;
import org.qubership.atp.dataset.model.utils.tree.Leaf;
import org.qubership.atp.dataset.model.utils.tree.LeafsWalker;
import org.qubership.atp.dataset.model.utils.tree.RefsVisitor;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManAttribute;
import org.qubership.atp.dataset.service.rest.dto.manager.UiManDataSetList;

public class Utils {
    private static final String UUID_REGEX = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    private static final Pattern uuidPattern = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
    public static final Joiner JOINER_DOT = Joiner.on((char)'.');
    private static final Supplier<?> EMPTY_SUP = new Supplier<Object>(){

        public String toString() {
            return "null supplier";
        }

        @Override
        public Object get() {
            return null;
        }
    };

    @Nonnull
    public static <T> Supplier<T> emptySup() {
        return EMPTY_SUP;
    }

    public static boolean isEqual(@Nonnull Identified o1, @Nullable Object o2) {
        return Utils.isEqual(Identified.class, o1, o2);
    }

    public static <T extends Identified> boolean isEqual(@Nonnull Class<T> clazz, @Nonnull T o1, @Nullable Object o2) {
        return o1 == o2 || Utils.isEqual(clazz, o1.getId(), o2);
    }

    public static <T extends Identified> boolean isEqual(@Nonnull Class<T> clazz, @Nonnull Object id, @Nullable Object target) {
        if (target == null) {
            return false;
        }
        if (!clazz.isAssignableFrom(target.getClass())) {
            return false;
        }
        return Objects.equals(id, ((Identified)clazz.cast(target)).getId());
    }

    @Nonnull
    public static Stream<Identified> allRefs(@Nonnull Identified root) {
        AllRefsIterator<Identified> allRefs = new AllRefsIterator<Identified>((Iterator)Iterators.singletonIterator((Object)root), true){

            @Override
            protected Iterator<? extends Identified> getChildren(@Nonnull Identified parent) {
                return parent.getReferences().iterator();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(allRefs, 16), false);
    }

    @Nonnull
    public static FlatDataImpl doFlatData(@Nonnull Identified root) {
        FlatDataImpl result = new FlatDataImpl();
        Utils.allRefs(root).forEach(result);
        return result;
    }

    public static FlatDataImpl doFlatData(@Nonnull DataSetList dataSetList) {
        FlatDataImpl flatData = new FlatDataImpl();
        flatData.setParameters(new LinkedHashSet<Parameter>());
        flatData.setDataSets(new LinkedHashSet<DataSet>());
        flatData.setAttributes(new LinkedHashSet<Attribute>());
        flatData.setDataSetLists(new LinkedHashSet<DataSetList>());
        Utils.fillFlatData(flatData, dataSetList);
        return flatData;
    }

    public static UiManDataSetList doUiDs(@Nonnull DataSetList dataSetList, @Nonnull DsEvaluator eval, boolean expandAll) {
        DslUiHandler dslUiHandler = new DslUiHandler(eval, expandAll);
        RefsVisitor<DataSetList, Attribute> visitor = new RefsVisitor<DataSetList, Attribute>((Iterator<DataSetList>)Iterators.singletonIterator((Object)dataSetList), dslUiHandler, null);
        while (visitor.hasNext()) {
            visitor.next();
        }
        return dslUiHandler.getResult();
    }

    public static UiManDataSetList doUiDs(@Nonnull DataSetList dataSetList, MacroContext macroContext, DataSetParameterProvider dataSetParameterProvider, DsEvaluator eval, boolean evaluate, boolean expandAll) {
        DslUiHandler dslUiHandler = new DslUiHandler(eval, macroContext, dataSetParameterProvider, evaluate, expandAll);
        RefsVisitor<DataSetList, Attribute> visitor = new RefsVisitor<DataSetList, Attribute>((Iterator<DataSetList>)Iterators.singletonIterator((Object)dataSetList), dslUiHandler, null);
        while (visitor.hasNext()) {
            visitor.next();
        }
        return dslUiHandler.getResult();
    }

    @Nullable
    public static UiManAttribute doUiAttr(@Nonnull DataSet dataSet, @Nonnull DsEvaluator eval, @Nonnull List<UUID> attrPath) {
        DsAttrPathUiHandler h = new DsAttrPathUiHandler(eval, attrPath);
        RefsVisitor<DataSet, Attribute> visitor = new RefsVisitor<DataSet, Attribute>((Iterator<DataSet>)Iterators.singletonIterator((Object)dataSet), h, null);
        while (visitor.hasNext()) {
            visitor.next();
        }
        return h.getAttribute();
    }

    @Nonnull
    public static <T> Supplier<T> memoize(@Nonnull Supplier<T> delegate) {
        return delegate instanceof MemoizingSupplier ? delegate : new MemoizingSupplier((Supplier)Preconditions.checkNotNull((Object)delegate));
    }

    public static Iterator<Leaf> paramsInDslWalker(DataSetList root, DsEvaluator evaluator) {
        return new LeafsWalker<DataSet, OverlapItem.Reachable, Leaf>(root.getDataSets().iterator(), new DsParamHandler(evaluator), null);
    }

    public static Iterator<Leaf> paramsInDsWalker(DataSet root, DsEvaluator evaluator) {
        return new LeafsWalker<DataSet, OverlapItem.Reachable, Leaf>((Iterator<DataSet>)Iterators.singletonIterator((Object)root), new DsParamHandler(evaluator), null);
    }

    public static Iterator<List<String>> attributesInDslWalker(DataSetList root) {
        return new LeafsWalker<DataSetList, Attribute, List<String>>((Iterator<DataSetList>)Iterators.singletonIterator((Object)root), new DslAttrHandler(), null);
    }

    @Nonnull
    public static ObjectNode serializeInItfWay(@Nonnull DataSet ds, @Nonnull ObjectMapper mapper, @Nonnull DsEvaluator eval) {
        ObjectNode result = mapper.createObjectNode();
        Iterator<Leaf> walker = Utils.paramsInDsWalker(ds, eval);
        while (walker.hasNext()) {
            Leaf leaf = walker.next();
            List<String> pathLst = leaf.getPath();
            Preconditions.checkArgument((!pathLst.isEmpty() ? 1 : 0) != 0, (Object)"Data set should not contain parameter without name (path to it)");
            String paramName = pathLst.remove(pathLst.size() - 1);
            Utils.createGroupsPath(result, pathLst, mapper).set(paramName, (JsonNode)mapper.convertValue(leaf.getLeaf(), JsonNode.class));
        }
        return result;
    }

    @Nonnull
    public static ArrayNode serializeAttrInItfWay(@Nonnull DataSetList dsl, @Nonnull ObjectMapper mapper) {
        ArrayNode result = mapper.createArrayNode();
        Iterator<List<String>> walker = Utils.attributesInDslWalker(dsl);
        while (walker.hasNext()) {
            result.add(JOINER_DOT.join(walker.next().iterator()));
        }
        return result;
    }

    public static <T, A, R> Stream<R> combinations(@Nonnull List<? extends Collection<? extends T>> values, @Nonnull Collector<T, A, R> collector) {
        if (values.isEmpty()) {
            return Stream.empty();
        }
        Function<A, R> finisher = collector.finisher();
        return Utils.combine(values, 0, null, collector.supplier(), collector.accumulator()).map(finisher);
    }

    private static <T, A> Stream<A> combine(@Nonnull List<? extends Collection<? extends T>> values, int offset, @Nullable Prefix<T> prefix, @Nonnull Supplier<A> supplier, @Nonnull BiConsumer<A, T> accumulator) {
        if (offset == values.size() - 1) {
            return values.get(offset).stream().map(e -> new Prefix<Object>(prefix, e).addTo(supplier.get(), accumulator));
        }
        return values.get(offset).stream().flatMap(e -> Utils.combine(values, offset + 1, new Prefix<Object>(prefix, e), supplier, accumulator));
    }

    @Nonnull
    private static ObjectNode createGroupsPath(@Nonnull ObjectNode root, @Nonnull List<String> path, @Nonnull ObjectMapper mapper) {
        if (path.isEmpty()) {
            return root;
        }
        ObjectNode target = root;
        for (String groupName : path) {
            JsonNode node = target.get(groupName);
            if (node == null) {
                ObjectNode newOne = mapper.createObjectNode();
                target.set(groupName, (JsonNode)newOne);
                target = newOne;
                continue;
            }
            target = (ObjectNode)node;
        }
        return target;
    }

    private static void fillFlatData(FlatDataImpl flatData, DataSetList dsl) {
        flatData.getDataSets().addAll(dsl.getDataSets());
        List<Attribute> attributes = dsl.getAttributes();
        flatData.getAttributes().addAll(attributes);
        flatData.getDataSetLists().add(dsl);
        dsl.getDataSets().forEach(dataSet -> {
            flatData.getParameters().addAll(dataSet.getParameters());
            dataSet.getParameters().forEach(parameter -> {
                if (parameter.getDataSetReference() != null && !flatData.getDataSets().contains(parameter.getDataSetReference())) {
                    Utils.fillFlatData(flatData, parameter.getDataSetReference().getDataSetList());
                }
            });
        });
    }

    @Nonnull
    public static StringBuilder appendFriendlyMessage(@Nonnull StringBuilder to, @Nonnull Throwable throwable) {
        if (throwable.getSuppressed().length == 0) {
            Utils.collectRootCauses(to, throwable);
        } else {
            final int[] offset = new int[]{0};
            new AllRefsIterator<Throwable>((Iterator)Iterators.singletonIterator((Object)throwable), false){

                @Override
                @Nullable
                protected Iterator<? extends Throwable> getChildren(@Nonnull Throwable parent) {
                    return Arrays.asList(parent.getSuppressed()).iterator();
                }

                @Override
                protected void forwardToNewParent(Throwable parent) {
                    offset[0] = offset[0] + 1;
                }

                @Override
                protected void backToPreviousParent() {
                    offset[0] = offset[0] - 1;
                }
            }.forEachRemaining(error -> {
                boolean isChild = false;
                for (int i = 0; i < offset[0]; ++i) {
                    to.append("  ");
                    isChild = true;
                }
                if (isChild) {
                    to.append("|-");
                }
                Utils.collectRootCauses(to, error);
                to.append("\n");
            });
        }
        return to;
    }

    private static void collectRootCauses(@Nonnull StringBuilder to, @Nonnull Throwable throwable) {
        Joiner.on((String)": ").appendTo(to, Throwables.getCausalChain((Throwable)throwable).stream().map(Throwable::getMessage).distinct().iterator());
    }

    public static boolean isUuid(Object value) {
        if (value instanceof UUID) {
            return true;
        }
        if (value instanceof String) {
            return uuidPattern.matcher((String)value).matches();
        }
        return false;
    }
}

