/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.impl;

import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.cache.SimpleCache;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.EvaluationService;
import org.qubership.atp.dataset.service.direct.macros.CachingParamEvaluator;
import org.qubership.atp.dataset.service.direct.macros.DsEvaluator;
import org.qubership.atp.dataset.service.direct.macros.EvaluateDsParamStrategyImpl;
import org.qubership.atp.dataset.service.direct.macros.UnwrapAlias;
import org.qubership.atp.dataset.service.direct.macros.schange.EvaluateDsStructureStrategyImpl;
import org.qubership.atp.dataset.service.direct.macros.schange.NoStructureChange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EvaluationServiceImpl
implements EvaluationService {
    private DataSetListRepository dslRepo;
    private DataSetRepository dsRepo;
    private AliasWrapperService aliasWrapperService;
    private MacroRegistry registry;

    @Autowired
    public void setDslRepo(DataSetListRepository dslRepo) {
        this.dslRepo = dslRepo;
    }

    @Autowired
    public void setDsRepo(DataSetRepository dsRepo) {
        this.dsRepo = dsRepo;
    }

    @Autowired
    public void setAliasWrapperService(AliasWrapperService aliasWrapperService) {
        this.aliasWrapperService = aliasWrapperService;
    }

    @Autowired
    public void setRegistry(MacroRegistry registry) {
        this.registry = registry;
    }

    @Override
    public DsEvaluator getEvaluator(boolean evaluate, boolean acceptFails) {
        CachingParamEvaluator result;
        if (evaluate) {
            EvaluateDsParamStrategyImpl dsParamStrategy = new EvaluateDsParamStrategyImpl(this.registry, this.aliasWrapperService, new SimpleCache(), acceptFails);
            EvaluateDsStructureStrategyImpl dsStructureStrategy = new EvaluateDsStructureStrategyImpl(this.dslRepo, this.dsRepo, this.aliasWrapperService, this.registry);
            result = new CachingParamEvaluator(dsParamStrategy, dsStructureStrategy);
        } else {
            UnwrapAlias dsParamStrategy = new UnwrapAlias(this.aliasWrapperService);
            NoStructureChange dsStructureStrategy = new NoStructureChange(this.dsRepo);
            result = new CachingParamEvaluator(dsParamStrategy, dsStructureStrategy);
        }
        return result;
    }
}

