/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.service;

import clover.com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.junit.jupiter.api.parallel.Isolated;
import org.qubership.atp.dataset.exception.excel.ExcelImportEmptyExcelException;
import org.qubership.atp.dataset.exception.excel.ExcelImportNotExistingAttributeException;
import org.qubership.atp.dataset.exception.excel.ExcelImportNotExistingChildAttributeException;
import org.qubership.atp.dataset.exception.excel.ExcelImportNotExistingRefParameterException;
import org.qubership.atp.dataset.exception.excel.ExcelImportUnexpectedException;
import org.qubership.atp.dataset.exception.excel.ImportExcelNotEqualsAttributeTypeException;
import org.qubership.atp.dataset.exception.excel.ImportExcelNotSupportedAttributeTypeException;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.XlsxToListConverter;
import org.qubership.atp.dataset.service.direct.importexport.exceptions.ImportFailedException;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportResponse;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetListImportResponse;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.models.ParameterImportResponse;
import org.qubership.atp.dataset.service.direct.importexport.service.DataSetListImportExportFactory;
import org.qubership.atp.dataset.service.direct.importexport.utils.ImportUtils;
import org.qubership.atp.dataset.service.direct.importexport.utils.StreamUtils;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaAttributeService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Isolated
@Service
public class DatasetListImportService {
    private static final Logger log = LoggerFactory.getLogger(DatasetListImportService.class);
    private static final List<AttributeType> supportedImportAttributeTypes = Arrays.asList(AttributeType.TEXT, AttributeType.LIST, AttributeType.DSL, AttributeType.ENCRYPTED);
    private static final String UNDERSCORE = "_";
    private static final Map<String, Integer> requiredHeadingIndexesMap = ImmutableMap.of((Object)"Attribute", (Object)0, (Object)"Type", (Object)1);
    private final DataSetListImportExportFactory factory;
    private final JpaDataSetListService dataSetListService;
    private final JpaDataSetService dataSetService;
    private final JpaAttributeService attributeService;
    private final ParameterService parameterService;
    private final ClearCacheService clearCacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetListImportResponse importDataSetList(UUID targetProjectId, UUID targetDslId, InputStream inputStream, boolean isJavers) throws Exception {
        log.info("Start process importing from Excel file, [ProjectId] = '{}', [DslId] = '{}'", (Object)targetProjectId, (Object)targetDslId);
        this.validateDataSetsAreNotLocked(targetDslId);
        OPCPackage pkg = OPCPackage.open((InputStream)inputStream);
        ArrayList<Map<Integer, String>> sheetConvertList = new ArrayList<Map<Integer, String>>();
        try {
            XlsxToListConverter xlsxToListConverter = new XlsxToListConverter(pkg, sheetConvertList);
            xlsxToListConverter.process();
        }
        finally {
            pkg.revert();
        }
        ListIterator<Map<Integer, String>> rowsIterator = sheetConvertList.listIterator();
        AttributeImportContext context = this.prepareImportContext(targetProjectId, targetDslId, sheetConvertList.listIterator(), isJavers);
        this.validateImportFileSchema(targetDslId, sheetConvertList.listIterator(), context);
        rowsIterator.next();
        log.info("Start final phase importing excel to DataBase, [ProjectId] = '{}', [DslId] = '{}'", (Object)targetProjectId, (Object)targetDslId);
        DatasetListImportResponse response = this.importExcel(rowsIterator, context);
        log.info("Finish process importing from Excel file: [ProjectId] = '{}', [DslId] = '{}'", (Object)targetProjectId, (Object)targetDslId);
        return response;
    }

    private DatasetListImportResponse importExcel(ListIterator<Map<Integer, String>> rowsIterator, AttributeImportContext context) {
        try {
            DatasetListImportResponse importResponse = new DatasetListImportResponse();
            while (rowsIterator.hasNext()) {
                Map<Integer, String> row = rowsIterator.next();
                if (ImportUtils.isBlankRow(row)) {
                    log.debug("Skip blank row");
                    continue;
                }
                String attributeType = ImportUtils.getAttributeType(row);
                log.debug("Attribute type: {}", (Object)attributeType);
                AttributeImportConverter importConverter = this.factory.getAttributeImportConverter(attributeType);
                log.debug("Import converter class: {}", (Object)importConverter.getClass().getName());
                AttributeImportModel model = importConverter.mapRowToImportModel(row, context, rowsIterator);
                log.debug("Import model: {}", (Object)model);
                List<ParameterImportResponse> parameterImportErrors = importConverter.validate(model, context);
                AttributeImportResponse attributeResponse = importResponse.addAttributeResponse(model);
                attributeResponse.setErrors(parameterImportErrors);
                this.importAttributeParameters(model, importConverter, context, importResponse);
            }
            return importResponse;
        }
        catch (Exception ex) {
            log.error("Unexpected error while excel import", (Throwable)ex);
            throw new ExcelImportUnexpectedException(ex);
        }
    }

    void importAttributeParameters(AttributeImportModel model, AttributeImportConverter converter, AttributeImportContext context, DatasetListImportResponse response) {
        String attributeName = model.getName();
        log.debug("Start importing parameters for attribute '{}'", (Object)attributeName);
        AttributeImportResponse attributeResponse = response.getAttributeResponse(model);
        for (DatasetParameterValue datasetParameterValue : model.getDatasetParameterValues()) {
            String datasetName = datasetParameterValue.getDatasetName();
            String parameterValue = datasetParameterValue.getTextValue();
            log.debug("Import parameter value '{}' for dataset '{}'", (Object)parameterValue, (Object)datasetName);
            try {
                ParameterImportResponse successParameterImportResponse = converter.importAttributeParameter(model, datasetParameterValue, context);
                if (!Objects.nonNull(successParameterImportResponse.getDataSetId())) continue;
                Parameter parameter = this.parameterService.getByDataSetIdAttributeId(datasetParameterValue.getDatasetId(), model.getId());
                if (parameter != null) {
                    this.clearCacheService.evictParameterCache(parameter.getId());
                    this.clearCacheService.evictDatasetListContextCache(datasetParameterValue.getDatasetId());
                }
                attributeResponse.setSuccess(successParameterImportResponse);
            }
            catch (Exception e) {
                UUID datasetId = datasetParameterValue.getDatasetId();
                String keyAttributeValue = model.getKey();
                String errorMessage = String.format("Failed to import key attribute: '%s' in dataset id: '%s', DsName: '%s', Reason: '%s'", keyAttributeValue, datasetId, datasetName, e.getMessage());
                log.error(errorMessage, (Throwable)e);
                attributeResponse.setError(new ParameterImportResponse(datasetId, errorMessage));
            }
        }
        List<AttributeImportModel> children = model.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            log.debug("Children attributes: {}", StreamUtils.extractIds(children, AttributeImportModel::getId));
            children.forEach(childImportModel -> {
                String childAttributeName = childImportModel.getName();
                AttributeType type = childImportModel.getType();
                String childAttributeType = type.getName();
                AttributeImportConverter childConverter = this.factory.getAttributeImportConverter(childAttributeType);
                if (AttributeType.TEXT.equals((Object)type) || AttributeType.LIST.equals((Object)type) || AttributeType.DSL.equals((Object)type)) {
                    log.debug("Prepare parameter context for attribute: {}", (Object)childAttributeName);
                    this.prepareParameterContext((AttributeImportModel)childImportModel, context);
                }
                List<ParameterImportResponse> importErrors = childConverter.validate((AttributeImportModel)childImportModel, context);
                AttributeImportResponse childAttributeResponse = response.getAttributeResponse((AttributeImportModel)childImportModel);
                childAttributeResponse.setErrors(importErrors);
                log.debug("Start importing parameters for child attribute '{}'", (Object)childAttributeName);
                this.importAttributeParameters((AttributeImportModel)childImportModel, childConverter, context, response);
                context.clearParametersContext();
                log.debug("Finish importing parameters for child attribute '{}'", (Object)childAttributeName);
            });
        }
        log.debug("Finish importing parameters for attribute '{}'", (Object)attributeName);
    }

    private void prepareParameterContext(AttributeImportModel importModel, AttributeImportContext context) {
        Map<String, Set<UUID>> refDslDatasetsMap = context.getRefDslDatasetIdsMap();
        String datasetListReference = this.getDatasetListReference(importModel);
        Set<UUID> datasetIds = refDslDatasetsMap.get(datasetListReference);
        String attributeKey = importModel.getKey();
        Attribute attribute = context.getAttribute(attributeKey);
        UUID refAttributeId = attribute.getId();
        log.debug("Dataset ids: {}, reference attribute id: {}", datasetIds, (Object)refAttributeId);
        List<Parameter> parameters = this.parameterService.getByAttributeIdAndDatasetIds(refAttributeId, datasetIds);
        log.debug("Found parameters: {}", StreamUtils.extractIds(parameters, Identified::getId));
        context.setAttributeParameters(parameters);
    }

    private String getDatasetListReference(AttributeImportModel importModel) {
        AttributeType type = importModel.getType();
        if (AttributeType.DSL.equals((Object)type)) {
            return importModel.getDatasetListReference();
        }
        return importModel.getDatasetParameterValuesDslReference();
    }

    void validateDataSetsAreNotLocked(UUID targetDslId) {
        List<DataSet> dataSets = this.dataSetService.getLockedDataSets(targetDslId);
        if (Objects.nonNull(dataSets) && !dataSets.isEmpty()) {
            Map<String, UUID> map = dataSets.stream().collect(Collectors.toMap(DataSet::getName, DataSet::getId));
            String dslName = this.dataSetListService.getById(targetDslId).getName();
            String message = String.format("Failed to import DataSetList '%s' with id: '%s'. Reason: some datasets are locked: %s", dslName, targetDslId, map);
            log.error(message);
            throw new ImportFailedException(message);
        }
    }

    void validateImportFileSchema(UUID targetDslId, ListIterator<Map<Integer, String>> rowsIterator, AttributeImportContext context) {
        log.info("Start validating import file schema, target dataset list: {}", (Object)targetDslId);
        String emptyFileContentErrorMessage = "Failed to import data set list. Reason: empty import file content";
        if (!rowsIterator.hasNext()) {
            log.error(emptyFileContentErrorMessage);
            throw new ExcelImportEmptyExcelException();
        }
        Map<Integer, String> headingRow = rowsIterator.next();
        if (ImportUtils.isBlankRow(headingRow)) {
            log.error(emptyFileContentErrorMessage);
            throw new ExcelImportEmptyExcelException();
        }
        this.validateRequiredHeading(headingRow);
        Map<String, UUID> existedDslAttributesMap = this.getDslAttributesMap(targetDslId);
        while (rowsIterator.hasNext()) {
            Map<Integer, String> row = rowsIterator.next();
            if (ImportUtils.isBlankRow(row)) {
                log.debug("Skip blank row");
                continue;
            }
            String attributeName = ImportUtils.getAttributeName(row);
            log.debug("Attribute name: {}", (Object)attributeName);
            boolean isListRefNestedAttribute = attributeName.contains(" -> ");
            log.debug("Is list ref nested attribute: {}", (Object)isListRefNestedAttribute);
            boolean isAttributeExistsInDslSchema = existedDslAttributesMap.containsKey(attributeName);
            log.debug("Is attribute exists in DSL schema: {}", (Object)isAttributeExistsInDslSchema);
            boolean isAttributeChildExistsInDslSchema = context.getAttributesNameMap().containsKey(attributeName);
            log.debug("Is attribute child exists in DSL schema: {}", (Object)isAttributeExistsInDslSchema);
            if (!isAttributeExistsInDslSchema && !isListRefNestedAttribute) {
                log.error(String.format("Failed to import data set list: attribute '%s' doesn't exist in DSL schema", attributeName));
                throw new ExcelImportNotExistingAttributeException(attributeName);
            }
            if (!isAttributeChildExistsInDslSchema && isListRefNestedAttribute) {
                log.error(String.format("Failed to import child dsl : attribute '%s' doesn't exist in DSL schema", attributeName));
                throw new ExcelImportNotExistingChildAttributeException(attributeName);
            }
            AttributeType attributeType = this.validateAttributeTypeCells(row, attributeName, context);
            this.validateDslCellParameterValues(row, attributeName, attributeType, context);
        }
        log.info("Finish validating import file schema, target dataset list: {}", (Object)targetDslId);
    }

    private AttributeType validateAttributeTypeCells(Map<Integer, String> row, String attributeName, AttributeImportContext context) {
        String attributeTypeValue = ImportUtils.getAttributeType(row);
        log.debug("Attribute type value: {}", (Object)attributeTypeValue);
        boolean isSupportedAttributeType = supportedImportAttributeTypes.stream().anyMatch(attributeType -> attributeType.name().equalsIgnoreCase(attributeTypeValue));
        if (!isSupportedAttributeType) {
            log.error(String.format("Invalid attribute '%s' type: '%s'. Supported import types: %s", attributeName, attributeTypeValue, supportedImportAttributeTypes));
            throw new ImportExcelNotSupportedAttributeTypeException(attributeName, attributeTypeValue, supportedImportAttributeTypes);
        }
        boolean isAttrTypeEquals = context.getAttributesNameMap().get(attributeName).getAttributeType().getName().equalsIgnoreCase(attributeTypeValue);
        if (!isAttrTypeEquals) {
            log.error(String.format("The attribute '%s' with type '%s' is different compared to DSL", attributeName, attributeTypeValue));
            throw new ImportExcelNotEqualsAttributeTypeException(attributeName, attributeTypeValue);
        }
        return AttributeType.valueOf(attributeTypeValue);
    }

    private void validateDslCellParameterValues(Map<Integer, String> row, String attributeName, AttributeType attributeType, AttributeImportContext context) {
        boolean isDslAttributeType = AttributeType.DSL.equals((Object)attributeType);
        if (isDslAttributeType) {
            int lastColumn = row.size();
            for (int columnIndex = 0; columnIndex < lastColumn; ++columnIndex) {
                boolean isDatasetColumn;
                boolean bl = isDatasetColumn = columnIndex > 1;
                if (!isDatasetColumn) continue;
                String parameterValue = ImportUtils.getCellValue(row, columnIndex);
                log.debug("Parameter value: {}", (Object)parameterValue);
                if (StringUtils.isEmpty((Object)parameterValue)) continue;
                String idRefDslStr = context.getAttributesNameMap().get(attributeName).getTypeDataSetListId().toString();
                String parameterDsRefName = ImportUtils.getParameterDsRefName(parameterValue);
                if (context.containsRefDataset(idRefDslStr + UNDERSCORE + parameterDsRefName)) continue;
                String errorMessage = String.format("Provided referenced [%s], DS '%s', in attribute '%s' parameter doesn't exist", parameterValue, parameterDsRefName, attributeName);
                if (Objects.nonNull(parameterDsRefName)) {
                    log.error(errorMessage);
                    throw new ExcelImportNotExistingRefParameterException(parameterValue, parameterDsRefName, attributeName);
                }
                log.warn(errorMessage);
            }
        }
    }

    AttributeImportContext prepareImportContext(UUID targetProjectId, UUID targetDslId, ListIterator<Map<Integer, String>> rowsIterator, boolean isJavers) {
        log.info("Start preparing attribute import context with versioning Javers = '{}', target dataset list: {}", (Object)isJavers, (Object)targetDslId);
        AttributeImportContext importContext = new AttributeImportContext();
        importContext.setJavers(isJavers);
        importContext.setTargetDslId(targetDslId);
        Map<Integer, String> headingRow = rowsIterator.next();
        int headingRowSize = headingRow.size();
        Map<String, Integer> existedDatasetsIndexMap = this.getExistedDatasetsCellIndexMap(headingRow);
        importContext.setDatasetsCellIndexMap(existedDatasetsIndexMap);
        log.debug("Existed datasets: {}", existedDatasetsIndexMap.keySet());
        List<DataSet> dslDatasets = this.dataSetService.getByDataSetListId(targetDslId);
        importContext.setDatasets(dslDatasets);
        this.createNotExistedImportedDatasets(importContext);
        log.debug("Existed DSL datasets: {}", StreamUtils.extractIds(dslDatasets, DataSet::getId));
        List<Attribute> attributes = this.attributeService.getByDataSetListId(targetDslId);
        importContext.setAttributes(attributes);
        log.debug("Existed DSL attributes: {}", StreamUtils.extractIds(attributes, Attribute::getId));
        this.checkNames(targetProjectId);
        List<DataSetList> projectDatasetLists = this.dataSetListService.getByVisibilityAreaId(targetProjectId);
        Map<String, DataSetList> projectDslMap = StreamUtils.toEntityMap(projectDatasetLists, DataSetList::getName);
        log.debug("Existed dataset lists: {}", StreamUtils.extractIds(projectDatasetLists, DataSetList::getId));
        HashMap<String, Set<String>> referencedDslDatasetsMap = new HashMap<String, Set<String>>();
        this.prepareAttributesMap(rowsIterator, referencedDslDatasetsMap, importContext, headingRowSize);
        Set<UUID> refDatasetListIds = referencedDslDatasetsMap.keySet().stream().map(projectDslMap::get).map(DataSetList::getId).collect(Collectors.toSet());
        log.debug("Existed dataset list ids: {}", refDatasetListIds);
        List<DataSet> refDslDatasets = this.dataSetService.getByDataSetListIdIn(refDatasetListIds);
        importContext.setRefDatasets(refDslDatasets);
        log.debug("Existed ref DSL datasets: {}", StreamUtils.extractIds(refDslDatasets, DataSet::getId));
        Map<String, Set<UUID>> refDslDatasetsMap = this.getRefDslDatasetsMap(referencedDslDatasetsMap, importContext);
        importContext.setRefDslDatasetIdsMap(refDslDatasetsMap);
        List<AttributeKey> overlaps = this.attributeService.getAttributeKeysByDatasetListId(targetDslId);
        importContext.setOverlaps(overlaps);
        log.info("Finish preparing attribute import context, target dataset list: {}", (Object)targetDslId);
        return importContext;
    }

    private void checkNames(UUID visibilityAreaId) {
        this.dataSetListService.checkDslNames(visibilityAreaId);
    }

    Map<String, Set<UUID>> getRefDslDatasetsMap(Map<String, Set<String>> referencedDslDatasetsMap, AttributeImportContext importContext) {
        log.debug("Get reference DSL datasets map");
        HashMap<String, Set<UUID>> refDslDatasetsMap = new HashMap<String, Set<UUID>>();
        Map<String, UUID> refDatasetsNameIdMap = importContext.getRefDatasetsNameIdMap();
        referencedDslDatasetsMap.forEach((dslName, dslDatasetNames) -> {
            Set dslDatasetIds = dslDatasetNames.stream().map(datasetName -> {
                String datasetKey = ImportUtils.getDatasetKey(dslName, datasetName);
                log.debug("Dataset key: {}", (Object)datasetKey);
                return (UUID)refDatasetsNameIdMap.get(datasetKey);
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            log.debug("Put value: {}={}", dslName, dslDatasetIds);
            refDslDatasetsMap.put((String)dslName, dslDatasetIds);
        });
        return refDslDatasetsMap;
    }

    private void prepareAttributesMap(ListIterator<Map<Integer, String>> rowsIterator, Map<String, Set<String>> refDslDatasetsMap, AttributeImportContext importContext, int headingRowSize) {
        log.debug("Get referenced dataset list names");
        while (rowsIterator.hasNext()) {
            Map<Integer, String> row = rowsIterator.next();
            if (ImportUtils.isBlankRow(row)) continue;
            String attributeTypeValue = ImportUtils.getAttributeType(row);
            String attributeName = ImportUtils.getAttributeName(row);
            AttributeType attributeType = AttributeType.valueOf(attributeTypeValue);
            log.debug("Attribute type: {}", (Object)attributeType);
            boolean isDslAttributeType = AttributeType.DSL.equals((Object)attributeType);
            if (!isDslAttributeType) continue;
            for (int idxRow = 0; idxRow < headingRowSize; ++idxRow) {
                String parameterValue = ImportUtils.getCellValue(row, idxRow);
                log.debug("Parameter value: {}", (Object)parameterValue);
                boolean isDatasetColumn = idxRow > 1;
                log.debug("Is dataset column: {}", (Object)isDatasetColumn);
                boolean isDslSubAttribute = ImportUtils.isArrowDelimiterPresent(attributeName);
                log.debug("Is DSL reference attribute: {}", (Object)isDslSubAttribute);
                boolean isParameterContainDslPrefix = ImportUtils.isArrowDelimiterPresent(parameterValue);
                if (!isDatasetColumn) continue;
                String parameterDsRefName = isParameterContainDslPrefix ? ImportUtils.getParameterDsRefName(parameterValue) : parameterValue;
                Attribute attribute = importContext.getAttribute(attributeName);
                DataSetList dataSetList = attribute.getTypeDataSetList();
                String parameterDslRefName = dataSetList.getName();
                List<Attribute> refAttributes = dataSetList.getAttributes();
                importContext.setAttributes(attributeName, refAttributes);
                if (Objects.nonNull(parameterDsRefName)) {
                    refDslDatasetsMap.computeIfAbsent(parameterDslRefName, param -> new HashSet()).add(parameterDsRefName);
                }
                log.debug("DSL ref name: {}, DS ref name: {}", (Object)parameterDslRefName, (Object)parameterDsRefName);
            }
        }
        log.debug("Result referenced dataset list datasets map: {}", refDslDatasetsMap);
    }

    void createNotExistedImportedDatasets(AttributeImportContext importContext) {
        UUID targetDslId = importContext.getTargetDslId();
        Map<String, UUID> dslDatasetsNameIdMap = importContext.getDatasetsNameIdMap();
        Set<String> sheetDslDatasets = importContext.getDatasetsCellIndexMap().keySet();
        log.debug("Create not existed imported datasets for DSL with id '{}', file dataset names: '{}'", (Object)targetDslId, sheetDslDatasets);
        sheetDslDatasets.forEach(datasetName -> {
            boolean isImportedDatasetNotExist;
            boolean bl = isImportedDatasetNotExist = !dslDatasetsNameIdMap.containsKey(datasetName);
            if (isImportedDatasetNotExist) {
                try {
                    log.debug("Dataset '{}' not exist in database, creating new dataset entity", datasetName);
                    DataSet dataSet = this.dataSetService.createDsSelectJavers((String)datasetName, targetDslId, importContext.isJavers());
                    UUID dataSetId = dataSet.getId();
                    importContext.setDataset(dataSet);
                    log.debug("Dataset '{}' has been created, database id: '{}'", datasetName, (Object)dataSetId);
                }
                catch (DataSetServiceException e) {
                    String errorMessage = "Failed to create not existed imported dataset: " + datasetName;
                    log.error(errorMessage);
                    throw new ImportFailedException(errorMessage);
                }
            }
        });
        log.debug("Finish creating not existed imported datasets for DSL with id '{}'", (Object)targetDslId);
    }

    Map<String, UUID> getDslAttributesMap(UUID targetDslId) {
        log.debug("Get attributes map for dataset list with id: {}", (Object)targetDslId);
        List<Attribute> dslAttributes = this.attributeService.getByDataSetListId(targetDslId);
        if (!CollectionUtils.isEmpty(dslAttributes)) {
            log.debug("Found attributes: {}", StreamUtils.extractIds(dslAttributes, Attribute::getId));
            return StreamUtils.toNameIdEntityMap(dslAttributes, Attribute::getName, Attribute::getId);
        }
        return Collections.emptyMap();
    }

    Map<String, Integer> getExistedDatasetsCellIndexMap(Map<Integer, String> headingRow) {
        log.debug("Get existed datasets cell index map from heading row");
        LinkedHashMap<String, Integer> datasetsCellIndexMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry<Integer, String> cell : headingRow.entrySet()) {
            String datasetName = cell.getValue();
            boolean isDatasetNameNotEmpty = !datasetName.isEmpty();
            boolean isNotRequiredHeading = !requiredHeadingIndexesMap.containsKey(datasetName);
            log.debug("Processed dataset name cell value: {}", (Object)datasetName);
            if (!isDatasetNameNotEmpty || !isNotRequiredHeading) continue;
            int datasetColumnIndex = cell.getKey();
            log.debug("Put dataset '{}' with column index '{}' into map", (Object)datasetName, (Object)datasetColumnIndex);
            datasetsCellIndexMap.put(datasetName, datasetColumnIndex);
        }
        if (datasetsCellIndexMap.isEmpty()) {
            String errorMessage = "Imported dataset columns are absent";
            log.error(errorMessage);
            throw new ImportFailedException(errorMessage);
        }
        log.debug("Result datasets cell index map: {}", datasetsCellIndexMap);
        return datasetsCellIndexMap;
    }

    private void validateRequiredHeading(Map<Integer, String> headingRow) {
        log.debug("Start validating file required headings, expected: {}", requiredHeadingIndexesMap.keySet());
        requiredHeadingIndexesMap.forEach((requiredHeader, requiredHeaderIndex) -> {
            boolean isRowHeaderValueDoesntMatch;
            boolean isRowHeaderCellIsTrue = headingRow.containsKey(requiredHeaderIndex);
            if (!isRowHeaderCellIsTrue) {
                String errorMessage = String.format("Required heading '%s' is absent", requiredHeader);
                log.error(errorMessage);
                throw new ImportFailedException(errorMessage);
            }
            String rowHeader = (String)headingRow.get(requiredHeaderIndex);
            log.debug("Row header value: {}", (Object)rowHeader);
            boolean bl = isRowHeaderValueDoesntMatch = !requiredHeader.equals(rowHeader);
            if (isRowHeaderValueDoesntMatch) {
                String errorMessage = String.format("Required heading '%s' has incorrect name", requiredHeader);
                log.error(errorMessage);
                throw new ImportFailedException(errorMessage);
            }
        });
        log.debug("Finish required headings validation");
    }

    public DatasetListImportService(DataSetListImportExportFactory factory, JpaDataSetListService dataSetListService, JpaDataSetService dataSetService, JpaAttributeService attributeService, ParameterService parameterService, ClearCacheService clearCacheService) {
        this.factory = factory;
        this.dataSetListService = dataSetListService;
        this.dataSetService = dataSetService;
        this.attributeService = attributeService;
        this.parameterService = parameterService;
        this.clearCacheService = clearCacheService;
    }
}

