/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.macros;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.EvalContextImpl;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.cache.Cache;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.macros.EvaluateDsParamStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateDsParamStrategyImpl
implements EvaluateDsParamStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluateDsParamStrategyImpl.class);
    protected final MacroRegistry registry;
    protected final AliasWrapperService wrapperService;
    protected final Cache cache;
    private final boolean acceptFails;

    public EvaluateDsParamStrategyImpl(@Nonnull MacroRegistry registry, @Nonnull AliasWrapperService wrapperService, @Nonnull Cache cache, boolean acceptFails) {
        this.registry = registry;
        this.wrapperService = wrapperService;
        this.cache = cache;
        this.acceptFails = acceptFails;
    }

    @Override
    @Nonnull
    public Optional<String> apply(@Nonnull OverlapItem.Reachable target) {
        Optional<Parameter> parameterOpt = target.getParameter();
        if (!parameterOpt.isPresent()) {
            return Optional.empty();
        }
        Parameter parameter = parameterOpt.get();
        Optional<String> valueOpt = target.getValue();
        if (!valueOpt.isPresent()) {
            return Optional.empty();
        }
        String value = valueOpt.get();
        if (value.isEmpty()) {
            return Optional.of(value);
        }
        EvalContextImpl context = this.createContext(target.getSourceDs().getDataSetList(), target.getSourceDs(), target.getFoundByAttrPath(), target.getAttribute());
        try {
            return Optional.of(context.evaluate(target, parameter, value));
        }
        catch (CtxEvalException e) {
            StringBuilder messageBuilder = new StringBuilder("Error during evaluating [").append(e.getSource()).append("]");
            if (!this.acceptFails || Strings.isNullOrEmpty((String)e.getMessage())) {
                String message = messageBuilder.toString();
                LOG.error(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
            return Optional.of(Utils.appendFriendlyMessage(messageBuilder, e).toString());
        }
    }

    @Nonnull
    protected EvalContextImpl createContext(@Nonnull DataSetList dsl, @Nonnull DataSet ds, @Nonnull List<Attribute> pathFromParent, @Nullable Attribute targetAttrFromParent) {
        return new EvalContextImpl(null, this.registry, this.wrapperService, this.cache, dsl, ds, true, pathFromParent, targetAttrFromParent);
    }

    @Override
    @Nonnull
    public String evaluateText(@Nonnull DataSet ds, @Nonnull String text) {
        if (text.isEmpty()) {
            return text;
        }
        try {
            return this.createContext(ds.getDataSetList(), ds, Collections.emptyList(), null).evaluate(text);
        }
        catch (CtxEvalException e) {
            StringBuilder messageBuilder = new StringBuilder("Error during evaluating [").append(e.getSource()).append("]");
            if (!this.acceptFails || Strings.isNullOrEmpty((String)e.getMessage())) {
                String message = messageBuilder.toString();
                LOG.error(message, (Throwable)e);
                throw new IllegalArgumentException(message, e);
            }
            return Utils.appendFriendlyMessage(messageBuilder, e).toString();
        }
    }
}

