/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.macros.schange;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.cache.NoCache;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;
import org.qubership.atp.dataset.service.direct.macros.EvaluateDsParamStrategyImpl;
import org.qubership.atp.dataset.service.direct.macros.schange.ChangeParameter;
import org.qubership.atp.dataset.service.direct.macros.schange.EvaluateDsStructureStrategy;
import org.qubership.atp.dataset.service.direct.macros.schange.MultiplicationEntry;
import org.qubership.atp.dataset.service.direct.macros.schange.MultiplicationMixin;
import org.qubership.atp.dataset.utils.Utils;

public class EvaluateDsStructureStrategyImpl
implements EvaluateDsStructureStrategy {
    private final DataSetListRepository dslRepo;
    private final DataSetRepository dsRepo;
    private final AliasWrapperService aliasWrapperService;
    private final MacroRegistry registry;

    public EvaluateDsStructureStrategyImpl(DataSetListRepository dslRepo, DataSetRepository dsRepo, AliasWrapperService aliasWrapperService, MacroRegistry registry) {
        this.dslRepo = dslRepo;
        this.dsRepo = dsRepo;
        this.aliasWrapperService = aliasWrapperService;
        this.registry = registry;
    }

    @Override
    @Nonnull
    public Stream<DataSet> getDataSets(@Nonnull DataSetList parent, @Nonnull Stream<DataSet> children) {
        Collection<Attribute> structureChanges = parent.getAttributes(AttributeType.CHANGE);
        if (structureChanges.isEmpty()) {
            return children;
        }
        return children.flatMap(ds -> this.applyStructureChanges(structureChanges, parent, (DataSet)ds));
    }

    @Override
    public DataSet getDataSetById(MixInId dataSet) {
        List<MultiplicationEntry> combination;
        DataSet ds = this.dsRepo.getById(dataSet.getUuid());
        Preconditions.checkNotNull((Object)ds, (Object)("Data set not found by id " + dataSet));
        if (dataSet.getMetadata() == null) {
            return ds;
        }
        DataSetList dsl = ds.getDataSetList();
        Collection<Attribute> structureChanges = dsl.getAttributes(AttributeType.CHANGE);
        try {
            combination = ChangeParameter.getCombination(ChangeParameter.getChanges(structureChanges, ds), dataSet.getMetadata());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not find a combination for " + dataSet, e);
        }
        return this.applyStructureChanges(dsl, ds, combination);
    }

    @Nonnull
    private Stream<DataSet> applyStructureChanges(@Nonnull Collection<Attribute> structureChanges, DataSetList dsl, DataSet ds) {
        Stream<ChangeParameter> changes = ChangeParameter.getChanges(structureChanges, ds);
        Stream<List<MultiplicationEntry>> combinations = ChangeParameter.getCombinations(changes);
        return combinations.map(combination -> this.applyStructureChanges(dsl, ds, (List<MultiplicationEntry>)combination));
    }

    private DataSet applyStructureChanges(DataSetList dsl, DataSet ds, List<MultiplicationEntry> combination) {
        DataSet dataSet = MultiplicationMixin.create(combination, this.dslRepo, this.dsRepo, dsl, ds);
        String name = this.evaluateName(dsl, dataSet);
        dataSet.setName(name);
        return dataSet;
    }

    private String evaluateName(DataSetList dsl, DataSet dataSet) {
        String name = Utils.replacePlaceholders((String)dataSet.getName(), macros -> "#REF_THIS(" + macros + ")");
        name = this.aliasWrapperService.wrapToAlias(name, dsl.getVisibilityArea(), dsl);
        EvaluateDsParamStrategyImpl macrosEval = new EvaluateDsParamStrategyImpl(this.registry, this.aliasWrapperService, NoCache.INSTANCE, false);
        return macrosEval.evaluateText(dataSet, name);
    }
}

