/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import org.junit.jupiter.api.Assertions;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeKey
extends AbstractObjectWrapper<AttributeKeyEntity> {
    private static final Logger log = LoggerFactory.getLogger(AttributeKey.class);
    private static final long serialVersionUID = 3769738483534840381L;
    private Parameter cachedParameter = null;

    public AttributeKey(AttributeKeyEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((AttributeKeyEntity)this.entity).getId();
    }

    public DataSetList getDataSetList() {
        return modelsProvider.getDataSetList(((AttributeKeyEntity)this.entity).getDataSetList());
    }

    public String getKey() {
        return ((AttributeKeyEntity)this.entity).getKey();
    }

    public DataSet getDataSet() {
        return modelsProvider.getDataSet(((AttributeKeyEntity)this.entity).getDataSet());
    }

    public UUID getDataSetId() {
        return ((AttributeKeyEntity)this.entity).getDataSet().getId();
    }

    public Attribute getAttribute() {
        return modelsProvider.getAttribute(((AttributeKeyEntity)this.entity).getAttribute());
    }

    public UUID getAttributeId() {
        return ((AttributeKeyEntity)this.entity).getAttribute().getId();
    }

    public String getName() {
        return ((AttributeKeyEntity)this.entity).getName();
    }

    public AttributeTypeName getAttributeType() {
        return this.getAttribute().getAttributeType();
    }

    public Parameter getParameter() {
        if (this.cachedParameter == null) {
            try {
                ParameterEntity singleResult = (ParameterEntity)entityManager.createNativeQuery("SELECT * from parameter p where p.attribute_id = ?1", ParameterEntity.class).setParameter(1, (Object)this.getId()).getSingleResult();
                this.cachedParameter = modelsProvider.getParameter(singleResult);
            }
            catch (NoResultException e) {
                return null;
            }
        }
        return this.cachedParameter;
    }

    public List<UUID> getPath() {
        String[] splitResult;
        LinkedList<UUID> result = new LinkedList<UUID>();
        for (String splitPart : splitResult = this.getKey().split("_")) {
            result.add(UUID.fromString(splitPart));
        }
        return result;
    }

    public String getPathNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (UUID attributeId : this.getPath()) {
            names.add(modelsProvider.getAttributeById(attributeId).getName());
        }
        return String.join((CharSequence)".", names);
    }

    public void setKey(String key) {
        ((AttributeKeyEntity)this.entity).setKey(key);
    }

    public void setAttribute(UUID attributeId) {
        Attribute attribute = modelsProvider.getAttributeById(attributeId);
        Assertions.assertNotNull((Object)attribute, (String)("Cannot find copy of the Attribute by id: " + attributeId + ", old AttrId: " + this.getAttributeId()));
        ((AttributeKeyEntity)this.entity).setAttribute((AttributeEntity)attribute.getEntity());
    }

    public void setDataSet(UUID dataSetId) {
        DataSet dataSet = modelsProvider.getDataSetById(dataSetId);
        Assertions.assertNotNull((Object)dataSet, (String)("Cannot find Data Set by id " + dataSetId));
        ((AttributeKeyEntity)this.entity).setDataSet((DataSetEntity)dataSet.getEntity());
    }

    public void setDataSetList(UUID dataSetListId) {
        DataSetList dataSetList = modelsProvider.getDataSetListById(dataSetListId);
        Assertions.assertNotNull((Object)dataSetList, (String)("Cannot find Data Set List by id " + dataSetListId));
        ((AttributeKeyEntity)this.entity).setDataSetList((DataSetListEntity)dataSetList.getEntity());
    }

    @Override
    public void beforeRemove() {
        this.getParameter().remove();
    }
}

