/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dsllazyload.dsl;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dsllazyload.dsl.ParameterFlat;

public class AttributeFlat {
    private UUID id;
    private String name;
    private AttributeTypeName type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean containsAttributes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ParameterFlat> parameters = new LinkedList<ParameterFlat>();

    public AttributeFlat(Attribute attribute, List<UUID> dataSetIds, DataSetParameterProvider parameterProvider) {
        this.id = attribute.getId();
        this.name = attribute.getName();
        this.type = attribute.getAttributeType();
        if (attribute.getAttributeType().equals((Object)AttributeTypeName.DSL)) {
            DataSetList typeDataSetList = attribute.getTypeDataSetList();
            this.containsAttributes = typeDataSetList.getAttributesCount() > 0;
        }
        List<Parameter> parametersModels = attribute.getParameters();
        int column = 0;
        for (UUID dadaSetId : dataSetIds) {
            Parameter parameterWithValue = null;
            for (Parameter parameter : parametersModels) {
                if (!dadaSetId.equals(parameter.getDataSetId())) continue;
                parameterWithValue = parameter;
                break;
            }
            if (parameterWithValue != null) {
                if (this.type == AttributeTypeName.FILE && parameterWithValue.getFileValueId() == null) continue;
                this.parameters.add(new ParameterFlat(attribute, parameterWithValue, column, parameterProvider));
            }
            ++column;
        }
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public Boolean getContainsAttributes() {
        return this.containsAttributes;
    }

    public List<ParameterFlat> getParameters() {
        return this.parameters;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(AttributeTypeName type) {
        this.type = type;
    }

    public void setContainsAttributes(Boolean containsAttributes) {
        this.containsAttributes = containsAttributes;
    }

    public void setParameters(List<ParameterFlat> parameters) {
        this.parameters = parameters;
    }
}

