/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.facade;

import com.google.common.base.Preconditions;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.GridFsService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.jpa.impl.MetricsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;

@Service
public class AttachmentControllerFacade {
    private static final Logger log = LoggerFactory.getLogger(AttachmentControllerFacade.class);
    private final GridFsService gridFsService;
    private final ParameterService parameterService;
    private final ConcurrentModificationService concurrentModificationService;
    private final MetricsService metricsService;

    public ResponseEntity<InputStreamResource> getAttachmentByParameterId(UUID parameterUuid) {
        UUID projectId = ((Parameter)this.parameterService.get(parameterUuid)).getDataSet().getDataSetList().getVisibilityArea().getId();
        Optional<InputStream> optional = this.gridFsService.get(parameterUuid);
        FileData info = this.gridFsService.getFileInfo(parameterUuid);
        if (!optional.isPresent()) {
            return ResponseEntity.noContent().build();
        }
        InputStreamResource inputStreamResource = new InputStreamResource(optional.get());
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(info.getFileName(), StandardCharsets.UTF_8).build();
        GridFSFile attachment = this.gridFsService.getGridFsFile(parameterUuid);
        this.metricsService.registerMetricFileSize(attachment.getLength(), projectId, "atp.data.sets.max.size.download.file.per.project.total");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)info.getContentType())).header("Content-Disposition", new String[]{contentDisposition.toString()})).body((Object)inputStreamResource);
    }

    public ResponseEntity<InputStreamResource> getAttachmentByAttributeIdAndDatasetId(UUID attributeId, UUID datasetId) {
        Parameter parameter = this.parameterService.getByDataSetIdAttributeId(datasetId, attributeId);
        Preconditions.checkNotNull((Object)parameter.getId(), (Object)"Could not get parameters id");
        return this.getAttachmentByParameterId(parameter.getId());
    }

    public FileData uploadByParameterId(UUID parameterUuid, String contentType, String fileName, InputStream file) {
        UUID projectId = ((Parameter)this.parameterService.get(parameterUuid)).getDataSet().getDataSetList().getVisibilityArea().getId();
        FileData fileData = this.parameterService.upload(parameterUuid, contentType, fileName, file);
        GridFSFile attachment = this.gridFsService.getGridFsFile(parameterUuid);
        this.metricsService.registerMetricFileSize(attachment.getLength(), projectId, "atp.data.sets.max.size.upload.file.per.project.total");
        return fileData;
    }

    public ResponseEntity<FileData> uploadByAttributeIdAndDatasetId(UUID attributeId, UUID datasetId, String contentType, String fileName, List<UUID> attrPathIds, UUID dataSetListId, Long modifiedWhen, InputStream file) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        FileData fileData = this.parameterService.upload(datasetId, attributeId, attrPathIds, contentType, fileName, file);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)fileData) : ResponseEntity.ok((Object)fileData);
    }

    public ResponseEntity<Void> deleteByParameterId(@PathVariable(value="parameterUuid") UUID parameterId) {
        this.parameterService.clearAttachment(parameterId);
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<Void> deleteByAttributeIdAndDatasetId(UUID attributeId, UUID datasetId) {
        Parameter parameter = this.parameterService.getByDataSetIdAttributeId(datasetId, attributeId);
        Preconditions.checkNotNull((Object)parameter.getId(), (Object)"Could not get parameters id");
        return this.deleteByParameterId(parameter.getId());
    }

    public AttachmentControllerFacade(GridFsService gridFsService, ParameterService parameterService, ConcurrentModificationService concurrentModificationService, MetricsService metricsService) {
        this.gridFsService = gridFsService;
        this.parameterService = parameterService;
        this.concurrentModificationService = concurrentModificationService;
        this.metricsService = metricsService;
    }
}

