/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javers.core.Javers;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemResponseDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.PageInfoDto;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.service.JaversHistoryService;
import org.qubership.atp.dataset.versioning.service.impl.JaversHistoryCacheableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JaversHistoryServiceImpl
implements JaversHistoryService {
    private static final Logger log = LoggerFactory.getLogger(JaversHistoryServiceImpl.class);
    private final Javers javers;
    private final JaversHistoryCacheableService javersHistoryCacheableService;
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    @Autowired
    public JaversHistoryServiceImpl(Javers javers, JaversHistoryCacheableService javersHistoryCacheableService) {
        this.javers = javers;
        this.javersHistoryCacheableService = javersHistoryCacheableService;
    }

    @Override
    public HistoryItemResponseDto getAllHistory(UUID id, Integer offset, Integer limit) {
        log.debug("Retrieving history of DSL. ID: {}, offset: {}, limit: {}", new Object[]{id, offset, limit});
        HistoryItemResponseDto response = new HistoryItemResponseDto();
        response.setPageInfo(this.getPageInfo(id, offset, limit));
        response.setHistoryItems(this.createHistoryItems(id, offset, limit));
        log.debug("History retrieval completed. Response: {}", (Object)response);
        return response;
    }

    private List<HistoryItemDto> createHistoryItems(UUID id, Integer offset, Integer limit) {
        ArrayList<HistoryItemDto> historyItems = new ArrayList<HistoryItemDto>(limit);
        List shadows = this.javers.findShadows(this.getQuery(id, offset, limit));
        Optional<Shadow<DataSetListSnapshot>> beforeMainPack = this.getShadowBeforeMainPack(id, offset, limit);
        for (int i = 0; i < shadows.size(); ++i) {
            Shadow shadow = (Shadow)shadows.get(i);
            Optional<Object> previousShadow = i == shadows.size() - 1 ? beforeMainPack : Optional.of((Shadow)shadows.get(i + 1));
            log.trace("Comparing two DSL history shadows. Old: {}, new: {}", previousShadow, (Object)shadow);
            HistoryItemDto historyItemDto = this.processTwoShadows(id, (Shadow<DataSetListSnapshot>)shadow, previousShadow);
            if (!this.isDataSetNameFound(historyItemDto)) continue;
            historyItems.add(historyItemDto);
        }
        this.fillHistoryMetadata(id, historyItems);
        return historyItems;
    }

    private Optional<Shadow<DataSetListSnapshot>> getShadowBeforeMainPack(UUID id, Integer offset, Integer limit) {
        List shadows = this.javers.findShadows(this.getQuery(id, offset + limit, 1));
        if (CollectionUtils.isEmpty((Collection)shadows)) {
            return Optional.empty();
        }
        return Optional.of((Shadow)shadows.get(0));
    }

    private HistoryItemDto processTwoShadows(UUID id, Shadow<DataSetListSnapshot> actualShadow, Optional<Shadow<DataSetListSnapshot>> oldShadow) {
        boolean isRestored;
        boolean isDslCreated = !oldShadow.isPresent();
        boolean isDlsDeleted = ((DataSetListSnapshot)actualShadow.get()).getId() == null;
        boolean bl = isRestored = actualShadow.getCommitMetadata().getProperties().get("RestoredTo") != null;
        HistoryItemDto historyItem = isDslCreated ? this.dslCreatedChanges() : (isDlsDeleted ? this.dslDeletedChanges() : (isRestored ? this.dslRestoredChanges(Integer.valueOf((String)actualShadow.getCommitMetadata().getProperties().get("RestoredTo"))) : this.javersHistoryCacheableService.compareTwoShadows(actualShadow, oldShadow.get())));
        historyItem.setCommitId(actualShadow.getCommitMetadata().getId().valueAsNumber());
        if (this.isDataSetNameFound(historyItem)) {
            historyItem.setModifiedWhen(actualShadow.getCommitMetadata().getCommitDate().format(DATE_FORMATTER));
            historyItem.setModifiedBy(actualShadow.getCommitMetadata().getAuthor());
        }
        return historyItem;
    }

    private boolean isDataSetNameFound(HistoryItemDto historyItemDto) {
        return !"*NotFoundNameDS*".equalsIgnoreCase(historyItemDto.getDataSet());
    }

    private HistoryItemDto dslCreatedChanges() {
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.DSL_ADDED.toString());
        log.trace("DSL was created at current history shadow.");
        return historyItem;
    }

    private HistoryItemDto dslDeletedChanges() {
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.DSL_CHANGED.toString());
        log.trace("DSL was deleted at current history shadow.");
        return historyItem;
    }

    private HistoryItemDto dslRestoredChanges(Integer revisionId) {
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.RESTORED.toString(revisionId));
        log.trace("DSL was restored to revision {}.", (Object)revisionId);
        return historyItem;
    }

    private void fillHistoryMetadata(UUID id, List<HistoryItemDto> historyItemDtoList) {
        List<BigDecimal> bigDecimals = historyItemDtoList.stream().map(HistoryItemDto::getCommitId).collect(Collectors.toList());
        List<CdoSnapshot> cdoSnapshots = this.getVersionOfShadows(id, bigDecimals);
        historyItemDtoList.forEach(historyItemDto -> {
            Optional<CdoSnapshot> snapshot = cdoSnapshots.stream().filter(cdoSnapshot -> cdoSnapshot.getCommitId().valueAsNumber().equals(historyItemDto.getCommitId())).findAny();
            snapshot.ifPresent(cdoSnapshot -> historyItemDto.setVersion((int)cdoSnapshot.getVersion()));
        });
    }

    private List<CdoSnapshot> getVersionOfShadows(UUID id, List<BigDecimal> commitIds) {
        JqlQuery query = this.getQuery(id, commitIds);
        return this.javers.findSnapshots(query);
    }

    private PageInfoDto getPageInfo(UUID id, Integer offset, Integer limit) {
        PageInfoDto pageInfo = new PageInfoDto();
        pageInfo.setOffset(offset);
        pageInfo.setLimit(limit);
        List shadows = this.javers.findShadows(this.getQuery(id));
        int countOfShadows = shadows.size();
        pageInfo.setItemsTotalCount(countOfShadows);
        return pageInfo;
    }

    private JqlQuery getQuery(UUID id, Integer offset, Integer limit) {
        return QueryBuilder.byInstanceId((Object)id, DataSetListSnapshot.class).withNewObjectChanges().skip(offset.intValue()).limit(limit.intValue()).build();
    }

    private JqlQuery getQuery(UUID id, CommitId commitId) {
        return QueryBuilder.byInstanceId((Object)id, DataSetListSnapshot.class).withCommitId(commitId).build();
    }

    private JqlQuery getQuery(UUID id, List<BigDecimal> commitId) {
        return QueryBuilder.byInstanceId((Object)id, DataSetListSnapshot.class).withCommitIds(commitId).build();
    }

    private JqlQuery getQuery(UUID id) {
        return QueryBuilder.byInstanceId((Object)id, DataSetListSnapshot.class).withNewObjectChanges().build();
    }
}

