/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.azure;

import com.hazelcast.azure.AzureAddress;
import com.hazelcast.azure.AzureNetworkInterface;
import com.hazelcast.azure.RestClient;
import com.hazelcast.azure.Tag;
import com.hazelcast.azure.Utils;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

class AzureComputeApi {
    static final String API_VERSION = "2018-08-01";
    static final String API_VERSION_SCALE_SET = "2018-06-01";
    private static final String AZURE_API_ENDPOINT = "https://management.azure.com";
    private final String endpoint;

    AzureComputeApi() {
        this.endpoint = AZURE_API_ENDPOINT;
    }

    AzureComputeApi(String endpoint) {
        this.endpoint = endpoint;
    }

    Collection<AzureAddress> instances(String subscriptionId, String resourceGroup, String scaleSet, Tag tag, String accessToken) {
        String privateIpResponse = RestClient.create(this.urlForPrivateIpList(subscriptionId, resourceGroup, scaleSet)).withHeader("Authorization", String.format("Bearer %s", accessToken)).get();
        Map<String, AzureNetworkInterface> networkInterfaces = this.parsePrivateIpResponse(privateIpResponse);
        String publicIpResponse = RestClient.create(this.urlForPublicIpList(subscriptionId, resourceGroup, scaleSet)).withHeader("Authorization", String.format("Bearer %s", accessToken)).get();
        Map<String, String> publicIpMap = this.parsePublicIpResponse(publicIpResponse);
        LinkedHashSet<AzureAddress> addresses = new LinkedHashSet<AzureAddress>(networkInterfaces.size());
        for (AzureNetworkInterface anInterface : networkInterfaces.values()) {
            if (tag != null && !anInterface.hasTag(tag)) continue;
            addresses.add(new AzureAddress(anInterface.getPrivateIp(), publicIpMap.get(anInterface.getPublicIpId())));
        }
        return addresses;
    }

    private String urlForPrivateIpList(String subscriptionId, String resourceGroup, String scaleSet) {
        if (Utils.isEmpty(scaleSet)) {
            return String.format("%s/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Network/networkInterfaces?api-version=%s", this.endpoint, subscriptionId, resourceGroup, API_VERSION);
        }
        return String.format("%s/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Compute/virtualMachineScaleSets/%s/networkInterfaces?api-version=%s", this.endpoint, subscriptionId, resourceGroup, scaleSet, API_VERSION_SCALE_SET);
    }

    private Map<String, AzureNetworkInterface> parsePrivateIpResponse(String response) {
        HashMap<String, AzureNetworkInterface> interfaces = new HashMap<String, AzureNetworkInterface>();
        for (JsonValue item : AzureComputeApi.toJsonArray(Json.parse(response).asObject().get("value"))) {
            HashSet<Tag> tagList = new HashSet<Tag>();
            JsonObject tags = AzureComputeApi.toJsonObject(item.asObject().get("tags"));
            for (String key : tags.asObject().names()) {
                tagList.add(new Tag(key, tags.asObject().getString(key, null)));
            }
            JsonObject properties = item.asObject().get("properties").asObject();
            if (properties.get("virtualMachine") == null) continue;
            for (JsonValue ipConfiguration : AzureComputeApi.toJsonArray(properties.get("ipConfigurations"))) {
                JsonObject ipProps = ipConfiguration.asObject().get("properties").asObject();
                String privateIp = ipProps.getString("privateIPAddress", null);
                String publicIpId = AzureComputeApi.toJsonObject(ipProps.get("publicIPAddress")).getString("id", null);
                if (Utils.isEmpty(publicIpId)) continue;
                interfaces.put(publicIpId, new AzureNetworkInterface(privateIp, publicIpId, tagList));
            }
        }
        return interfaces;
    }

    private String urlForPublicIpList(String subscriptionId, String resourceGroup, String scaleSet) {
        if (Utils.isEmpty(scaleSet)) {
            return String.format("%s/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Network/publicIPAddresses?api-version=%s", this.endpoint, subscriptionId, resourceGroup, API_VERSION);
        }
        return String.format("%s/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Compute/virtualMachineScaleSets/%s/publicIPAddresses?api-version=%s", this.endpoint, subscriptionId, resourceGroup, scaleSet, API_VERSION_SCALE_SET);
    }

    private Map<String, String> parsePublicIpResponse(String response) {
        HashMap<String, String> publicIps = new HashMap<String, String>();
        for (JsonValue item : AzureComputeApi.toJsonArray(Json.parse(response).asObject().get("value"))) {
            String id = item.asObject().getString("id", null);
            String ip = AzureComputeApi.toJsonObject(item.asObject().get("properties")).getString("ipAddress", null);
            if (Utils.isEmpty(ip)) continue;
            publicIps.put(id, ip);
        }
        return publicIps;
    }

    private static JsonArray toJsonArray(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonArray();
        }
        return jsonValue.asArray();
    }

    private static JsonObject toJsonObject(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.isNull()) {
            return new JsonObject();
        }
        return jsonValue.asObject();
    }
}

