/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.memory.GCStatsSupport;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;

public final class GarbageCollectionMetricSet {
    private static final int PUBLISH_FREQUENCY_SECONDS = 1;

    private GarbageCollectionMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        GcStats stats = new GcStats();
        metricsRegistry.scheduleAtFixedRate(stats, 1L, TimeUnit.SECONDS, ProbeLevel.INFO);
        metricsRegistry.registerStaticMetrics(stats, "gc");
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="used by instrumentation tools")
    static class GcStats
    implements Runnable {
        @Probe(name="minorCount", level=ProbeLevel.MANDATORY)
        volatile long minorCount;
        @Probe(name="minorTime", unit=ProbeUnit.MS, level=ProbeLevel.MANDATORY)
        volatile long minorTime;
        @Probe(name="majorCount", level=ProbeLevel.MANDATORY)
        volatile long majorCount;
        @Probe(name="majorTime", unit=ProbeUnit.MS, level=ProbeLevel.MANDATORY)
        volatile long majorTime;
        @Probe(name="unknownCount", level=ProbeLevel.MANDATORY)
        volatile long unknownCount;
        @Probe(name="unknownTime", unit=ProbeUnit.MS, level=ProbeLevel.MANDATORY)
        volatile long unknownTime;

        GcStats() {
        }

        @Override
        public void run() {
            long minorCount = 0L;
            long minorTime = 0L;
            long majorCount = 0L;
            long majorTime = 0L;
            long unknownCount = 0L;
            long unknownTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count == -1L) continue;
                if (GCStatsSupport.YOUNG_GC.contains(gc.getName())) {
                    minorCount += count;
                    minorTime += gc.getCollectionTime();
                    continue;
                }
                if (GCStatsSupport.OLD_GC.contains(gc.getName())) {
                    majorCount += count;
                    majorTime += gc.getCollectionTime();
                    continue;
                }
                unknownCount += count;
                unknownTime += gc.getCollectionTime();
            }
            this.minorCount = minorCount;
            this.minorTime = minorTime;
            this.majorCount = majorCount;
            this.majorTime = majorTime;
            this.unknownCount = unknownCount;
            this.unknownTime = unknownTime;
        }
    }
}

