/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateBuilder;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IdempotentPredicate
implements Predicate {
    public static final IdempotentPredicate INSTANCE = new IdempotentPredicate();
    private static final Set<HttpString> METHODS;

    @Override
    public boolean resolve(HttpServerExchange value) {
        return METHODS.contains(value.getRequestMethod());
    }

    public String toString() {
        return "idempotent()";
    }

    static {
        HashSet<HttpString> methods = new HashSet<HttpString>();
        methods.add(Methods.GET);
        methods.add(Methods.DELETE);
        methods.add(Methods.PUT);
        methods.add(Methods.HEAD);
        methods.add(Methods.OPTIONS);
        METHODS = Collections.unmodifiableSet(methods);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "idempotent";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            return INSTANCE;
        }
    }
}

