/*
 * Decompiled with CFR 0.152.
 */
package brave.jms;

import brave.Span;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.Message;

final class TracingCompletionListener
implements CompletionListener {
    final CompletionListener delegate;
    final CurrentTraceContext current;
    @Nullable
    final Destination destination;
    final Span span;

    static CompletionListener create(CompletionListener delegate, @Nullable Destination destination, Span span, CurrentTraceContext current) {
        return new TracingCompletionListener(delegate, destination, span, current);
    }

    TracingCompletionListener(CompletionListener delegate, Destination destination, Span span, CurrentTraceContext current) {
        this.delegate = delegate;
        this.destination = destination;
        this.span = span;
        this.current = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onCompletion(Message message) {
        try {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
            try {
                this.delegate.onCompletion(message);
                if (ws == null) return;
            }
            catch (Throwable throwable) {
                if (ws == null) throw throwable;
                try {
                    ws.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            ws.close();
            return;
        }
        finally {
            this.span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onException(Message message, Exception exception) {
        try {
            CurrentTraceContext.Scope ws = this.current.maybeScope(this.span.context());
            try {
                this.delegate.onException(message, exception);
                if (ws == null) return;
            }
            catch (Throwable throwable) {
                if (ws == null) throw throwable;
                try {
                    ws.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                }
                throw throwable;
            }
            ws.close();
            return;
        }
        finally {
            this.span.error((Throwable)exception);
            this.span.finish();
        }
    }
}

